/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.changes;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.n4js.ui.changes.IChange;

public interface IAtomicChange
extends IChange,
IRegion,
Comparable<IAtomicChange> {
    public URI getURI();

    public int getOffset();

    public int getLength();

    public void apply(IDocument var1) throws BadLocationException;

    public static abstract class AbstractAtomicChange
    extends IChange.AbstractChange
    implements IAtomicChange {
        private final URI uri;
        private final int offset;
        private final int length;

        public AbstractAtomicChange(URI uri, int offset, int length) {
            this.uri = uri.trimFragment();
            this.offset = offset;
            this.length = length;
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int compareTo(IAtomicChange other) {
            return Integer.compare(this.getOffset(), other.getOffset());
        }
    }
}

