/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.collections;

import com.google.common.collect.UnmodifiableListIterator;
import java.util.AbstractSequentialList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ComposedList<T>
extends AbstractSequentialList<T> {
    private final List<? extends T>[] lists;

    public static <T> List<T> compose(List<? extends T> l1, List<? extends T> l2) {
        return new ComposedList<T>(l1, l2);
    }

    public static <T> List<T> compose(List<? extends T> l1, List<? extends T> l2, List<? extends T> l3) {
        return new ComposedList<T>(l1, l2, l3);
    }

    public static <T> List<T> compose(List<? extends T> l1, List<? extends T> l2, List<? extends T> l3, List<? extends T> l4) {
        return new ComposedList<T>(l1, l2, l3, l4);
    }

    @SafeVarargs
    public ComposedList(List<? extends T> ... lists) {
        this.lists = lists;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (this.lists == null || this.lists.length == 0) {
            return Collections.emptyList().listIterator(index);
        }
        return new ComposedListIterator(index);
    }

    @Override
    public int size() {
        int size = 0;
        List<? extends T>[] listArray = this.lists;
        int n = this.lists.length;
        int n2 = 0;
        while (n2 < n) {
            List<T> l = listArray[n2];
            size += l.size();
            ++n2;
        }
        return size;
    }

    class ComposedListIterator
    extends UnmodifiableListIterator<T> {
        int prevList = 0;
        int nextList = 0;
        int currentIndex = 0;
        ListIterator<? extends T> nextIter = null;
        ListIterator<? extends T> prevIter = null;
        private int offset;

        ComposedListIterator(int index) {
            this.nextList = this.listIndexContainingElementWithIndex(index);
            if (this.nextList < 0) {
                this.nextIter = null;
                if (index > 0) {
                    this.prevList = this.listIndexContainingElementWithIndex(index - 1);
                    if (this.prevList >= 0) {
                        int listRelativeIndex = index - this.offset;
                        this.prevIter = ComposedList.this.lists[this.prevList].listIterator(listRelativeIndex);
                    }
                }
            } else {
                int listRelativeIndex = index - this.offset;
                this.nextIter = ComposedList.this.lists[this.nextList].listIterator(listRelativeIndex);
                if (listRelativeIndex > 0) {
                    this.prevList = this.nextList;
                    this.prevIter = this.nextIter;
                } else if (this.nextList > 0) {
                    this.prevList = this.nextList - 1;
                    this.prevIter = ComposedList.this.lists[this.prevList].listIterator(ComposedList.this.lists[this.prevList].size());
                }
            }
        }

        int listIndexContainingElementWithIndex(int index) {
            this.offset = 0;
            int listIdx = 0;
            while (listIdx < ComposedList.this.lists.length && ComposedList.this.lists[listIdx].size() + this.offset <= index) {
                this.offset += ComposedList.this.lists[listIdx].size();
                ++listIdx;
            }
            if (listIdx == ComposedList.this.lists.length) {
                return -1;
            }
            return listIdx;
        }

        public boolean hasNext() {
            return this.nextIter != null;
        }

        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object t = this.nextIter.next();
            ++this.currentIndex;
            this.prevIter = this.nextIter;
            this.prevList = this.nextList;
            while (this.nextIter != null && !this.nextIter.hasNext()) {
                if (this.nextList + 1 < ComposedList.this.lists.length) {
                    ++this.nextList;
                    this.nextIter = ComposedList.this.lists[this.nextList].listIterator();
                    continue;
                }
                this.nextIter = null;
            }
            return t;
        }

        public boolean hasPrevious() {
            return this.prevIter != null;
        }

        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object t = this.prevIter.previous();
            --this.currentIndex;
            this.nextIter = this.prevIter;
            this.nextList = this.prevList;
            while (this.prevIter != null && !this.prevIter.hasPrevious()) {
                if (this.prevList > 0) {
                    --this.prevList;
                    this.prevIter = ComposedList.this.lists[this.prevList].listIterator(ComposedList.this.lists[this.prevList].size());
                    continue;
                }
                this.prevIter = null;
            }
            return t;
        }

        public int nextIndex() {
            return this.currentIndex;
        }

        public int previousIndex() {
            return this.currentIndex - 1;
        }
    }
}

