/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class XMLEditorPluginImageHelper {
    private final String PLUGINID = "org.eclipse.wst.xml.ui";
    private static XMLEditorPluginImageHelper instance = null;
    public static final String EDITOR_MENU = "editor.xml_tabletree.menu";
    private static HashMap fImageDescRegistry = null;

    public static synchronized XMLEditorPluginImageHelper getInstance() {
        if (instance == null) {
            instance = new XMLEditorPluginImageHelper();
            XMLEditorPluginImageHelper.initializeRegistry();
        }
        return instance;
    }

    private static void initializeRegistry() {
        Display d = Display.getCurrent();
        Image viewMenu = new Image((Device)d, 11, 16);
        Image viewMenuMask = new Image((Device)d, 11, 16);
        GC gc = new GC((Drawable)viewMenu);
        GC maskgc = new GC((Drawable)viewMenuMask);
        XMLEditorPluginImageHelper.drawViewMenu(gc, maskgc);
        gc.dispose();
        maskgc.dispose();
        ImageData data = viewMenu.getImageData();
        data.transparentPixel = data.getPixel(0, 0);
        Image vm2 = new Image((Device)d, viewMenu.getImageData(), viewMenuMask.getImageData());
        viewMenu.dispose();
        viewMenuMask.dispose();
        XMLEditorPluginImageHelper.getImageRegistry().put(EDITOR_MENU, vm2);
        XMLEditorPluginImageHelper.getImageDescriptorRegistry().put(EDITOR_MENU, ImageDescriptor.createFromImage((Image)vm2));
    }

    private static void drawViewMenu(GC gc, GC maskgc) {
        Display display = Display.getCurrent();
        gc.setForeground(display.getSystemColor(17));
        gc.setBackground(display.getSystemColor(25));
        int[] shapeArray = new int[]{1, 1, 10, 1, 6, 5, 5, 5};
        gc.fillPolygon(shapeArray);
        gc.drawPolygon(shapeArray);
        Color black = display.getSystemColor(2);
        Color white = display.getSystemColor(1);
        maskgc.setBackground(black);
        maskgc.fillRectangle(0, 0, 12, 16);
        maskgc.setBackground(white);
        maskgc.setForeground(white);
        maskgc.fillPolygon(shapeArray);
        maskgc.drawPolygon(shapeArray);
    }

    public Image getImage(String resource) {
        Image image = XMLEditorPluginImageHelper.getImageRegistry().get(resource);
        if (image == null) {
            image = this.createImage(resource);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String resource) {
        ImageDescriptor imageDescriptor = null;
        Object o = XMLEditorPluginImageHelper.getImageDescriptorRegistry().get(resource);
        imageDescriptor = o == null ? this.createImageDescriptor(resource) : (ImageDescriptor)o;
        return imageDescriptor;
    }

    private static HashMap getImageDescriptorRegistry() {
        if (fImageDescRegistry == null) {
            fImageDescRegistry = new HashMap();
        }
        return fImageDescRegistry;
    }

    private static ImageRegistry getImageRegistry() {
        return JFaceResources.getImageRegistry();
    }

    private Image createImage(String resource) {
        ImageDescriptor desc = this.getImageDescriptor(resource);
        Image image = null;
        if (desc != null) {
            image = desc.createImage();
            if (!desc.equals(ImageDescriptor.getMissingImageDescriptor())) {
                XMLEditorPluginImageHelper.getImageRegistry().put(resource, image);
            }
        }
        return image;
    }

    private ImageDescriptor createImageDescriptor(String imageFilePath) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.xml.ui", (String)imageFilePath);
        if (imageDescriptor != null) {
            XMLEditorPluginImageHelper.getImageDescriptorRegistry().put(imageFilePath, imageDescriptor);
        } else {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }
}

