/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.product;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.n4js.product.N4JSApplicationWorkbenchAdvisor;
import org.eclipse.n4js.product.N4ProductActivator;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class N4JSApplication
implements IApplication {
    public static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME = "org.eclipse.platform";
    private static final Version WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION;
    private static final String WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME_LEGACY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_CHECK_LEGACY_VERSION_INCREMENTED = "2";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final Integer EXIT_RELAUNCH;
    private static final Integer EXIT_WORKSPACE_LOCKED;
    public static final String PLUGIN_ID = "org.eclipse.ui.ide.application";

    static {
        Bundle bundle = Platform.getBundle((String)WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME);
        WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION = bundle != null ? bundle.getVersion() : null;
        EXIT_RELAUNCH = new Integer(24);
        EXIT_WORKSPACE_LOCKED = new Integer(15);
    }

    public Object start(IApplicationContext appContext) throws Exception {
        Display display = PlatformUI.createDisplay();
        try {
            Object instanceLocationCheck;
            Shell shell = WorkbenchPlugin.getSplashShell((Display)display);
            if (shell != null) {
                shell.setText(ChooseWorkspaceDialog.getWindowTitle());
                shell.setImages(Window.getDefaultImages());
            }
            if ((instanceLocationCheck = this.checkInstanceLocation(shell, appContext.getArguments())) != null) {
                WorkbenchPlugin.unsetSplashShell((Display)display);
                appContext.applicationRunning();
                Object object = instanceLocationCheck;
                return object;
            }
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new N4JSApplicationWorkbenchAdvisor());
            if (returnCode != 1) {
                Integer n = EXIT_OK;
                return n;
            }
            Integer n = EXIT_RELAUNCH.equals(Integer.getInteger(PROP_EXIT_CODE)) ? EXIT_RELAUNCH : EXIT_RESTART;
            return n;
        }
        finally {
            Location instanceLoc;
            if (display != null) {
                display.dispose();
            }
            if ((instanceLoc = Platform.getInstanceLocation()) != null) {
                instanceLoc.release();
            }
        }
    }

    private Object checkInstanceLocation(Shell shell, Map<?, ?> applicationArguments) {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceMandatoryTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceMandatoryMessage);
            return EXIT_OK;
        }
        if (instanceLoc.isSet()) {
            block15: {
                if (!this.checkValidWorkspace(shell, instanceLoc.getURL())) {
                    return EXIT_OK;
                }
                if (!instanceLoc.lock()) break block15;
                N4JSApplication.writeWorkspaceVersion();
                return null;
            }
            try {
                File workspaceDirectory = new File(instanceLoc.getURL().getFile());
                if (workspaceDirectory.exists()) {
                    if (N4JSApplication.isDevLaunchMode(applicationArguments)) {
                        return EXIT_WORKSPACE_LOCKED;
                    }
                    MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotLockTitle, (String)NLS.bind((String)IDEWorkbenchMessages.IDEApplication_workspaceCannotLockMessage, (Object)workspaceDirectory.getAbsolutePath()));
                } else {
                    MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
                }
            }
            catch (IOException e) {
                N4ProductActivator.log("Could not obtain lock for workspace location", e);
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.InternalError, (String)e.getMessage());
            }
            return EXIT_OK;
        }
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(instanceLoc.getDefault());
        boolean force = false;
        URL workspaceUrl;
        while ((workspaceUrl = this.promptForWorkspace(shell, launchData, force)) != null) {
            force = true;
            try {
                if (instanceLoc.set(workspaceUrl, true)) {
                    launchData.writePersistedData();
                    N4JSApplication.writeWorkspaceVersion();
                    return null;
                }
            }
            catch (IllegalStateException e) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
                return EXIT_OK;
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
            }
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceInUseTitle, (String)NLS.bind((String)IDEWorkbenchMessages.IDEApplication_workspaceInUseMessage, (Object)workspaceUrl.getFile()));
        }
        return EXIT_OK;
    }

    private static boolean isDevLaunchMode(Map<?, ?> args) {
        if (Boolean.getBoolean("eclipse.pde.launch")) {
            return true;
        }
        return args.containsKey("-pdelaunch");
    }

    private URL promptForWorkspace(Shell shell, ChooseWorkspaceData launchData, boolean force) {
        URL url = null;
        do {
            new ChooseWorkspaceDialog(shell, launchData, false, true).prompt(force);
            String instancePath = launchData.getSelection();
            if (instancePath == null) {
                return null;
            }
            force = true;
            if (instancePath.length() <= 0) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceEmptyTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceEmptyMessage);
                continue;
            }
            File workspace = new File(instancePath);
            if (!workspace.exists()) {
                workspace.mkdir();
            }
            try {
                String path = workspace.getAbsolutePath().replace(File.separatorChar, '/');
                url = new URL("file", null, path);
            }
            catch (MalformedURLException e) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceInvalidTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceInvalidMessage);
            }
        } while (!this.checkValidWorkspace(shell, url));
        return url;
    }

    private boolean checkValidWorkspace(Shell shell, URL url) {
        String message;
        String title;
        int severity;
        if (url == null) {
            return false;
        }
        if (WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION == null) {
            return true;
        }
        Version version = N4JSApplication.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        Version ide_version = N4JSApplication.toMajorMinorVersion(WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION);
        Version workspace_version = N4JSApplication.toMajorMinorVersion(version);
        int versionCompareResult = workspace_version.compareTo(ide_version);
        if (versionCompareResult == 0) {
            return true;
        }
        if (versionCompareResult < 0) {
            severity = 2;
            title = IDEWorkbenchMessages.IDEApplication_versionTitle_olderWorkspace;
            message = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_versionMessage_olderWorkspace, (Object)url.getFile());
        } else {
            severity = 4;
            title = IDEWorkbenchMessages.IDEApplication_versionTitle_newerWorkspace;
            message = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_versionMessage_newerWorkspace, (Object)url.getFile());
        }
        MessageDialog dialog = new MessageDialog(shell, title, null, message, severity, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        return dialog.open() == 0;
    }

    private static Version readWorkspaceVersion(URL workspace) {
        File versionFile = N4JSApplication.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(versionFile);){
                props.load(is);
            }
            String versionString = props.getProperty(WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME);
            if (versionString != null) {
                return Version.parseVersion((String)versionString);
            }
            versionString = props.getProperty(WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME_LEGACY);
            if (versionString != null) {
                return Version.parseVersion((String)versionString);
            }
            return null;
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)("Could not read version file " + versionFile), (IStatus)new Status(4, "org.eclipse.ui.ide", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            return null;
        }
        catch (IllegalArgumentException e) {
            IDEWorkbenchPlugin.log((String)("Could not parse version in " + versionFile), (IStatus)new Status(4, "org.eclipse.ui.ide", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            return null;
        }
    }

    private static void writeWorkspaceVersion() {
        if (WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION == null) {
            return;
        }
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null || instanceLoc.isReadOnly()) {
            return;
        }
        File versionFile = N4JSApplication.getVersionFile(instanceLoc.getURL(), true);
        if (versionFile == null) {
            return;
        }
        FileOutputStream output = null;
        try {
            try {
                output = new FileOutputStream(versionFile);
                Properties props = new Properties();
                props.setProperty(WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME, WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION.toString());
                props.setProperty(WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME_LEGACY, WORKSPACE_CHECK_LEGACY_VERSION_INCREMENTED);
                props.store(output, null);
            }
            catch (IOException e) {
                IDEWorkbenchPlugin.log((String)"Could not write version file", (IStatus)StatusUtil.newStatus((int)4, (String)e.getMessage(), (Throwable)e));
                try {
                    if (output != null) {
                        ((OutputStream)output).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (output != null) {
                    ((OutputStream)output).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }

    private static Version toMajorMinorVersion(Version version) {
        return new Version(version.getMajor(), version.getMinor(), 0);
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

