/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow;

import java.util.Collection;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitorInternal;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.flowgraphs.dataflow.AssignmentRelationFactory;
import org.eclipse.n4js.flowgraphs.dataflow.Assumption;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowBranchWalker;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowGraphExplorer;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitor;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class DataFlowVisitorHost
extends GraphVisitorInternal {
    final Collection<DataFlowVisitor> dfVisitors;
    private DataFlowGraphExplorer dfExplorer;
    private AssignmentRelationFactory assignmentFactory;

    public DataFlowVisitorHost(TraverseDirection direction, Collection<DataFlowVisitor> dfVisitors) {
        super(direction);
        this.dfVisitors = dfVisitors;
    }

    protected final SymbolFactory getSymbolFactory() {
        return this.flowAnalyzer.getSymbolFactory();
    }

    protected final AssignmentRelationFactory getAssignmentRelationFactory() {
        return this.assignmentFactory;
    }

    @Override
    protected void initializeContainerInternal(ControlFlowElement curContainer) {
        for (DataFlowVisitor dfVisitor : this.dfVisitors) {
            dfVisitor.setSymbolFactory(this.getSymbolFactory());
        }
        this.dfExplorer = new DataFlowGraphExplorer(this);
        this.assignmentFactory = new AssignmentRelationFactory(this.getSymbolFactory());
        this.requestActivation(this.dfExplorer);
    }

    @Override
    protected void terminateContainer(ControlFlowElement curContainer) {
        DataFlowBranchWalker dfb = (DataFlowBranchWalker)this.dfExplorer.getLastBranch();
        for (Assumption ass : dfb.assumptions.values()) {
            ass.terminate();
        }
    }
}

