/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.compare;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.compare.ApiImplMapping;
import org.eclipse.n4js.compare.ProjectCompareResult;
import org.eclipse.n4js.compare.ProjectComparison;
import org.eclipse.n4js.compare.ProjectComparisonEntry;
import org.eclipse.n4js.internal.MultiCleartriggerCache;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMemberWithAccessModifier;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeAccessModifier;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.util.AccessModifiers;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.ITypeReplacementProvider;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.FindArtifactHelper;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;

public class ProjectCompareHelper {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private FindArtifactHelper artifactHelper;
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private N4JSTypeSystem typeSystem;
    @Inject
    private MultiCleartriggerCache cache;
    private static Logger logger = Logger.getLogger(ProjectCompareHelper.class);

    public ProjectComparison createComparison(boolean fullCompare, List<String> addErrorMessagesHere) {
        ResourceSet resourceSet = this.n4jsCore.createResourceSet((Optional<IN4JSProject>)Optional.absent());
        IResourceDescriptions index = this.n4jsCore.getXtextIndex(resourceSet);
        ApiImplMapping mapping = ApiImplMapping.of(this.n4jsCore);
        if (mapping.hasErrors()) {
            if (addErrorMessagesHere != null) {
                addErrorMessagesHere.addAll(mapping.getErrorMessages());
            }
            return null;
        }
        List<String> allImplIds = mapping.getAllImplIds();
        int implCount = allImplIds.size();
        ProjectComparison root = new ProjectComparison(allImplIds.toArray(new String[implCount]));
        for (String currApiId : mapping.getApiIds()) {
            IN4JSProject currApi = mapping.getApi(currApiId);
            IN4JSProject[] currImpls = new IN4JSProject[implCount];
            int idx = 0;
            while (idx < implCount) {
                String currImplId = allImplIds.get(idx);
                currImpls[idx] = mapping.getImpl(currApiId, currImplId);
                ++idx;
            }
            this.createEntries(root, currApi, currImpls, resourceSet, index);
        }
        if (fullCompare) {
            root.getAllEntries().forEach(currE -> {
                int implIdx = 0;
                while (implIdx < implCount) {
                    this.compareApiImpl((ProjectComparisonEntry)currE, implIdx);
                    ++implIdx;
                }
            });
        }
        return root;
    }

    private ProjectComparisonEntry createEntries(ProjectComparison root, IN4JSProject api, IN4JSProject[] impls, ResourceSet resourceSet, IResourceDescriptions index) {
        ProjectComparisonEntry entry = new ProjectComparisonEntry(root, api, impls);
        for (IN4JSSourceContainer currSrcConti : api.getSourceContainers()) {
            for (URI uri : currSrcConti) {
                IResourceDescription resDesc;
                TModule moduleApi;
                String uriStr = uri.toString();
                if (!uriStr.endsWith(".n4js") && !uriStr.endsWith(".n4jsd") || (moduleApi = this.getModuleFrom(resourceSet, resDesc = index.getResourceDescription(uri))) == null) continue;
                TModule[] moduleImpls = new TModule[impls.length];
                int idx = 0;
                while (idx < impls.length) {
                    IN4JSProject projectImpl = impls[idx];
                    moduleImpls[idx] = projectImpl != null ? this.findImplementation(moduleApi, projectImpl, resourceSet, index) : null;
                    ++idx;
                }
                this.createEntries(entry, -1, (EObject)moduleApi, (EObject[])moduleImpls, false);
            }
        }
        return entry;
    }

    public Optional<String> getImplementationID(TModule apiImplModule) {
        Optional<? extends IN4JSProject> opt = this.n4jsCore.findProject(apiImplModule.eResource().getURI());
        IN4JSProject implProject = (IN4JSProject)opt.get();
        return implProject.getImplementationId();
    }

    public ProjectComparisonEntry compareModules(TModule apiImplModule) {
        Optional<String> implID = this.getImplementationID(apiImplModule);
        if (implID.isPresent()) {
            return this.compareModules(apiImplModule, (String)implID.get());
        }
        return null;
    }

    public ProjectComparisonEntry compareModules(TModule module, String implementationID) {
        return this.compareModules(module, implementationID, false);
    }

    public ProjectComparisonEntry compareModules(TModule module, String implementationID, boolean includePolyfills) {
        Optional<? extends IN4JSProject> opt = this.n4jsCore.findProject(module.eResource().getURI());
        if (!opt.isPresent()) {
            return null;
        }
        IN4JSProject project = (IN4JSProject)opt.get();
        IN4JSProject implProject = null;
        IN4JSProject apiProject = null;
        TModule apiModule = null;
        TModule apiImplModule = null;
        if (!project.getImplementationId().isPresent()) {
            ApiImplMappingSupplier supplier = new ApiImplMappingSupplier(this.n4jsCore);
            ApiImplMapping mapping = this.cache.get(supplier, "API_IMPL_MAPPING");
            implProject = mapping.getImpl(project.getProjectName(), implementationID);
            if (implProject == null) {
                return null;
            }
            apiProject = project;
            apiModule = module;
            URI impUri = this.artifactHelper.findArtifact(implProject, apiModule.getQualifiedName(), (Optional<String>)Optional.of((Object)"n4js"));
            if (impUri != null) {
                IResourceDescriptions xtextIndex = this.n4jsCore.getXtextIndex(module.eResource().getResourceSet());
                IResourceDescription resourceDescription = xtextIndex.getResourceDescription(impUri);
                if (resourceDescription != null) {
                    apiImplModule = this.n4jsCore.loadModuleFromIndex(module.eResource().getResourceSet(), resourceDescription, false);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("...ouch nothing in index for " + impUri));
                    }
                    Resource implResource = module.eResource().getResourceSet().getResource(impUri, true);
                    apiImplModule = (TModule)implResource.getContents().get(1);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("TModule loaded from Resource: " + apiImplModule));
                    }
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("No implementation given. For " + apiModule.getQualifiedName()));
            }
        } else if (implementationID.equals(project.getImplementationId().get())) {
            implProject = project;
            apiImplModule = module;
            ImmutableList<? extends IN4JSProject> apiProjects = implProject.getImplementedProjects();
            for (IN4JSProject ap : apiProjects) {
                IResourceDescriptions xtextIndex;
                IResourceDescription resourceDescription;
                URI apiURI = this.artifactHelper.findArtifact(ap, apiImplModule.getQualifiedName(), (Optional<String>)Optional.of((Object)"n4jsd"));
                if (apiURI == null || (resourceDescription = (xtextIndex = this.n4jsCore.getXtextIndex(apiImplModule.eResource().getResourceSet())).getResourceDescription(apiURI)) == null || (apiModule = this.n4jsCore.loadModuleFromIndex(apiImplModule.eResource().getResourceSet(), resourceDescription, false)) == null) {
                    continue;
                }
                break;
            }
        } else {
            return null;
        }
        if (apiModule != null) {
            return this.compareModules(apiProject, apiModule, implProject, apiImplModule, includePolyfills);
        }
        return null;
    }

    public ProjectComparisonEntry compareModules(IN4JSProject apiProject, TModule api, IN4JSProject implProject, TModule impl, boolean includePolyfills) {
        ProjectComparison projectComparison = new ProjectComparison(new String[]{(String)implProject.getImplementationId().orNull()});
        ProjectComparisonEntry dummyParent = new ProjectComparisonEntry(projectComparison, apiProject, implProject);
        ProjectComparisonEntry ret = this.createEntries(dummyParent, -1, (EObject)api, new EObject[]{impl}, includePolyfills);
        return ret;
    }

    private ProjectComparisonEntry createEntries(ProjectComparisonEntry parent, int index, EObject api, EObject[] impls, boolean includePolyfills) {
        ProjectComparisonEntry entry = new ProjectComparisonEntry(parent, index, api, impls);
        EObject[] childrenOfApi = this.computeChildren(api, false, false, includePolyfills);
        EObject[][] childrenOfImpls = this.computeChildren(impls, false, true, includePolyfills);
        HashSet<EObject> doneImpl = new HashSet<EObject>();
        EObject[] eObjectArray = childrenOfApi;
        int n = childrenOfApi.length;
        int n2 = 0;
        while (n2 < n) {
            EObject childApi = eObjectArray[n2];
            EObject[] implsForChildApi = this.computeMatches(childApi, childrenOfImpls, doneImpl);
            if (childApi instanceof TMember) {
                int idxImpl = 0;
                while (idxImpl < impls.length) {
                    EObject currImpl;
                    if (implsForChildApi[idxImpl] == null && (currImpl = impls[idxImpl]) instanceof ContainerType) {
                        implsForChildApi[idxImpl] = this.computeMatch(childApi, this.computeChildren(currImpl, true, true, includePolyfills), doneImpl);
                    }
                    ++idxImpl;
                }
            }
            this.createEntries(entry, -1, childApi, implsForChildApi, includePolyfills);
            ++n2;
        }
        int idxImpl = 0;
        while (idxImpl < impls.length) {
            EObject[] childrenOfCurrImpl = childrenOfImpls[idxImpl];
            int idxChild = 0;
            while (idxChild < childrenOfCurrImpl.length) {
                EObject childImpl = childrenOfCurrImpl[idxChild];
                if (!doneImpl.contains(childImpl)) {
                    EObject[] implsForChildImpl = this.computeMatches(childImpl, childrenOfImpls, doneImpl);
                    int idxSib = idxChild - 1;
                    EObject siblingImpl = idxSib >= 0 ? childrenOfCurrImpl[idxSib] : null;
                    ProjectComparisonEntry siblingEntry = siblingImpl != null ? entry.getChildForElementImpl(siblingImpl) : null;
                    int insertIdx = siblingEntry != null ? entry.getChildIndex(siblingEntry) + 1 : 0;
                    this.createEntries(entry, insertIdx, null, implsForChildImpl, includePolyfills);
                }
                ++idxChild;
            }
            ++idxImpl;
        }
        return entry;
    }

    private TModule findImplementation(TModule moduleApi, IN4JSProject projectImpl, ResourceSet resourceSet, IResourceDescriptions index) {
        String fqnStr = moduleApi.getQualifiedName();
        URI uri = this.artifactHelper.findArtifact(projectImpl, fqnStr, (Optional<String>)Optional.of((Object)"n4js"));
        if (uri == null) {
            return null;
        }
        IResourceDescription resDesc = index.getResourceDescription(uri);
        if (resDesc == null) {
            return null;
        }
        TModule moduleImpl = this.getModuleFrom(resourceSet, resDesc);
        return moduleImpl;
    }

    private EObject[][] computeChildren(EObject[] elems, boolean includeInheritedMembers, boolean includeNonPublic, boolean includePolyfills) {
        int len = elems.length;
        EObject[][] result = new EObject[elems.length][];
        int idx = 0;
        while (idx < len) {
            result[idx] = this.computeChildren(elems[idx], includeInheritedMembers, includeNonPublic, includePolyfills);
            ++idx;
        }
        return result;
    }

    private EObject[] computeChildren(EObject elem, boolean includeInheritedMembers, boolean includeNonPublic, boolean includePolyfills) {
        if (elem instanceof TModule) {
            return (EObject[])((TModule)elem).getTopLevelTypes().stream().filter(e -> includeNonPublic || ProjectCompareHelper.isPublicOrPublicInternal((EObject)e)).toArray(EObject[]::new);
        }
        if (elem instanceof ContainerType) {
            ContainerType elemCasted = (ContainerType)elem;
            return (EObject[])this.containerTypesHelper.fromContext(elem).allMembers(elemCasted, false, includePolyfills, includeInheritedMembers).stream().filter(e -> includeNonPublic || ProjectCompareHelper.isPublicOrPublicInternal((EObject)e)).toArray(EObject[]::new);
        }
        if (elem instanceof TEnum) {
            EList literals = ((TEnum)elem).getLiterals();
            return (EObject[])literals.toArray((Object[])new EObject[literals.size()]);
        }
        return new EObject[0];
    }

    private EObject[] computeMatches(EObject elemToMatch, EObject[][] candidates, Set<EObject> ignore) {
        EObject[] result = new EObject[candidates.length];
        int idx = 0;
        while (idx < candidates.length) {
            EObject match;
            result[idx] = match = this.computeMatch(elemToMatch, candidates[idx], ignore);
            if (match != null) {
                ignore.add(match);
            }
            ++idx;
        }
        return result;
    }

    private EObject computeMatch(EObject elemToMatch, EObject[] candidates, Set<EObject> ignore) {
        String elemName = ProjectCompareHelper.computeName(elemToMatch);
        if (elemName == null || elemName.trim().isEmpty()) {
            return null;
        }
        int elemKind = ProjectCompareHelper.accessorKind(elemToMatch);
        return Stream.of(candidates).filter(obj -> !ignore.contains(obj) && elemName.equals(ProjectCompareHelper.computeName(obj)) && elemKind == ProjectCompareHelper.accessorKind(obj)).findFirst().orElse(null);
    }

    private static final int accessorKind(EObject obj) {
        if (obj instanceof TSetter) {
            return 1;
        }
        if (obj instanceof TGetter) {
            return 2;
        }
        return 0;
    }

    private static final String computeName(EObject elem) {
        if (elem instanceof IdentifiableElement) {
            return ((IdentifiableElement)elem).getName();
        }
        return null;
    }

    private TModule getModuleFrom(ResourceSet resourceSet, IResourceDescription resDesc) {
        if (resDesc != null) {
            return this.n4jsCore.loadModuleFromIndex(resourceSet, resDesc, false);
        }
        return null;
    }

    public ProjectCompareResult compareApiImpl(ProjectComparisonEntry entry, int implIdx) {
        ProjectCompareResult cached = entry.getCachedCompareResult(implIdx);
        if (cached != null) {
            return cached;
        }
        ProjectCompareResult result = this.internalCompareApiImpl(entry, implIdx);
        entry.storeCachedCompareResult(implIdx, result);
        return result;
    }

    private ProjectCompareResult internalCompareApiImpl(ProjectComparisonEntry entry, int implIdx) {
        boolean isEqual;
        if (!entry.isElementEntry()) {
            return ProjectCompareResult.equal(new String[0]);
        }
        int implCount = entry.getImplCount();
        if (implIdx < 0 || implIdx >= implCount) {
            return ProjectCompareResult.equal(new String[0]);
        }
        EObject api = entry.getElementAPI();
        EObject impl = entry.getElementImpl()[implIdx];
        if (api == null) {
            if (impl != null) {
                return ProjectCompareResult.compliant(new String[0]);
            }
            return ProjectCompareResult.equal(new String[0]);
        }
        if (impl == null) {
            return ProjectCompareResult.error("missing implementation");
        }
        if (api instanceof TMember && impl instanceof TMember) {
            if (AccessModifiers.less((TMember)((TMember)impl), (TMember)((TMember)api))) {
                return ProjectCompareResult.error("reduced visibility");
            }
        } else if (api instanceof Type && impl instanceof Type) {
            MemberAccessModifier apiAcc = AccessModifiers.toMemberModifier((Type)((Type)api));
            MemberAccessModifier implAcc = AccessModifiers.toMemberModifier((Type)((Type)impl));
            if (AccessModifiers.less((MemberAccessModifier)implAcc, (MemberAccessModifier)apiAcc)) {
                return ProjectCompareResult.error("reduced visibility");
            }
        }
        ImplToApiReplacementProvider typeReplacementProvider = new ImplToApiReplacementProvider(entry.getRoot());
        if (api instanceof TMember && impl instanceof TMember) {
            boolean isEqualType;
            TMember apiMember = (TMember)api;
            TMember implMember = (TMember)impl;
            if (apiMember instanceof TField) {
                boolean bAPIProvidesInitializer = AnnotationDefinition.PROVIDES_INITIALZER.hasAnnotation((TAnnotableElement)apiMember);
                if (bAPIProvidesInitializer && !this.hasInitializer(impl)) {
                    if (bAPIProvidesInitializer) {
                        return ProjectCompareResult.error("no initializer in implementation but @" + AnnotationDefinition.PROVIDES_INITIALZER.name + " in API");
                    }
                    return ProjectCompareResult.error("initializer in implementation but no @" + AnnotationDefinition.PROVIDES_INITIALZER.name + " in API)");
                }
            } else {
                boolean bAPIProvidesDefImpl = AnnotationDefinition.PROVIDES_DEFAULT_IMPLEMENTATION.hasAnnotation((TAnnotableElement)apiMember);
                if (bAPIProvidesDefImpl != ProjectCompareHelper.hasBody(impl) && apiMember.eContainer() instanceof TInterface) {
                    if (bAPIProvidesDefImpl) {
                        return ProjectCompareResult.error("no body in implementation but @" + AnnotationDefinition.PROVIDES_DEFAULT_IMPLEMENTATION.name + " in API");
                    }
                    return ProjectCompareResult.error("body in implementation but no @" + AnnotationDefinition.PROVIDES_DEFAULT_IMPLEMENTATION.name + " in API");
                }
            }
            ParameterizedTypeRef context = TypeUtils.createTypeRef((Type)((Type)api.eContainer()), (TypeArgument[])new TypeArgument[0]);
            TypeRef typeApi = this.typeSystem.tau((TypableElement)apiMember, (TypeRef)context);
            TypeRef typeImpl = this.typeSystem.tau((TypableElement)implMember, (TypeRef)context);
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment(api);
            RuleEnvironmentExtensions.setTypeReplacement(G, typeReplacementProvider);
            Result implSubtypeApi = this.typeSystem.subtype(G, (TypeArgument)typeImpl, (TypeArgument)typeApi);
            Result apiSubtypeImpl = this.typeSystem.subtype(G, (TypeArgument)typeApi, (TypeArgument)typeImpl);
            boolean isImplSubtypeApi = !implSubtypeApi.isFailure();
            boolean isApiSubtypeImpl = !apiSubtypeImpl.isFailure();
            boolean bl = isEqualType = isImplSubtypeApi && isApiSubtypeImpl;
            if (!isEqualType) {
                if (isImplSubtypeApi) {
                    return ProjectCompareResult.compliant(new String[0]);
                }
                String msg = implSubtypeApi.getFailureMessage();
                return ProjectCompareResult.error(msg);
            }
            if (ProjectCompareHelper.isSpecialCaseOfHiddenMethodDiff(api, impl)) {
                return ProjectCompareResult.compliant(new String[0]);
            }
            return ProjectCompareResult.equal(new String[0]);
        }
        if (api instanceof TClassifier && impl instanceof TClassifier) {
            TClassifier apiClassifier = (TClassifier)api;
            TClassifier implClassifier = (TClassifier)impl;
            EList apiTypeVars = apiClassifier.getTypeVars();
            EList implTypeVars = implClassifier.getTypeVars();
            if (apiTypeVars.size() != implTypeVars.size()) {
                return ProjectCompareResult.error("the number of type variables doesn't match");
            }
            RuleEnvironment ruleEnvironment = RuleEnvironmentExtensions.newRuleEnvironment(api);
            RuleEnvironmentExtensions.setTypeReplacement(ruleEnvironment, typeReplacementProvider);
            int i = 0;
            while (i < apiTypeVars.size()) {
                TypeRef implDeclaredUpperBound;
                TypeVariable apiTypeVar = (TypeVariable)apiTypeVars.get(i);
                TypeVariable implTypeVar = (TypeVariable)implTypeVars.get(i);
                TypeRef apiDeclaredUpperBound = apiTypeVar.getDeclaredUpperBound();
                if (apiDeclaredUpperBound != null != ((implDeclaredUpperBound = implTypeVar.getDeclaredUpperBound()) != null) || apiDeclaredUpperBound != null && implDeclaredUpperBound != null && !this.typeSystem.equaltypeSucceeded(ruleEnvironment, (TypeArgument)apiDeclaredUpperBound, (TypeArgument)implDeclaredUpperBound)) {
                    return ProjectCompareResult.error(String.format("the upper bound of type variable %s isn't compatible with the API", implTypeVar.getName()));
                }
                ++i;
            }
            return ProjectCompareResult.equal(new String[0]);
        }
        String textApi = entry.getTextAPI();
        String textImpl = entry.getTextImpl(implIdx);
        boolean bl = textApi != null ? textApi.equals(textImpl) : (isEqual = textImpl == null);
        if (!isEqual) {
            return ProjectCompareResult.error(String.valueOf(textImpl) + " is not equal to " + textApi);
        }
        return ProjectCompareResult.equal(new String[0]);
    }

    private static boolean isSpecialCaseOfHiddenMethodDiff(EObject api, EObject impl) {
        if (api instanceof TMethod && impl instanceof TMethod) {
            EList apiFpars = ((TMethod)api).getFpars();
            EList implFpars = ((TMethod)impl).getFpars();
            int apiSize = apiFpars.size();
            int implSize = implFpars.size();
            if (implSize != apiSize) {
                int start = Math.min(apiSize, implSize);
                int end = Math.max(apiSize, implSize);
                EList fpars = implSize < apiSize ? apiFpars : implFpars;
                int i = start;
                while (i < end) {
                    if (!((TFormalParameter)fpars.get(i)).isOptional()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isPublicOrPublicInternal(EObject elem) {
        if (elem instanceof TMemberWithAccessModifier) {
            MemberAccessModifier acc = ((TMemberWithAccessModifier)elem).getMemberAccessModifier();
            return acc == MemberAccessModifier.PUBLIC || acc == MemberAccessModifier.PUBLIC_INTERNAL;
        }
        if (elem instanceof Type) {
            TypeAccessModifier acc = ((Type)elem).getTypeAccessModifier();
            return acc == TypeAccessModifier.PUBLIC || acc == TypeAccessModifier.PUBLIC_INTERNAL;
        }
        return true;
    }

    private static final boolean hasBody(EObject element) {
        return (element instanceof TMethod || element instanceof FieldAccessor) && !((TMemberWithAccessModifier)element).isHasNoBody();
    }

    private boolean hasInitializer(EObject element) {
        return element instanceof TField && ((TField)element).isHasExpression();
    }

    private static class ApiImplMappingSupplier
    implements MultiCleartriggerCache.CleartriggerSupplier<ApiImplMapping> {
        private final IN4JSCore n4jsCore;

        private ApiImplMappingSupplier(IN4JSCore n4jsCore) {
            this.n4jsCore = n4jsCore;
        }

        @Override
        public ApiImplMapping get() {
            return ApiImplMapping.of(this.n4jsCore);
        }

        @Override
        public Collection<URI> getCleartriggers() {
            LinkedList<URI> allPckjsons = new LinkedList<URI>();
            for (IN4JSProject prj : this.n4jsCore.findAllProjects()) {
                URI pckjsonUri = prj.getLocation();
                if (pckjsonUri == null) continue;
                allPckjsons.add(pckjsonUri);
            }
            return allPckjsons;
        }
    }

    private static final class ImplToApiReplacementProvider
    implements ITypeReplacementProvider {
        private final ProjectComparison comparison;

        public ImplToApiReplacementProvider(ProjectComparison comparison) {
            this.comparison = comparison;
        }

        @Override
        public <T extends Type> T getReplacement(T type) {
            if (type instanceof TypeVariable) {
                int idxOfTypeInParent;
                ContainerType parentCasted;
                ContainerType parentReplacement;
                EObject parent = type.eContainer();
                if (parent instanceof ContainerType && (parentReplacement = this.getReplacement(parentCasted = (ContainerType)parent)) != null && (idxOfTypeInParent = parentCasted.getTypeVars().indexOf(type)) >= 0 && idxOfTypeInParent < parentReplacement.getTypeVars().size()) {
                    return (T)((Type)parentReplacement.getTypeVars().get(idxOfTypeInParent));
                }
                return null;
            }
            ProjectComparisonEntry entry = this.comparison.getEntryForObject(type);
            return (T)(entry != null ? (Type)entry.getElementAPI() : null);
        }
    }
}

