/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

@Singleton
public class XpectAwareFileExtensionCalculator {
    public String getXpectAwareFileExtension(EObject eob) {
        if (eob == null || eob.eResource() == null) {
            return "";
        }
        return this.getXpectAwareFileExtension(eob.eResource().getURI());
    }

    public String getXpectAwareFileExtension(URI uri) {
        if (uri == null) {
            return "";
        }
        return this.getXpectAwareFileExtensionOrEmpty(uri);
    }

    public String getFilenameWithoutXpectExtension(URI uri) {
        String _xpectAwareFileExtension;
        boolean _notEquals;
        String _fileExtension = uri.fileExtension();
        boolean bl = _notEquals = !Objects.equal((Object)_fileExtension, (Object)(_xpectAwareFileExtension = this.getXpectAwareFileExtension(uri)));
        if (_notEquals) {
            return uri.trimFileExtension().lastSegment();
        }
        return uri.lastSegment();
    }

    private String getXpectAwareFileExtensionOrEmpty(URI uri) {
        String ext = uri.fileExtension();
        boolean _equals = "xt".equals(ext);
        if (_equals) {
            ext = uri.trimFileExtension().fileExtension();
        }
        return Strings.nullToEmpty((String)ext);
    }
}

