/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.model.AbstractEdge;
import org.eclipse.n4js.flowgraphs.model.JumpToken;
import org.eclipse.n4js.flowgraphs.model.Node;

public class ControlFlowEdge
extends AbstractEdge
implements Comparable<ControlFlowEdge> {
    public final ControlFlowType cfType;
    public final JumpToken finallyPathContext;

    public ControlFlowEdge(Node start, Node end) {
        this(start, end, ControlFlowType.Successor);
    }

    public ControlFlowEdge(Node start, Node end, ControlFlowType cfType) {
        super(start, end);
        boolean correctEdgeDirection = cfType.isBackwards() == start.astPosition > end.astPosition;
        Preconditions.checkState((boolean)correctEdgeDirection, (Object)"Edge has wrong direction");
        this.finallyPathContext = null;
        this.cfType = cfType;
    }

    public ControlFlowEdge(Node start, Node end, JumpToken finallyPathContext) {
        super(start, end);
        this.finallyPathContext = finallyPathContext;
        this.cfType = finallyPathContext.cfType;
    }

    @Override
    public int compareTo(ControlFlowEdge edge) {
        int result = ComparisonChain.start().compare(this.start.id, edge.start.id).compare(this.end.id, edge.end.id).result();
        return result;
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.start.getExtendedString();
        if (this.cfType != ControlFlowType.Successor) {
            s = String.valueOf(s) + "-" + this.cfType.name();
        }
        s = String.valueOf(s) + "-> ";
        s = String.valueOf(s) + this.end.getExtendedString();
        return s;
    }
}

