/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.debug.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.ant.internal.launching.AntLaunching;
import org.eclipse.ant.internal.launching.debug.IAntDebugController;
import org.eclipse.ant.internal.launching.debug.model.AntDebugTarget;
import org.eclipse.ant.internal.launching.debug.model.AntThread;
import org.eclipse.ant.internal.launching.launchConfigurations.RemoteAntBuildListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IProcess;

public class RemoteAntDebugBuildListener
extends RemoteAntBuildListener
implements IAntDebugController {
    private Socket fRequestSocket;
    private PrintWriter fRequestWriter;
    private BufferedReader fResponseReader;
    private int fRequestPort = -1;
    private Thread fReaderThread;
    private AntDebugTarget fTarget;

    public RemoteAntDebugBuildListener(ILaunch launch, String encoding) {
        super(launch, encoding);
    }

    @Override
    protected void receiveMessage(String message) {
        if (message.startsWith("build_started")) {
            this.buildStarted();
        } else if (message.startsWith("suspended")) {
            this.handleSuspendMessage(message);
        } else if (message.startsWith("terminated")) {
            try {
                this.fTarget.terminate();
            }
            catch (DebugException debugException) {}
        } else if (message.startsWith("stack")) {
            AntThread thread = (AntThread)this.fTarget.getThreads()[0];
            thread.buildStack(message);
        } else if (message.startsWith("prop")) {
            AntThread thread = (AntThread)this.fTarget.getThreads()[0];
            thread.newProperties(message);
        } else {
            super.receiveMessage(message);
        }
    }

    private void handleSuspendMessage(String message) {
        if (message.endsWith("client")) {
            this.fTarget.suspended(32);
        } else if (message.endsWith("step")) {
            this.fTarget.suspended(8);
        } else if (message.indexOf("breakpoint") >= 0) {
            this.fTarget.breakpointHit(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildStarted() {
        IProcess process = this.getProcess();
        while (process == null) {
            try {
                RemoteAntDebugBuildListener remoteAntDebugBuildListener = this;
                synchronized (remoteAntDebugBuildListener) {
                    this.wait(400L);
                }
                process = this.getProcess();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fTarget = new AntDebugTarget(this.fLaunch, process, this);
        this.fLaunch.addDebugTarget((IDebugTarget)this.fTarget);
        if (!this.connectRequest()) {
            this.shutDown();
            return;
        }
        this.fTarget.buildStarted();
    }

    private boolean connectRequest() {
        IOException exception = null;
        int i = 1;
        while (i < 20) {
            try {
                this.fRequestSocket = new Socket("localhost", this.fRequestPort);
                this.fRequestWriter = new PrintWriter(this.fRequestSocket.getOutputStream(), true);
                this.fResponseReader = new BufferedReader(new InputStreamReader(this.fRequestSocket.getInputStream(), this.getEncoding()));
                this.fReaderThread = new ReaderThread();
                this.fReaderThread.start();
                return true;
            }
            catch (UnknownHostException e) {
                exception = e;
                break;
            }
            catch (IOException e) {
                exception = e;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
        AntLaunching.log("Internal error attempting to connect to debug target", exception);
        return false;
    }

    public synchronized void startListening(int eventPort, int requestPort) {
        super.startListening(eventPort);
        this.fRequestPort = requestPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRequest(String request) {
        if (this.fRequestWriter == null) {
            return;
        }
        PrintWriter printWriter = this.fRequestWriter;
        synchronized (printWriter) {
            this.fRequestWriter.println(request);
        }
    }

    @Override
    protected synchronized void shutDown() {
        if (this.fTarget != null) {
            try {
                this.fTarget.terminate();
                this.fTarget = null;
            }
            catch (DebugException debugException) {}
        }
        this.fLaunch = null;
        if (DebugPlugin.getDefault() != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        }
        try {
            if (this.fReaderThread != null) {
                this.fReaderThread.interrupt();
            }
            if (this.fResponseReader != null) {
                this.fResponseReader.close();
                this.fResponseReader = null;
            }
        }
        catch (IOException iOException) {}
        if (this.fRequestWriter != null) {
            this.fRequestWriter.close();
            this.fRequestWriter = null;
        }
        try {
            if (this.fRequestSocket != null) {
                this.fRequestSocket.close();
                this.fRequestSocket = null;
            }
        }
        catch (IOException iOException) {}
        super.shutDown();
    }

    @Override
    public void resume() {
        this.sendRequest("resume");
    }

    @Override
    public void terminate() {
    }

    @Override
    public void suspend() {
        this.sendRequest("suspend");
    }

    @Override
    public void stepInto() {
        this.sendRequest("step_into");
    }

    @Override
    public void stepOver() {
        this.sendRequest("step_over");
    }

    @Override
    public void handleBreakpoint(IBreakpoint breakpoint, boolean add) {
        if (this.fTarget == null || !this.fTarget.supportsBreakpoint(breakpoint)) {
            return;
        }
        StringBuffer message = new StringBuffer();
        if (add) {
            try {
                if (!breakpoint.isEnabled()) {
                    return;
                }
            }
            catch (CoreException e) {
                AntLaunching.log(e);
                return;
            }
            message.append("add");
        } else {
            message.append("remove");
        }
        message.append(",");
        message.append(breakpoint.getMarker().getResource().getLocation().toOSString());
        message.append(",");
        try {
            message.append(((ILineBreakpoint)breakpoint).getLineNumber());
            this.sendRequest(message.toString());
        }
        catch (CoreException ce) {
            AntLaunching.log(ce);
        }
    }

    @Override
    public void getProperties() {
        this.sendRequest("prop");
    }

    @Override
    public void getStackFrames() {
        this.sendRequest("stack");
    }

    @Override
    public StringBuffer unescapeString(StringBuffer property) {
        if (property.indexOf("\\r") == -1 && property.indexOf("\\n") == -1) {
            return property;
        }
        int i = 0;
        while (i < property.length()) {
            if ('\\' == property.charAt(i)) {
                String newString = "";
                if ('r' == property.charAt(i + 1)) {
                    newString = i - 1 > -1 && '\\' == property.charAt(i - 1) ? "r" : String.valueOf(newString) + '\r';
                } else if ('n' == property.charAt(i + 1)) {
                    newString = i - 1 > -1 && '\\' == property.charAt(i - 1) ? "n" : String.valueOf(newString) + '\n';
                }
                if (newString.length() > 0) {
                    property.replace(i, i + 2, newString);
                }
            }
            ++i;
        }
        return property;
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread() {
            super("Ant Request Response Reader Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String message = null;
                while (RemoteAntDebugBuildListener.this.fResponseReader != null) {
                    RemoteAntDebugBuildListener remoteAntDebugBuildListener = RemoteAntDebugBuildListener.this;
                    synchronized (remoteAntDebugBuildListener) {
                        if (RemoteAntDebugBuildListener.this.fResponseReader != null && (message = RemoteAntDebugBuildListener.this.fResponseReader.readLine()) != null) {
                            RemoteAntDebugBuildListener.this.receiveMessage(message);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                RemoteAntDebugBuildListener.this.shutDown();
            }
            catch (Exception e) {
                AntLaunching.log("Internal error processing remote response", e);
                RemoteAntDebugBuildListener.this.shutDown();
            }
        }
    }
}

