/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.antlr;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.eclipse.n4js.antlr.CodeIntoGrammarInjector;
import org.eclipse.n4js.antlr.UnicodeKeywordHelper;
import org.eclipse.n4js.antlr.n4js.AutomaticSemicolonInjector;
import org.eclipse.n4js.antlr.n4js.NoLineTerminatorHandlingInjector;
import org.eclipse.n4js.antlr.n4js.RegExDisambiguationInjector;
import org.eclipse.n4js.antlr.n4js.TemplateLiteralDisambiguationInjector;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammarGenerator;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrOptions;

public class N4JSAntlrGrammarGenerator
extends AntlrGrammarGenerator {
    @Inject
    private AutomaticSemicolonInjector semicolonInjector;
    @Inject
    private RegExDisambiguationInjector regExDisambiguationInjector;
    @Inject
    private TemplateLiteralDisambiguationInjector templateLiteralDisambiguationInjector;
    @Inject
    private NoLineTerminatorHandlingInjector noLineTerminatorHandlingInjector;
    private List<CodeIntoGrammarInjector> steps;

    @Inject
    public List<CodeIntoGrammarInjector> initialize() {
        this.steps = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new CodeIntoGrammarInjector[]{this.semicolonInjector, this.regExDisambiguationInjector, this.templateLiteralDisambiguationInjector, this.noLineTerminatorHandlingInjector}));
        return this.steps;
    }

    protected String toAntlrKeywordRule(String keyword, AntlrOptions options) {
        return UnicodeKeywordHelper.toUnicodeKeyword(keyword);
    }

    public void generate(Grammar it, AntlrOptions options, IXtextGeneratorFileSystemAccess fsa) {
        super.generate(it, options, fsa);
        this.injectCode(it, fsa);
    }

    public void injectCode(Grammar it, IXtextGeneratorFileSystemAccess fsa) {
        String _path = fsa.getPath();
        String outletPath = String.valueOf(_path) + "/";
        String _grammarFileName = this.getGrammarNaming().getLexerGrammar(it).getGrammarFileName();
        String lexerGrammarFileName = String.valueOf(outletPath) + _grammarFileName;
        String _grammarFileName_1 = this.getGrammarNaming().getParserGrammar(it).getGrammarFileName();
        String parserGrammarFileName = String.valueOf(outletPath) + _grammarFileName_1;
        this.injectCode(lexerGrammarFileName, parserGrammarFileName);
    }

    public void injectCode(String lexerGrammarFileName, String parserGrammarFileName) {
        if (lexerGrammarFileName != null) {
            try {
                File _file = new File(lexerGrammarFileName);
                String lexerGrammarContent = Files.toString((File)_file, (Charset)Charsets.UTF_8);
                lexerGrammarContent = this.processLexerGrammar(lexerGrammarContent);
                File _file_1 = new File(lexerGrammarFileName);
                Files.write((CharSequence)lexerGrammarContent, (File)_file_1, (Charset)Charsets.UTF_8);
            }
            catch (Throwable _t) {
                if (_t instanceof IOException) {
                    IOException e = (IOException)_t;
                    throw new RuntimeException();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        if (parserGrammarFileName != null) {
            try {
                File _file_2 = new File(parserGrammarFileName);
                String parserGrammarContent = Files.toString((File)_file_2, (Charset)Charsets.UTF_8);
                parserGrammarContent = this.processParserGrammar(parserGrammarContent);
                File _file_3 = new File(parserGrammarFileName);
                Files.write((CharSequence)parserGrammarContent, (File)_file_3, (Charset)Charsets.UTF_8);
            }
            catch (Throwable _t_1) {
                if (_t_1 instanceof IOException) {
                    IOException e_1 = (IOException)_t_1;
                    throw new RuntimeException();
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
        }
    }

    private String processParserGrammar(String grammarContent) {
        String result = grammarContent;
        for (CodeIntoGrammarInjector step : this.steps) {
            result = step.processParserGrammar(result);
        }
        return result;
    }

    private String processLexerGrammar(String grammarContent) {
        String result = grammarContent;
        for (CodeIntoGrammarInjector step : this.steps) {
            result = step.processLexerGrammar(result);
        }
        return result;
    }
}

