/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import com.google.common.base.Strings;
import java.io.File;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.ShadowingInfoHelper;
import org.eclipse.n4js.external.libraries.ExternalLibrariesActivator;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.preferences.external.ExternalLibraryPreferencePage;
import org.eclipse.swt.graphics.Image;

class BuiltInLibrariesLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final ExternalIndexSynchronizer indexSynchronizer;
    private final ShadowingInfoHelper shadowingInfoHelper;
    private final ExternalLibraryWorkspace externalLibraryWorkspace;

    public BuiltInLibrariesLabelProvider(ExternalIndexSynchronizer indexSynchronizer, ShadowingInfoHelper shadowingInfoHelper, ExternalLibraryWorkspace externalLibraryWorkspace) {
        this.indexSynchronizer = indexSynchronizer;
        this.shadowingInfoHelper = shadowingInfoHelper;
        this.externalLibraryWorkspace = externalLibraryWorkspace;
    }

    public String getText(Object element) {
        if (element instanceof java.net.URI) {
            return this.getCategoryText(element);
        }
        if (element instanceof IN4JSProject) {
            return ((IN4JSProject)element).getProjectName();
        }
        return super.getText(element);
    }

    private String getCategoryText(Object element) {
        String externalLibId = ExternalLibraryPreferencePage.BUILT_IN_LIBS.get(element);
        if (!Strings.isNullOrEmpty((String)externalLibId)) {
            return (String)ExternalLibrariesActivator.EXTERNAL_LIBRARY_NAMES.get(externalLibId);
        }
        return new File((java.net.URI)element).getAbsolutePath();
    }

    public Image getImage(Object element) {
        if (element instanceof java.net.URI) {
            return (Image)ImageDescriptorCache.ImageRef.LIB_PATH.asImage().orNull();
        }
        if (element instanceof IN4JSProject) {
            return (Image)ImageDescriptorCache.ImageRef.EXTERNAL_LIB_PROJECT.asImage().orNull();
        }
        return super.getImage(element);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof java.net.URI) {
            return new StyledString(this.getCategoryText(element));
        }
        if (element instanceof IN4JSProject) {
            IN4JSProject project = (IN4JSProject)element;
            String name = project.getProjectName();
            ProjectType type = project.getProjectType();
            String version = SemverSerializer.serialize((VersionNumber)project.getVersion()).replaceFirst("@", "v");
            String typeLabel = this.getProjectTypeLabel(type);
            boolean inIndex = this.indexSynchronizer.isInIndex((URI)project.getProjectDescriptionLocation().orNull());
            String rootLocationName = this.getRootLocationName(project);
            StyledString.Styler stylerName = inIndex ? null : StyledString.QUALIFIER_STYLER;
            StyledString.Styler stylerType = inIndex ? StyledString.DECORATIONS_STYLER : StyledString.QUALIFIER_STYLER;
            StyledString string = new StyledString(String.valueOf(name) + " " + version, stylerName);
            string.append(typeLabel, stylerType);
            if (rootLocationName != null) {
                string.append(rootLocationName, StyledString.COUNTER_STYLER);
            }
            return string;
        }
        return new StyledString("unknown");
    }

    private String getRootLocationName(IN4JSProject project) {
        String rootLocationName = null;
        List shadowingProjects = this.shadowingInfoHelper.findShadowingProjects(project);
        if (!shadowingProjects.isEmpty()) {
            IN4JSProject shadowedProject = (IN4JSProject)shadowingProjects.get(0);
            if (shadowedProject.isExternal()) {
                URI location = shadowedProject.getLocation();
                java.net.URI rootLocation = this.externalLibraryWorkspace.getRootLocationForResource(location);
                URI emfURI = URI.createURI((String)rootLocation.toString());
                rootLocationName = emfURI.lastSegment();
                if (rootLocationName.isEmpty() && emfURI.segmentCount() > 1) {
                    rootLocationName = emfURI.segment(emfURI.segmentCount() - 2);
                }
            } else {
                rootLocationName = "workspace";
            }
            rootLocationName = " [shadowed by " + rootLocationName + "]";
        }
        return rootLocationName;
    }

    private String getProjectTypeLabel(ProjectType projectType) {
        String label = ProjectType.API.equals((Object)projectType) ? ProjectType.API.getName() : org.eclipse.xtext.util.Strings.toFirstUpper((String)Strings.nullToEmpty((String)projectType.getName()).replaceAll("_", " ").toLowerCase());
        return " [" + label + "]";
    }
}

