/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.SimpleAttributeResolver;

public final class AnnotationDefinition {
    private static final Map<String, AnnotationDefinition> DEFINED_ANNOTATIONS = new HashMap<String, AnnotationDefinition>();
    private static final Map<String, AnnotationDefinition> ANNOTATIONS_IN_TYPEMODEL = new HashMap<String, AnnotationDefinition>();
    public static final AnnotationDefinition IDEBUG = AnnotationDefinition.define("IDEBUG").targets(N4JSPackage.Literals.SCRIPT, N4JSPackage.Literals.EXPORT_DECLARATION, N4JSPackage.Literals.EXPORTABLE_ELEMENT, N4JSPackage.Literals.TYPE_DEFINING_ELEMENT, N4JSPackage.Literals.N4_MEMBER_DECLARATION, N4JSPackage.Literals.FUNCTION_OR_FIELD_ACCESSOR).transitive().repeatable().args(N4JSPackage.Literals.INT_LITERAL, N4JSPackage.Literals.STRING_LITERAL).end();
    public static final AnnotationDefinition INTERNAL = AnnotationDefinition.define("Internal").targets(N4JSPackage.Literals.TYPE_DEFINING_ELEMENT, N4JSPackage.Literals.N4_MEMBER_DECLARATION, N4JSPackage.Literals.FUNCTION_OR_FIELD_ACCESSOR, N4JSPackage.Literals.EXPORTABLE_ELEMENT, N4JSPackage.Literals.EXPORT_DECLARATION).end();
    public static final AnnotationDefinition STRING_BASED = AnnotationDefinition.define("StringBased").targets(N4JSPackage.Literals.N4_ENUM_DECLARATION).retention(RetentionPolicy.TYPE).end();
    public static final AnnotationDefinition FINAL = AnnotationDefinition.define("Final").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION, N4JSPackage.Literals.N4_MEMBER_DECLARATION).targetsWithCustomError(N4JSPackage.Literals.N4_INTERFACE_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition COVARIANT_CONSTRUCTOR = AnnotationDefinition.define("CovariantConstructor").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION, N4JSPackage.Literals.N4_INTERFACE_DECLARATION, N4JSPackage.Literals.N4_MEMBER_DECLARATION).end();
    public static final AnnotationDefinition WRITABLE = AnnotationDefinition.define("Writable").args(N4JSPackage.Literals.BOOLEAN_LITERAL).targets(N4JSPackage.Literals.N4_FIELD_DECLARATION).retention(RetentionPolicy.TYPE).end();
    public static final AnnotationDefinition ENUMERABLE = AnnotationDefinition.define("Enumerable").args(N4JSPackage.Literals.BOOLEAN_LITERAL).targets(N4JSPackage.Literals.N4_FIELD_DECLARATION, N4JSPackage.Literals.N4_FIELD_ACCESSOR).retention(RetentionPolicy.TYPE).end();
    public static final AnnotationDefinition CONFIGURABLE = AnnotationDefinition.define("Configurable").args(N4JSPackage.Literals.BOOLEAN_LITERAL).targets(N4JSPackage.Literals.N4_FIELD_DECLARATION, N4JSPackage.Literals.N4_FIELD_ACCESSOR).retention(RetentionPolicy.TYPE).end();
    public static final AnnotationDefinition OBSERVABLE = AnnotationDefinition.define("Observable").targets(N4JSPackage.Literals.N4_FIELD_DECLARATION, N4JSPackage.Literals.N4_CLASS_DEFINITION, N4JSPackage.Literals.EXPORT_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition SPEC = AnnotationDefinition.define("Spec").targets(N4JSPackage.Literals.FORMAL_PARAMETER).retention(RetentionPolicy.TYPE).end();
    public static final AnnotationDefinition NFON = AnnotationDefinition.define("Nfon").targets(N4JSPackage.Literals.N4_FIELD_DECLARATION).args(N4JSPackage.Literals.STRING_LITERAL, N4JSPackage.Literals.STRING_LITERAL).argsOptional().retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition OVERRIDE = AnnotationDefinition.define("Override").targets(N4JSPackage.Literals.N4_MEMBER_DECLARATION).end();
    public static final AnnotationDefinition THIS = AnnotationDefinition.define("This").targets(N4JSPackage.Literals.FUNCTION_DEFINITION, N4JSPackage.Literals.N4_FIELD_ACCESSOR).args(TypeRefsPackage.Literals.TYPE_REF).end();
    public static final AnnotationDefinition N4JS = AnnotationDefinition.define("N4JS").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION, N4JSPackage.Literals.EXPORT_DECLARATION).retention(RetentionPolicy.TYPE).end();
    public static final AnnotationDefinition IGNORE_IMPLEMENTATION = AnnotationDefinition.define("IgnoreImplementation").targets(N4JSPackage.Literals.SCRIPT, N4JSPackage.Literals.EXPORT_DECLARATION, N4JSPackage.Literals.EXPORTABLE_ELEMENT).transitive().end();
    public static final AnnotationDefinition GLOBAL = AnnotationDefinition.define("Global").targets(N4JSPackage.Literals.SCRIPT).transitive().retention(RetentionPolicy.TYPE).end();
    public static final AnnotationDefinition PROVIDED_BY_RUNTIME = AnnotationDefinition.define("ProvidedByRuntime").targets(N4JSPackage.Literals.SCRIPT, N4JSPackage.Literals.EXPORT_DECLARATION, N4JSPackage.Literals.EXPORTABLE_ELEMENT).transitive().end();
    public static final AnnotationDefinition POLYFILL = AnnotationDefinition.define("Polyfill").targets(N4JSPackage.Literals.EXPORT_DECLARATION, N4JSPackage.Literals.EXPORTABLE_ELEMENT).end();
    public static final AnnotationDefinition STATIC_POLYFILL = AnnotationDefinition.define("StaticPolyfill").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION).end();
    public static final AnnotationDefinition STATIC_POLYFILL_AWARE = AnnotationDefinition.define("StaticPolyfillAware").targets(N4JSPackage.Literals.SCRIPT).transitive().retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition STATIC_POLYFILL_MODULE = AnnotationDefinition.define("StaticPolyfillModule").targets(N4JSPackage.Literals.SCRIPT).transitive().retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition PROVIDES_DEFAULT_IMPLEMENTATION = AnnotationDefinition.define("ProvidesDefaultImplementation").targets(N4JSPackage.Literals.N4_METHOD_DECLARATION, N4JSPackage.Literals.N4_FIELD_ACCESSOR).transitive().retention(RetentionPolicy.TYPE).end();
    public static final AnnotationDefinition PROVIDES_INITIALZER = AnnotationDefinition.define("ProvidesInitializer").targets(N4JSPackage.Literals.N4_FIELD_DECLARATION, N4JSPackage.Literals.N4_SETTER_DECLARATION).transitive().retention(RetentionPolicy.TYPE).end();
    public static final AnnotationDefinition PROMISIFIABLE = AnnotationDefinition.define("Promisifiable").targets(N4JSPackage.Literals.FUNCTION_DECLARATION, N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.TYPE).end();
    public static final AnnotationDefinition TEST_GROUP = AnnotationDefinition.define("Group").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION, N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).transitive().repeatable().args(N4JSPackage.Literals.STRING_LITERAL).end();
    public static final AnnotationDefinition TEST_METHOD = AnnotationDefinition.define("Test").targets(N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition PARAMETERS = AnnotationDefinition.define("Parameters").targets(N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).args(N4JSPackage.Literals.STRING_LITERAL).argsOptional().end();
    public static final AnnotationDefinition PARAMETER = AnnotationDefinition.define("Parameter").targets(N4JSPackage.Literals.N4_FIELD_DECLARATION, N4JSPackage.Literals.N4_SETTER_DECLARATION).retention(RetentionPolicy.RUNTIME).args(N4JSPackage.Literals.INT_LITERAL).argsOptional().end();
    public static final AnnotationDefinition BEFOREALL_SETUP = AnnotationDefinition.define("BeforeAll").targets(N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition BEFORE_SETUP = AnnotationDefinition.define("Before").targets(N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition AFTERALL_TEARDOWN = AnnotationDefinition.define("AfterAll").targets(N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition AFTER_TEARDOWN = AnnotationDefinition.define("After").targets(N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition TEST_IGNORE = AnnotationDefinition.define("Ignore").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION, N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).transitive().args(N4JSPackage.Literals.STRING_LITERAL).argsOptional().end();
    public static final AnnotationDefinition TEST_FIXME = AnnotationDefinition.define("Fixme").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION, N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).transitive().args(N4JSPackage.Literals.STRING_LITERAL, N4JSPackage.Literals.STRING_LITERAL).argsOptional().end();
    public static final AnnotationDefinition TEST_TIMEOUT = AnnotationDefinition.define("Timeout").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION, N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).transitive().args(N4JSPackage.Literals.INT_LITERAL).end();
    public static final AnnotationDefinition DESCRIPTION = AnnotationDefinition.define("Description").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION, N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).args(N4JSPackage.Literals.STRING_LITERAL).end();
    public static final AnnotationDefinition TEST_API = AnnotationDefinition.define("TestAPI").targets(N4JSPackage.Literals.N4_CLASSIFIER_DECLARATION, N4JSPackage.Literals.N4_MEMBER_DECLARATION).retention(RetentionPolicy.TYPE).end();
    public static final AnnotationDefinition INJECTED = AnnotationDefinition.define("Injected").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition GENERATE_INJECTOR = AnnotationDefinition.define("GenerateInjector").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition WITH_PARENT_INJECTOR = AnnotationDefinition.define("WithParentInjector").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION).args(TypeRefsPackage.Literals.TYPE_REF).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition PROVIDES = AnnotationDefinition.define("Provides").targets(N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition BINDER = AnnotationDefinition.define("Binder").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition BIND = AnnotationDefinition.define("Bind").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION).args(TypeRefsPackage.Literals.TYPE_REF, TypeRefsPackage.Literals.TYPE_REF).retention(RetentionPolicy.RUNTIME).repeatable().end();
    public static final AnnotationDefinition USE_BINDER = AnnotationDefinition.define("UseBinder").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION).args(TypeRefsPackage.Literals.TYPE_REF).retention(RetentionPolicy.RUNTIME).repeatable().end();
    public static final AnnotationDefinition INJECT = AnnotationDefinition.define("Inject").targets(N4JSPackage.Literals.N4_FIELD_DECLARATION, N4JSPackage.Literals.N4_METHOD_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition SINGLETON = AnnotationDefinition.define("Singleton").targets(N4JSPackage.Literals.N4_CLASS_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition MIGRATION = AnnotationDefinition.define("Migration").targets(N4JSPackage.Literals.FUNCTION_DECLARATION).javaScriptVariants("n4idl").args(N4JSPackage.Literals.NUMERIC_LITERAL, N4JSPackage.Literals.NUMERIC_LITERAL).argsOptional().retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition VERSION_AWARE = AnnotationDefinition.define("VersionAware").targets(N4JSPackage.Literals.FUNCTION_DECLARATION, N4JSPackage.Literals.N4_CLASSIFIER_DECLARATION).javaScriptVariants("n4idl").retention(RetentionPolicy.RUNTIME).end();
    public static final AnnotationDefinition TRANSIENT = AnnotationDefinition.define("Transient").targets(N4JSPackage.Literals.N4_FIELD_DECLARATION).retention(RetentionPolicy.RUNTIME).end();
    public final String name;
    public final EClass[] targets;
    public final EClass[] targetsWithCustomError;
    public final String[] javaScriptVariants;
    public final boolean repeatable;
    public final RetentionPolicy retention;
    public final EClass[] argtypes;
    public final boolean argsOptional;
    public final boolean transitive;
    public final boolean argsVariadic;

    public static AnnotationDefinition find(String name) {
        return DEFINED_ANNOTATIONS.get(name);
    }

    static AnnotationDefinitionBuilder define(String name) {
        AnnotationDefinitionBuilder adb = new AnnotationDefinitionBuilder();
        adb.name = name;
        return adb;
    }

    private AnnotationDefinition(String name, EClass[] targets, EClass[] targetsWithCustomError, String[] javaScriptVariants, boolean transitive, boolean repeatable, RetentionPolicy retention, EClass[] argtypes, boolean argsOptional, boolean argsVariadic) {
        this.name = name;
        this.targets = targets;
        this.targetsWithCustomError = targetsWithCustomError;
        this.javaScriptVariants = javaScriptVariants;
        this.transitive = transitive;
        this.repeatable = repeatable;
        this.retention = retention;
        this.argsOptional = argsOptional;
        this.argtypes = argtypes;
        this.argsVariadic = argsVariadic;
        if (this.argsVariadic && (this.argtypes == null || this.argtypes.length == 0)) {
            throw new IllegalArgumentException("Variadic argument flag can be true if the annotation definition has any defined argument types.");
        }
        DEFINED_ANNOTATIONS.put(name, this);
        if (retention == RetentionPolicy.TYPE || retention == RetentionPolicy.RUNTIME) {
            ANNOTATIONS_IN_TYPEMODEL.put(name, this);
        }
    }

    public static boolean isInTypeModel(String name) {
        return ANNOTATIONS_IN_TYPEMODEL.containsKey(name);
    }

    public Annotation getAnnotation(AnnotableElement element) {
        Annotation annotation = this.getOwnedAnnotation(element);
        if (annotation == null && element != null && this.transitive) {
            AnnotableElement container = (AnnotableElement)EcoreUtil2.getContainerOfType((EObject)element.eContainer(), AnnotableElement.class);
            if (container instanceof ExportDeclaration) {
                return this.getAnnotation((AnnotableElement)EcoreUtil2.getContainerOfType((EObject)container.eContainer(), AnnotableElement.class));
            }
            return this.getAnnotation(container);
        }
        return annotation;
    }

    public TAnnotation getAnnotation(TAnnotableElement element) {
        TAnnotation annotation = this.getOwnedAnnotation(element);
        if (annotation == null && element != null && this.transitive) {
            return this.getAnnotation((TAnnotableElement)EcoreUtil2.getContainerOfType((EObject)element.eContainer(), TAnnotableElement.class));
        }
        return annotation;
    }

    public Iterable<Annotation> getAllAnnotations(AnnotableElement element) {
        return element == null ? Collections.emptyList() : this.getAllAnnotations(new N4JSAnnotatableWrapper(element));
    }

    public Iterable<TAnnotation> getAllAnnotations(TAnnotableElement element) {
        return element == null ? Collections.emptyList() : this.getAllAnnotations(new TAnnotatableWrapper(element));
    }

    private <T extends EObject> Iterable<T> getAllAnnotations(EAnnotatableWrapper<T> element) {
        Iterable<T> annotations = this.getAllOwnedAnnotations(element);
        if (!this.transitive || element == null) {
            return annotations;
        }
        EAnnotatableWrapper<T> container = element.getContainerAnnotatable();
        if (container == null) {
            return annotations;
        }
        if (((EAnnotatableWrapper)container).annotatable instanceof ExportDeclaration) {
            container = container.getContainerAnnotatable();
        }
        if (this.repeatable) {
            return Iterables.concat(annotations, this.getAllAnnotations(container));
        }
        EObject annotation = (EObject)Iterables.getFirst(annotations, null);
        return annotation != null ? Collections.singletonList(annotation) : this.getAllAnnotations(container);
    }

    public Annotation getOwnedAnnotation(AnnotableElement element) {
        AnnotableElement contianer;
        if (element == null) {
            return null;
        }
        Annotation ann = this.getOwnedAnnotation(new N4JSAnnotatableWrapper(element));
        if (ann == null && (contianer = (AnnotableElement)EcoreUtil2.getContainerOfType((EObject)element.eContainer(), AnnotableElement.class)) != null && contianer instanceof ExportDeclaration) {
            return this.getOwnedAnnotation(new N4JSAnnotatableWrapper(contianer));
        }
        return ann;
    }

    public TAnnotation getOwnedAnnotation(TAnnotableElement element) {
        return element == null ? null : this.getOwnedAnnotation(new TAnnotatableWrapper(element));
    }

    private <T extends EObject> T getOwnedAnnotation(EAnnotatableWrapper<T> element) {
        if (element == null) {
            return null;
        }
        Optional<EAnnotationWrapper<T>> result = element.findFirstAnnotationByName(this.name);
        if (result.isPresent()) {
            return ((EAnnotationWrapper)result.get()).getWrappedItem();
        }
        return null;
    }

    public Iterable<Annotation> getAllOwnedAnnotations(AnnotableElement element) {
        return element == null ? Collections.emptyList() : this.getAllOwnedAnnotations(new N4JSAnnotatableWrapper(element));
    }

    public Iterable<TAnnotation> getAllOwnedAnnotations(TAnnotableElement element) {
        return element == null ? Collections.emptyList() : this.getAllOwnedAnnotations(new TAnnotatableWrapper(element));
    }

    private <T extends EObject> Iterable<T> getAllOwnedAnnotations(EAnnotatableWrapper<T> element) {
        if (element == null) {
            return Collections.emptyList();
        }
        if (!this.repeatable) {
            T first = this.getOwnedAnnotation(element);
            if (first == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(first);
        }
        return FluentIterable.from(element.findAnnotationsByName(this.name)).transform(a -> a.getWrappedItem());
    }

    public boolean hasOwnedAnnotation(TAnnotableElement element) {
        return this.getOwnedAnnotation(element) != null;
    }

    public boolean hasOwnedAnnotation(AnnotableElement element) {
        return this.getOwnedAnnotation(element) != null;
    }

    public boolean hasAnnotation(TAnnotableElement element) {
        return this.getAnnotation(element) != null;
    }

    public boolean hasAnnotation(AnnotableElement element) {
        return this.getAnnotation(element) != null;
    }

    /* synthetic */ AnnotationDefinition(String string, EClass[] eClassArray, EClass[] eClassArray2, String[] stringArray, boolean bl, boolean bl2, RetentionPolicy retentionPolicy, EClass[] eClassArray3, boolean bl3, boolean bl4, AnnotationDefinition annotationDefinition) {
        this(string, eClassArray, eClassArray2, stringArray, bl, bl2, retentionPolicy, eClassArray3, bl3, bl4);
    }

    static class AnnotationDefinitionBuilder {
        String name;
        EClass[] targets;
        String[] javaScriptVariants;
        EClass[] targetsWithCustomError = new EClass[0];
        boolean repeatable = false;
        RetentionPolicy retention = RetentionPolicy.AST;
        EClass[] argtypes = new EClass[0];
        boolean argsOptional = false;
        boolean transitive = false;
        boolean argsVariadic = false;

        AnnotationDefinitionBuilder() {
        }

        AnnotationDefinitionBuilder targets(EClass ... _targets) {
            this.targets = _targets;
            return this;
        }

        AnnotationDefinitionBuilder javaScriptVariants(String ... variants) {
            this.javaScriptVariants = variants;
            return this;
        }

        AnnotationDefinitionBuilder targetsWithCustomError(EClass ... _targetsWithCustomError) {
            this.targetsWithCustomError = _targetsWithCustomError;
            return this;
        }

        AnnotationDefinitionBuilder repeatable() {
            this.repeatable = true;
            return this;
        }

        AnnotationDefinitionBuilder args(EClass ... argTypes) {
            this.argtypes = argTypes;
            return this;
        }

        AnnotationDefinitionBuilder argsVariadic() {
            this.argsVariadic = true;
            return this;
        }

        AnnotationDefinitionBuilder argsOptional() {
            this.argsOptional = true;
            return this;
        }

        AnnotationDefinitionBuilder transitive() {
            this.transitive = true;
            return this;
        }

        AnnotationDefinitionBuilder retention(RetentionPolicy _retention) {
            this.retention = _retention;
            return this;
        }

        AnnotationDefinition end() {
            return new AnnotationDefinition(this.name, this.targets, this.targetsWithCustomError, this.javaScriptVariants, this.transitive, this.repeatable, this.retention, this.argtypes, this.argsOptional, this.argsVariadic, null);
        }
    }

    static class EAnnotatableWrapper<A extends EObject> {
        private final EObject annotatable;
        private final Function<EObject, Iterable<EAnnotationWrapper<A>>> annotationResolver;
        private final Class<? extends EObject> containerTypeClass;

        EAnnotatableWrapper(EObject annotatable, Function<EObject, Iterable<EAnnotationWrapper<A>>> annotationSupplier, Class<? extends EObject> containerTypeClass) {
            this.annotatable = annotatable;
            this.annotationResolver = annotationSupplier;
            this.containerTypeClass = containerTypeClass;
        }

        public Optional<EAnnotationWrapper<A>> findFirstAnnotationByName(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            return Iterables.tryFind((Iterable)((Iterable)this.annotationResolver.apply((Object)this.annotatable)), input -> name.equals(input.getName()));
        }

        public Iterable<EAnnotationWrapper<A>> findAnnotationsByName(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            return FluentIterable.from((Iterable)((Iterable)this.annotationResolver.apply((Object)this.annotatable))).filter(input -> name.equals(input.getName()));
        }

        public EAnnotatableWrapper<A> getContainerAnnotatable() {
            EObject container = EcoreUtil2.getContainerOfType((EObject)this.getContainer(), this.containerTypeClass);
            return container == null ? null : new EAnnotatableWrapper<A>(container, this.annotationResolver, this.containerTypeClass);
        }

        public EObject getContainer() {
            return this.annotatable.eContainer();
        }

        public Iterable<EAnnotationWrapper<A>> getAnnotations() {
            return (Iterable)this.annotationResolver.apply((Object)this.annotatable);
        }
    }

    static class EAnnotationWrapper<T extends EObject> {
        private static final Function<EObject, String> NAME_RESOLVER = SimpleAttributeResolver.newResolver(String.class, (String)"name");
        private final T annotation;

        EAnnotationWrapper(T annotation) {
            this.annotation = (EObject)Preconditions.checkNotNull(annotation, (Object)"annotation");
        }

        public String getName() {
            return (String)NAME_RESOLVER.apply(this.annotation);
        }

        public T getWrappedItem() {
            return this.annotation;
        }
    }

    static class N4JSAnnotatableWrapper
    extends EAnnotatableWrapper<Annotation> {
        private static final Function<EObject, Iterable<EAnnotationWrapper<Annotation>>> SUPPLIER = element -> FluentIterable.from(N4JSAnnotatableWrapper.getASTAnnotations(element)).transform(annotation -> new N4JSAnnotationWrapper((Annotation)annotation));

        N4JSAnnotatableWrapper(AnnotableElement annotatable) {
            super((EObject)annotatable, SUPPLIER, AnnotableElement.class);
        }

        private static final Iterable<Annotation> getASTAnnotations(EObject element) {
            EList anns = ((AnnotableElement)element).getAnnotations();
            if (element.eContainer() != null && element.eContainer() instanceof ExportDeclaration) {
                return Iterables.concat((Iterable)anns, (Iterable)((AnnotableElement)element.eContainer()).getAnnotations());
            }
            return anns;
        }
    }

    static class N4JSAnnotationWrapper
    extends EAnnotationWrapper<Annotation> {
        N4JSAnnotationWrapper(Annotation annotation) {
            super(annotation);
        }
    }

    public static enum RetentionPolicy {
        AST,
        TYPE,
        RUNTIME,
        RUNTIME_TYPEFIELD;

    }

    static class TAnnotatableWrapper
    extends EAnnotatableWrapper<TAnnotation> {
        private static final Function<EObject, Iterable<EAnnotationWrapper<TAnnotation>>> SUPPLIER = element -> FluentIterable.from((Iterable)((TAnnotableElement)element).getAnnotations()).transform(annotation -> new TAnnotationWrapper((TAnnotation)annotation));

        TAnnotatableWrapper(TAnnotableElement annotatable) {
            super((EObject)annotatable, SUPPLIER, TAnnotableElement.class);
        }
    }

    static class TAnnotationWrapper
    extends EAnnotationWrapper<TAnnotation> {
        TAnnotationWrapper(TAnnotation annotation) {
            super(annotation);
        }
    }
}

