/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public final class FindArtifactHelper {
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public URI findArtifact(IN4JSProject project, String fqn, Optional<String> fileExtension) {
        return this.findArtifact(project, this.qualifiedNameConverter.toQualifiedName(fqn), fileExtension);
    }

    public URI findArtifact(IN4JSProject project, QualifiedName fqn, Optional<String> fileExtension) {
        for (IN4JSSourceContainer srcConti : project.getSourceContainers()) {
            URI uri = srcConti.findArtifact(fqn, fileExtension);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }
}

