/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators.packagejson;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.ShadowingInfoHelper;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.packagejson.PackageJsonUtils;
import org.eclipse.n4js.projectDescription.ModuleFilterSpecifier;
import org.eclipse.n4js.projectDescription.ProjectDependency;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectDescription.SourceContainerDescription;
import org.eclipse.n4js.projectDescription.SourceContainerType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.resource.XpectAwareFileExtensionCalculator;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.SemverToStringable;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.semver.SemverMatcher;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.utils.DependencyCycle;
import org.eclipse.n4js.utils.DependencyTraverser;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.WildcardPathFilterHelper;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.n4js.validation.helper.SourceContainerAwareDependencyProvider;
import org.eclipse.n4js.validation.validators.packagejson.ASTTraceable;
import org.eclipse.n4js.validation.validators.packagejson.AbstractJSONValidatorExtension;
import org.eclipse.n4js.validation.validators.packagejson.CheckProperty;
import org.eclipse.n4js.validation.validators.packagejson.PolyFilledProvision;
import org.eclipse.n4js.validation.validators.packagejson.ProjectTypePredicate;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
public class N4JSProjectSetupJsonValidatorExtension
extends AbstractJSONValidatorExtension {
    private static final Logger LOGGER = Logger.getLogger(N4JSProjectSetupJsonValidatorExtension.class);
    private static final ProjectTypePredicate API_TYPE = ProjectTypePredicate.anyOf(ProjectType.API, new ProjectType[0]);
    private static final ProjectTypePredicate RE_TYPE = ProjectTypePredicate.anyOf(ProjectType.RUNTIME_ENVIRONMENT, new ProjectType[0]);
    private static final ProjectTypePredicate RL_TYPE = ProjectTypePredicate.anyOf(ProjectType.RUNTIME_LIBRARY, new ProjectType[0]);
    private static final ProjectTypePredicate TEST_TYPE = ProjectTypePredicate.anyOf(ProjectType.TEST, new ProjectType[0]);
    private static final ProjectTypePredicate RE_OR_RL_TYPE = ProjectTypePredicate.anyOf(ProjectType.RUNTIME_ENVIRONMENT, ProjectType.RUNTIME_LIBRARY);
    private static final ProjectTypePredicate PLAINJS_TYPE = ProjectTypePredicate.anyOf(ProjectType.PLAINJS, new ProjectType[0]);
    private static final String PROJECT_DESCRIPTION_CACHE = "PROJECT_DESCRIPTION_CACHE";
    private static String ALL_EXISTING_PROJECT_CACHE = "ALL_EXISTING_PROJECT_CACHE";
    private static String DECLARED_DEPENDENCIES_CACHE = "DECLARED_DEPENDENCIES_CACHE";
    @Inject
    @Extension
    private IN4JSCore _iN4JSCore;
    @Inject
    private IContainer.Manager containerManager;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private XpectAwareFileExtensionCalculator fileExtensionCalculator;
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;
    @Inject
    private WildcardPathFilterHelper wildcardHelper;
    @Inject
    protected N4JSElementKeywordProvider keywordProvider;
    @Inject
    protected ShadowingInfoHelper shadowingInfoHelper;
    @Inject
    protected ExternalIndexSynchronizer indexSynchronizer;
    @Inject
    protected ExternalLibraryWorkspace extWS;
    @Inject
    protected SemverHelper semverHelper;

    @Override
    public boolean isResponsible(Map<Object, Object> context, EObject eObject) {
        return this.fileExtensionCalculator.getFilenameWithoutXpectExtension(eObject.eResource().getURI()).equals("package.json");
    }

    @Check
    public void checkConsistentPolyfills(JSONDocument document) {
        HashMap mQName2rtDep = CollectionLiterals.newHashMap();
        ProjectDescription description = this.getProjectDescription();
        String projectName = description.getProjectName();
        if (projectName == null) {
            return;
        }
        JSONArray requiredRuntimeLibrariesValue = this.getSingleDocumentValue(PackageJsonProperties.REQUIRED_RUNTIME_LIBRARIES, JSONArray.class);
        if (requiredRuntimeLibrariesValue == null) {
            return;
        }
        Iterable rteAndRtl = Iterables.filter((Iterable)requiredRuntimeLibrariesValue.getElements(), JSONStringLiteral.class);
        JSONStringLiteral selfProject = JSONModelUtils.createStringLiteral((String)projectName);
        Optional<? extends IN4JSProject> optOwnProject = this._iN4JSCore.findProject(document.eResource().getURI());
        boolean _isPresent = optOwnProject.isPresent();
        if (_isPresent) {
            rteAndRtl = Iterables.concat((Iterable)rteAndRtl, Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new JSONStringLiteral[]{selfProject})));
        }
        for (JSONStringLiteral libraryLiteral : rteAndRtl) {
            if (libraryLiteral == null) continue;
            String libPPqname = libraryLiteral.getValue();
            mQName2rtDep.put(libPPqname, libraryLiteral);
        }
        List<IEObjectDescription> allPolyFillTypes = this.getAllNonStaticPolyfills(document.eResource());
        LinkedListMultimap exportedPolyfills_QN_to_PolyProvision = LinkedListMultimap.create();
        for (IEObjectDescription ieoT : allPolyFillTypes) {
            Optional<? extends IN4JSSourceContainer> optSrcContainer = this._iN4JSCore.findN4JSSourceContainer(ieoT.getEObjectURI());
            boolean _isPresent_1 = optSrcContainer.isPresent();
            if (_isPresent_1) {
                IN4JSSourceContainer srcCont = (IN4JSSourceContainer)optSrcContainer.get();
                String depQName = srcCont.getProject().getProjectName();
                JSONStringLiteral dependency = (JSONStringLiteral)mQName2rtDep.get(depQName);
                if (dependency == null || dependency == selfProject) continue;
                String _string = ieoT.getQualifiedName().toString();
                PolyFilledProvision _polyFilledProvision = new PolyFilledProvision(depQName, dependency, ieoT);
                exportedPolyfills_QN_to_PolyProvision.put((Object)_string, (Object)_polyFilledProvision);
                continue;
            }
            QualifiedName _qualifiedName = ieoT.getQualifiedName();
            String _plus = "No container library found for " + _qualifiedName;
            throw new IllegalStateException(_plus);
        }
        LinkedListMultimap markerMapLibs2FilledName = LinkedListMultimap.create();
        Set _keySet = exportedPolyfills_QN_to_PolyProvision.keySet();
        for (String polyExport_QN : _keySet) {
            boolean _greaterThan;
            List polyProvisions = exportedPolyfills_QN_to_PolyProvision.get((Object)polyExport_QN);
            int _size = polyProvisions.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            LinkedListMultimap m = LinkedListMultimap.create();
            for (PolyFilledProvision prov : polyProvisions) {
                boolean _not;
                EObject eoPolyFiller = prov.ieoDescrOfPolyfill.getEObjectOrProxy();
                if (!(eoPolyFiller instanceof TClassifier)) continue;
                EObject _resolve = EcoreUtil.resolve((EObject)eoPolyFiller, (Resource)document.eResource());
                TClassifier resolvedEoPolyFiller = (TClassifier)_resolve;
                boolean _isPolyfill = resolvedEoPolyFiller.isPolyfill();
                boolean bl2 = _not = !_isPolyfill;
                if (_not) {
                    String _name = resolvedEoPolyFiller.getName();
                    String _plus = "Expected a polyfill, but wasn't: " + _name;
                    throw new IllegalStateException(_plus);
                }
                EList _ownedMembers = resolvedEoPolyFiller.getOwnedMembers();
                for (TMember member : _ownedMembers) {
                    m.put((Object)member.getName(), (Object)prov);
                }
            }
            Set _keySet_1 = m.keySet();
            for (String filledInMemberName : _keySet_1) {
                boolean _greaterThan_1;
                List providers = m.get((Object)filledInMemberName);
                int _size_1 = providers.size();
                boolean bl3 = _greaterThan_1 = _size_1 > 1;
                if (!_greaterThan_1) continue;
                HashSet keySet = CollectionLiterals.newHashSet();
                Consumer<PolyFilledProvision> _function = it -> keySet.add(it.libraryProjectReferenceLiteral);
                providers.forEach(_function);
                String filledTypeFQN = ((PolyFilledProvision)IterableExtensions.head((Iterable)providers)).descriptionStandard;
                String message = String.valueOf(filledTypeFQN) + "#" + filledInMemberName;
                markerMapLibs2FilledName.put((Object)keySet, (Object)message);
            }
        }
        Set _keySet_1 = markerMapLibs2FilledName.keySet();
        for (Set keyS : _keySet_1) {
            boolean _greaterThan;
            Collection polyFilledMemberAsStrings = markerMapLibs2FilledName.get((Object)keyS);
            Functions.Function1 _function = it -> it.getValue();
            String libsString = IterableExtensions.join((Iterable)IterableExtensions.sort((Iterable)ListExtensions.map((List)IterableExtensions.toList((Iterable)keyS), (Functions.Function1)_function)), (CharSequence)", ");
            Functions.Function1 _function_1 = it -> "\"" + it + "\"";
            String userPresentablePolyFills = IterableExtensions.join((Iterable)IterableExtensions.sort((Iterable)ListExtensions.map((List)IterableExtensions.toList((Iterable)polyFilledMemberAsStrings), (Functions.Function1)_function_1)), (CharSequence)", ");
            int _size = keyS.size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                String _xifexpression = null;
                int _size_1 = polyFilledMemberAsStrings.size();
                boolean _equals = _size_1 == 1;
                _xifexpression = _equals ? IssueCodes.getMessageForPOLY_CLASH_IN_RUNTIMEDEPENDENCY(libsString, userPresentablePolyFills) : IssueCodes.getMessageForPOLY_CLASH_IN_RUNTIMEDEPENDENCY_MULTI(libsString, userPresentablePolyFills);
                String issMsg = _xifexpression;
                Consumer<JSONStringLiteral> _function_2 = it -> this.addIssue(issMsg, (EObject)it, "POLY_CLASH_IN_RUNTIMEDEPENDENCY");
                keyS.forEach(_function_2);
                continue;
            }
            String issMsg_1 = IssueCodes.getMessageForPOLY_ERROR_IN_RUNTIMEDEPENDENCY(libsString, userPresentablePolyFills);
            this.addIssue(issMsg_1, (EObject)IterableExtensions.head((Iterable)keyS), "POLY_ERROR_IN_RUNTIMEDEPENDENCY");
        }
    }

    private List<IEObjectDescription> getAllNonStaticPolyfills(Resource projectDescriptionResourceUsedAsContext) {
        XtextResource asXtextRes = (XtextResource)projectDescriptionResourceUsedAsContext;
        IResourceDescription resDescr = asXtextRes.getResourceServiceProvider().getResourceDescriptionManager().getResourceDescription((Resource)asXtextRes);
        List visibleContainers = this.containerManager.getVisibleContainers(resDescr, this.resourceDescriptionsProvider.getResourceDescriptions(projectDescriptionResourceUsedAsContext));
        ArrayList types = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> it.getExportedObjectsByType(TypesPackage.Literals.TYPE);
        Iterable _flatten = Iterables.concat((Iterable)ListExtensions.map((List)visibleContainers, (Functions.Function1)_function));
        for (IEObjectDescription descr : _flatten) {
            boolean isPolyFill = N4JSResourceDescriptionStrategy.getPolyfill(descr);
            boolean isStaticPolyFill = N4JSResourceDescriptionStrategy.getStaticPolyfill(descr);
            if (!isPolyFill || isStaticPolyFill) continue;
            types.add(descr);
        }
        return types;
    }

    @Check
    public void checkCyclicDependencies(JSONDocument document) {
        IN4JSProject project = (IN4JSProject)this._iN4JSCore.findProject(document.eResource().getURI()).orNull();
        if (project != null) {
            SourceContainerAwareDependencyProvider dependencyProvider = new SourceContainerAwareDependencyProvider(true);
            DependencyTraverser traverser = new DependencyTraverser((Object)project, (DependencyTraverser.DependencyProvider)dependencyProvider, true);
            DependencyCycle traversalResult = traverser.findCycle();
            boolean _hasCycle = traversalResult.hasCycle();
            if (_hasCycle) {
                JSONValue nameValue = this.getSingleDocumentValue(PackageJsonProperties.NAME);
                Function _function = it -> this.calculateName((IN4JSProject)it);
                String message = IssueCodes.getMessageForPROJECT_DEPENDENCY_CYCLE(traversalResult.prettyPrint(_function));
                this.addIssuePreferred(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EObject[]{nameValue})), message, "PROJECT_DEPENDENCY_CYCLE");
            } else {
                this.holdsProjectWithTestFragmentDependsOnTestLibrary(project);
            }
        }
    }

    private void holdsProjectWithTestFragmentDependsOnTestLibrary(IN4JSProject project) {
        boolean _not;
        boolean hasTestFragment;
        JSONValue sourcesSection = this.getSingleDocumentValue(PackageJsonProperties.SOURCES, JSONValue.class);
        List<SourceContainerDescription> sourceContainers = PackageJsonUtils.asSourceContainerDescriptionsOrEmpty(sourcesSection);
        if (sourceContainers == null) {
            return;
        }
        Functions.Function1 _function = sf -> SourceContainerType.TEST.equals((Object)sf.getSourceContainerType());
        SourceContainerDescription _findFirst = (SourceContainerDescription)IterableExtensions.findFirst(sourceContainers, (Functions.Function1)_function);
        boolean bl = hasTestFragment = _findFirst != null;
        if (!hasTestFragment) {
            return;
        }
        boolean _anyDependsOnTestLibrary = this.anyDependsOnTestLibrary(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IN4JSProject[]{project})));
        boolean bl2 = _not = !_anyDependsOnTestLibrary;
        if (_not) {
            this.addIssuePreferred(Collections.unmodifiableList(CollectionLiterals.newArrayList()), IssueCodes.getMessageForSRCTEST_NO_TESTLIB_DEP("org.eclipse.n4js.mangelhaft"), "SRCTEST_NO_TESTLIB_DEP");
        }
    }

    private boolean anyDependsOnTestLibrary(List<? extends IN4JSProject> projects) {
        SourceContainerAwareDependencyProvider dependencyProvider = new SourceContainerAwareDependencyProvider(true);
        HasTestDependencyVisitor hasTestDependencyVisitor = new HasTestDependencyVisitor();
        for (IN4JSProject iN4JSProject : projects) {
            DependencyTraverser dependencyTraverser = new DependencyTraverser((Object)iN4JSProject, (DependencyTraverser.DependencyVisitor)hasTestDependencyVisitor, (DependencyTraverser.DependencyProvider)dependencyProvider, true);
            dependencyTraverser.traverse();
        }
        return hasTestDependencyVisitor.hasTestDependencies;
    }

    private String calculateName(IN4JSProject it) {
        return it.getProjectName();
    }

    @CheckProperty(property=PackageJsonProperties.TESTED_PROJECTS)
    public void checkTestedProjectsType(JSONValue testedProjectsValue) {
        ProjectDescription description = this.getProjectDescription();
        ProjectType _projectType = description.getProjectType();
        boolean _equals = Objects.equal((Object)ProjectType.TEST, (Object)_projectType);
        if (_equals) {
            boolean _not;
            EList projects = description.getTestedProjects();
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)projects);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                ProjectType refProjectType;
                Functions.Function1 _function;
                boolean _exists;
                Map<String, IN4JSProject> allProjects = this.getAllProjectsByName();
                ProjectReference head = (ProjectReference)IterableExtensions.head((Iterable)projects);
                IN4JSProject _get = allProjects.get(head.getProjectName());
                ProjectType _projectType_1 = null;
                if (_get != null) {
                    _projectType_1 = _get.getProjectType();
                }
                if (_exists = IterableExtensions.exists((Iterable)projects, (Functions.Function1)(_function = arg_0 -> N4JSProjectSetupJsonValidatorExtension.lambda$7(allProjects, refProjectType = _projectType_1, arg_0)))) {
                    this.addIssue(IssueCodes.getMessageForMISMATCHING_TESTED_PROJECT_TYPES(), (EObject)testedProjectsValue, "MISMATCHING_TESTED_PROJECT_TYPES");
                }
            }
        }
    }

    @CheckProperty(property=PackageJsonProperties.DEPENDENCIES)
    public void checkHasConsistentImplementationIdChain(JSONValue dependenciesValue) {
        if (!(dependenciesValue instanceof JSONObject)) {
            return;
        }
        EList dependencyPairs = ((JSONObject)dependenciesValue).getNameValuePairs();
        ProjectDescription description = this.getProjectDescription();
        if (Objects.equal((Object)ProjectType.LIBRARY, (Object)description.getProjectType()) && !StringExtensions.isNullOrEmpty((String)description.getImplementationId())) {
            String expectedImplementationId = description.getImplementationId();
            Map<String, IN4JSProject> allProjects = this.getAllProjectsByName();
            Consumer<NameValuePair> _function = pair -> {
                String actualImplementationId;
                String dependencyProjectName = pair.getName();
                IN4JSProject _get = (IN4JSProject)allProjects.get(dependencyProjectName);
                Optional<String> _implementationId = null;
                if (_get != null) {
                    _implementationId = _get.getImplementationId();
                }
                String _orNull = null;
                if (_implementationId != null) {
                    _orNull = (String)_implementationId.orNull();
                }
                if (!StringExtensions.isNullOrEmpty((String)(actualImplementationId = _orNull)) && !Objects.equal((Object)actualImplementationId, (Object)expectedImplementationId)) {
                    String message = IssueCodes.getMessageForMISMATCHING_IMPLEMENTATION_ID(expectedImplementationId, dependencyProjectName, actualImplementationId);
                    this.addIssue(message, (EObject)pair, "MISMATCHING_IMPLEMENTATION_ID");
                }
            };
            IterableExtensions.filterNull((Iterable)dependencyPairs).forEach(_function);
        }
    }

    @CheckProperty(property=PackageJsonProperties.DEPENDENCIES)
    public void checkExternalProjectDoesNotReferenceWorkspaceProject(JSONValue dependenciesValue) {
        boolean _tripleEquals;
        Map<String, IN4JSProject> allProjects = this.getAllProjectsByName();
        ProjectDescription description = this.getProjectDescription();
        String _projectName = description.getProjectName();
        boolean bl = _tripleEquals = _projectName == null;
        if (_tripleEquals) {
            return;
        }
        IN4JSProject currentProject = allProjects.get(description.getProjectName());
        if (currentProject == null || !currentProject.exists() || currentProject.isExternal()) {
            return;
        }
        HashSet visitedProjectNames = CollectionLiterals.newHashSet();
        Stack stack = new Stack();
        Functions.Function1 _function = it -> it.isExternal();
        Iterables.addAll(stack, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter(currentProject.getAllDirectDependencies(), IN4JSProject.class), (Functions.Function1)_function));
        while (!stack.isEmpty()) {
            Functions.Function1 _function_1;
            boolean _not;
            IN4JSProject actual = (IN4JSProject)stack.pop();
            String actualId = actual.getProjectName();
            boolean _isExternal = actual.isExternal();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Implementation error. Only external projects are expected: ");
            _builder.append((Object)actual);
            _builder.append(".");
            Preconditions.checkState((boolean)_isExternal, (Object)_builder);
            boolean _add = visitedProjectNames.add(actualId);
            boolean bl2 = _not = !_add;
            if (_not) {
                return;
            }
            Iterable actualDirectDependencies = Iterables.filter(actual.getAllDirectDependencies(), IN4JSProject.class);
            IN4JSProject workspaceDependency = (IN4JSProject)IterableExtensions.findFirst((Iterable)actualDirectDependencies, (Functions.Function1)(_function_1 = it -> {
                boolean _isExternal_1 = it.isExternal();
                return !_isExternal_1;
            }));
            if (workspaceDependency != null) {
                String workspaceDependencyId = workspaceDependency.getProjectName();
                String message = IssueCodes.getMessageForEXTERNAL_PROJECT_REFERENCES_WORKSPACE_PROJECT(actualId, workspaceDependencyId);
                this.addIssue(message, (EObject)dependenciesValue, "EXTERNAL_PROJECT_REFERENCES_WORKSPACE_PROJECT");
                return;
            }
            Functions.Function1 _function_2 = it -> it.isExternal();
            Iterables.addAll(stack, (Iterable)IterableExtensions.filter((Iterable)actualDirectDependencies, (Functions.Function1)_function_2));
        }
    }

    @Check
    public void checkDependenciesAndDevDependencies(JSONDocument document) {
        ProjectType _projectType;
        boolean _equals;
        boolean _not;
        Optional<? extends IN4JSProject> project = this._iN4JSCore.findProject(document.eResource().getURI());
        boolean isExternal = project.isPresent() && ((IN4JSProject)project.get()).isExternal();
        Iterable<ValidationProjectReference> references = this.getDependencies(!isExternal);
        boolean _isEmpty = IterableExtensions.isEmpty(references);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.checkReferencedProjects(references, this.createDependenciesPredicate(), "dependencies or devDependencies", false, false);
        }
        if (_equals = Objects.equal((Object)(_projectType = this.getProjectDescription().getProjectType()), (Object)ProjectType.API)) {
            this.internalValidateAPIProjectReferences(references);
        }
    }

    private Iterable<ValidationProjectReference> getDependencies(boolean includeDevDependencies) {
        ArrayList references = CollectionLiterals.newArrayList();
        Collection<JSONValue> _documentValues = this.getDocumentValues(PackageJsonProperties.DEPENDENCIES);
        for (JSONValue value : _documentValues) {
            List<ValidationProjectReference> _referencesFromDependenciesObject = this.getReferencesFromDependenciesObject(value);
            Iterables.addAll((Collection)references, _referencesFromDependenciesObject);
        }
        if (includeDevDependencies) {
            Collection<JSONValue> _documentValues_1 = this.getDocumentValues(PackageJsonProperties.DEV_DEPENDENCIES);
            for (JSONValue value_1 : _documentValues_1) {
                List<ValidationProjectReference> _referencesFromDependenciesObject_1 = this.getReferencesFromDependenciesObject(value_1);
                Iterables.addAll((Collection)references, _referencesFromDependenciesObject_1);
            }
        }
        return references;
    }

    public void internalValidateAPIProjectReferences(Iterable<ValidationProjectReference> references) {
        Functions.Function1 _function = ref -> Pair.of((Object)ref, (Object)this.getAllProjectsByName().get(((ValidationProjectReference)ref).referencedProjectName));
        Functions.Function1 _function_1 = pair -> Objects.equal((Object)((IN4JSProject)pair.getValue()).getProjectType(), (Object)ProjectType.LIBRARY) && ((IN4JSProject)pair.getValue()).getImplementationId().isPresent();
        Iterable libraryDependenciesWithImplId = IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(references, (Functions.Function1)_function)), (Functions.Function1)_function_1);
        for (Pair projectPair : libraryDependenciesWithImplId) {
            ValidationProjectReference reference = (ValidationProjectReference)projectPair.getKey();
            this.addIssue(IssueCodes.getMessageForINVALID_API_PROJECT_DEPENDENCY(reference.referencedProjectName), reference.astRepresentation, "INVALID_API_PROJECT_DEPENDENCY");
        }
    }

    @CheckProperty(property=PackageJsonProperties.EXTENDED_RUNTIME_ENVIRONMENT)
    public void checkExtendedRuntimeEnvironment(JSONValue extendedRuntimeEnvironmentValue) {
        boolean _not;
        boolean _checkFeatureRestrictions = this.checkFeatureRestrictions("extended runtime environment", extendedRuntimeEnvironmentValue, RE_TYPE);
        boolean bl = _not = !_checkFeatureRestrictions;
        if (_not) {
            return;
        }
        List<ValidationProjectReference> references = this.getReferencesFromJSONStringLiteral(extendedRuntimeEnvironmentValue);
        this.checkReferencedProjects(references, this.forN4jsProjects(RE_TYPE), "extended runtime environment", false, false);
    }

    @CheckProperty(property=PackageJsonProperties.REQUIRED_RUNTIME_LIBRARIES)
    public void checkRequiredRuntimeLibraries(JSONValue requiredRuntimeLibrariesValue) {
        boolean _not;
        boolean _checkFeatureRestrictions = this.checkFeatureRestrictions("required runtime libraries", requiredRuntimeLibrariesValue, ProjectTypePredicate.not(RE_TYPE));
        boolean bl = _not = !_checkFeatureRestrictions;
        if (_not) {
            return;
        }
        List<ValidationProjectReference> references = this.getReferencesFromJSONStringArray(requiredRuntimeLibrariesValue);
        this.checkReferencedProjects(references, this.forN4jsProjects(RL_TYPE), "required runtime libraries", true, false);
    }

    @CheckProperty(property=PackageJsonProperties.PROVIDED_RUNTIME_LIBRARIES)
    public void checkProvidedRuntimeLibraries(JSONValue providedRuntimeLibraries) {
        boolean _not;
        boolean _checkFeatureRestrictions = this.checkFeatureRestrictions("provided runtime libraries", providedRuntimeLibraries, RE_TYPE);
        boolean bl = _not = !_checkFeatureRestrictions;
        if (_not) {
            return;
        }
        List<ValidationProjectReference> references = this.getReferencesFromJSONStringArray(providedRuntimeLibraries);
        this.checkReferencedProjects(references, this.forN4jsProjects(RL_TYPE), "provided runtime libraries", false, false);
    }

    @CheckProperty(property=PackageJsonProperties.TESTED_PROJECTS)
    public void checkTestedProjects(JSONValue testedProjectsValue) {
        boolean _not;
        boolean _checkFeatureRestrictions = this.checkFeatureRestrictions("tested projects", testedProjectsValue, TEST_TYPE);
        boolean bl = _not = !_checkFeatureRestrictions;
        if (_not) {
            return;
        }
        List<ValidationProjectReference> references = this.getReferencesFromJSONStringArray(testedProjectsValue);
        this.checkReferencedProjects(references, this.forN4jsProjects(ProjectTypePredicate.not(TEST_TYPE)), "tested projects", true, false);
    }

    @CheckProperty(property=PackageJsonProperties.INIT_MODULES)
    public void checkInitModules(JSONValue initModulesValue) {
        boolean _checkFeatureRestrictions = this.checkFeatureRestrictions(PackageJsonProperties.INIT_MODULES.name, initModulesValue, RE_OR_RL_TYPE);
        if (_checkFeatureRestrictions && initModulesValue instanceof JSONArray) {
            Functions.Function1 _function = l -> l.getValue().isEmpty();
            Consumer<JSONStringLiteral> _function_1 = l -> this.addIssue(IssueCodes.getMessageForPKGJ_EMPTY_INIT_MODULE(), (EObject)l, "PKGJ_EMPTY_INIT_MODULE");
            IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((JSONArray)initModulesValue).getElements(), JSONStringLiteral.class), (Functions.Function1)_function).forEach(_function_1);
        }
    }

    @CheckProperty(property=PackageJsonProperties.EXEC_MODULE)
    public boolean checkExecModule(JSONValue execModuleValue) {
        boolean _xifexpression = false;
        boolean _checkFeatureRestrictions = this.checkFeatureRestrictions(PackageJsonProperties.EXEC_MODULE.name, execModuleValue, RE_OR_RL_TYPE);
        if (_checkFeatureRestrictions) {
            boolean _xifexpression_1 = false;
            if (execModuleValue instanceof JSONStringLiteral) {
                _xifexpression_1 = this.checkIsNonEmptyString((JSONStringLiteral)execModuleValue, PackageJsonProperties.EXEC_MODULE);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    @CheckProperty(property=PackageJsonProperties.IMPLEMENTATION_ID)
    public boolean checkImplementationId(JSONValue implementationIdValue) {
        return this.checkFeatureRestrictions(PackageJsonProperties.IMPLEMENTATION_ID.name, implementationIdValue, ProjectTypePredicate.not(ProjectTypePredicate.or(RE_OR_RL_TYPE, TEST_TYPE, new ProjectTypePredicate[0])));
    }

    @CheckProperty(property=PackageJsonProperties.IMPLEMENTED_PROJECTS)
    public void checkImplementedProjects(JSONValue implementedProjectsValue) {
        boolean _checkFeatureRestrictions = this.checkFeatureRestrictions(PackageJsonProperties.IMPLEMENTED_PROJECTS.name, implementedProjectsValue, ProjectTypePredicate.not(ProjectTypePredicate.or(RE_OR_RL_TYPE, TEST_TYPE, new ProjectTypePredicate[0])));
        if (_checkFeatureRestrictions) {
            List<ValidationProjectReference> references = this.getReferencesFromJSONStringArray(implementedProjectsValue);
            this.checkReferencedProjects(references, this.forN4jsProjects(API_TYPE), "implemented projects", false, true);
            JSONValue implementationIdValue = this.getSingleDocumentValue(PackageJsonProperties.IMPLEMENTATION_ID);
            if (!references.isEmpty() && implementationIdValue == null) {
                this.addIssue(IssueCodes.getMessageForPKGJ_APIIMPL_MISSING_IMPL_ID(), implementedProjectsValue.eContainer(), (EStructuralFeature)JSONPackage.Literals.NAME_VALUE_PAIR__NAME, "PKGJ_APIIMPL_MISSING_IMPL_ID", new String[0]);
            }
        }
    }

    @CheckProperty(property=PackageJsonProperties.MODULE_FILTERS)
    public void checkModuleFilters(JSONValue moduleFiltersValue) {
        IN4JSProject project = (IN4JSProject)this._iN4JSCore.findProject(moduleFiltersValue.eResource().getURI()).get();
        if (!(moduleFiltersValue instanceof JSONObject)) {
            return;
        }
        Multimap<String, JSONValue> nameValuePairs = this.collectObjectValues((JSONObject)moduleFiltersValue);
        Functions.Function1 _function = it -> it.getElements();
        Functions.Function1 _function_1 = filter -> ASTTraceable.of((EObject)filter, PackageJsonUtils.asModuleFilterSpecifierOrNull(filter));
        Iterable filterSpecifierTraceables = IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)nameValuePairs.values(), JSONArray.class), (Functions.Function1)_function)), (Functions.Function1)_function_1);
        this.holdsValidModuleSpecifiers(filterSpecifierTraceables, project);
    }

    private void holdsValidModuleSpecifiers(Iterable<ASTTraceable<ModuleFilterSpecifier>> moduleFilterSpecifiers, IN4JSProject project) {
        ArrayList<ASTTraceable<ModuleFilterSpecifier>> validFilterSpecifier = new ArrayList<ASTTraceable<ModuleFilterSpecifier>>();
        for (ASTTraceable<ModuleFilterSpecifier> filterSpecifier : moduleFilterSpecifiers) {
            boolean valid = this.holdsValidModuleFilterSpecifier(filterSpecifier);
            if (!valid) continue;
            validFilterSpecifier.add(filterSpecifier);
        }
        this.internalCheckModuleSpecifierHasFile(project, validFilterSpecifier);
    }

    private boolean holdsValidModuleFilterSpecifier(ASTTraceable<ModuleFilterSpecifier> filterSpecifierTraceable) {
        boolean _tripleNotEquals;
        String wrongWildcardPattern = "***";
        ModuleFilterSpecifier _element = null;
        if (filterSpecifierTraceable != null) {
            _element = (ModuleFilterSpecifier)filterSpecifierTraceable.element;
        }
        ModuleFilterSpecifier filterSpecifier = _element;
        String _moduleSpecifierWithWildcard = null;
        if (filterSpecifier != null) {
            _moduleSpecifierWithWildcard = filterSpecifier.getModuleSpecifierWithWildcard();
        }
        boolean bl = _tripleNotEquals = _moduleSpecifierWithWildcard != null;
        if (_tripleNotEquals) {
            boolean _contains = filterSpecifier.getModuleSpecifierWithWildcard().contains("***");
            if (_contains) {
                this.addIssue(IssueCodes.getMessageForPKGJ_INVALID_WILDCARD("***"), filterSpecifierTraceable.astElement, "PKGJ_INVALID_WILDCARD");
                return false;
            }
            String wrongRelativeNavigation = "../";
            boolean _contains_1 = filterSpecifier.getModuleSpecifierWithWildcard().contains("../");
            if (_contains_1) {
                this.addIssue(IssueCodes.getMessageForPKGJ_NO_RELATIVE_NAVIGATION(), filterSpecifierTraceable.astElement, "PKGJ_NO_RELATIVE_NAVIGATION");
                return false;
            }
        }
        JSONValue astElement = (JSONValue)filterSpecifierTraceable.astElement;
        String _switchResult = null;
        boolean _matched = false;
        if (astElement instanceof JSONStringLiteral) {
            _matched = true;
            _switchResult = ((JSONStringLiteral)astElement).getValue();
        }
        if (!_matched && astElement instanceof JSONObject) {
            _matched = true;
            _switchResult = JSONModelUtils.getPropertyAsStringOrNull((JSONObject)((JSONObject)astElement), (String)PackageJsonProperties.NV_MODULE.name);
        }
        String moduleSpecifierWithWildcardFromAST = _switchResult;
        String _switchResult_1 = null;
        boolean _matched_1 = false;
        if (astElement instanceof JSONObject) {
            _matched_1 = true;
            _switchResult_1 = JSONModelUtils.getPropertyAsStringOrNull((JSONObject)((JSONObject)astElement), (String)PackageJsonProperties.NV_SOURCE_CONTAINER.name);
        }
        String sourceContainerFromAST = _switchResult_1;
        if (moduleSpecifierWithWildcardFromAST != null && moduleSpecifierWithWildcardFromAST.isEmpty() || sourceContainerFromAST != null && sourceContainerFromAST.isEmpty()) {
            this.addIssue(IssueCodes.getMessageForPKGJ_INVALID_MODULE_FILTER_SPECIFIER_EMPTY(), filterSpecifierTraceable.astElement, "PKGJ_INVALID_MODULE_FILTER_SPECIFIER_EMPTY");
            return false;
        }
        return true;
    }

    private void internalCheckModuleSpecifierHasFile(IN4JSProject project, List<ASTTraceable<ModuleFilterSpecifier>> filterSpecifiers) {
        HashMap<ASTTraceable<ModuleFilterSpecifier>, Boolean> checkedFilterSpecifiers = new HashMap<ASTTraceable<ModuleFilterSpecifier>, Boolean>();
        Functions.Function1 _function = it -> it.element != null;
        Functions.Function1 _function_1 = p -> p;
        Functions.Function1 _function_2 = it -> false;
        checkedFilterSpecifiers.putAll(IterableExtensions.toMap((Iterable)IterableExtensions.filter(filterSpecifiers, (Functions.Function1)_function), (Functions.Function1)_function_1, (Functions.Function1)_function_2));
        try {
            ModuleSpecifierFileVisitor treeWalker = new ModuleSpecifierFileVisitor(this, project, checkedFilterSpecifiers);
            Files.walkFileTree(project.getLocationPath(), treeWalker);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                URI _uRI = this.getDocument().eResource().getURI();
                String _plus = "Failed to check module filter section of package.json file " + _uRI;
                String _plus_1 = String.valueOf(_plus) + ".";
                LOGGER.error((Object)_plus_1);
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        Functions.Function1 _function_3 = e_1 -> {
            Boolean _value = (Boolean)e_1.getValue();
            return _value == false;
        };
        Functions.Function1 _function_4 = e_1 -> (ASTTraceable)e_1.getKey();
        Iterable unmatchedSpecifiers = IterableExtensions.map((Iterable)IterableExtensions.filter(checkedFilterSpecifiers.entrySet(), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
        for (ASTTraceable filterSpecifier : unmatchedSpecifiers) {
            String msg = IssueCodes.getMessageForPKGJ_MODULE_FILTER_DOES_NOT_MATCH(((ModuleFilterSpecifier)filterSpecifier.element).getModuleSpecifierWithWildcard());
            this.addIssue(msg, filterSpecifier.astElement, "PKGJ_MODULE_FILTER_DOES_NOT_MATCH");
        }
    }

    private void addNoValidationForN4JSFilesIssue(ASTTraceable<ModuleFilterSpecifier> filterSpecifier) {
        EObject _eContainer = filterSpecifier.astElement.eContainer().eContainer();
        String moduleFilterType = ((NameValuePair)_eContainer).getName();
        this.addIssue(IssueCodes.getMessageForPKGJ_FILTER_NO_N4JS_MATCH(moduleFilterType), filterSpecifier.astElement, "PKGJ_FILTER_NO_N4JS_MATCH");
    }

    public boolean checkFeatureRestrictions(String featureDescription, JSONValue value, Predicate<ProjectType> supportedTypesPredicate) {
        boolean _not;
        ProjectType type;
        ProjectDescription _projectDescription = this.getProjectDescription();
        ProjectType _projectType = null;
        if (_projectDescription != null) {
            _projectType = _projectDescription.getProjectType();
        }
        if ((type = _projectType) == null) {
            return false;
        }
        boolean _isEmptyValue = this.isEmptyValue(value);
        if (_isEmptyValue) {
            return true;
        }
        Object _xifexpression = null;
        EObject _eContainer = value.eContainer();
        _xifexpression = _eContainer instanceof NameValuePair ? value.eContainer() : value;
        JSONValue issueTarget = _xifexpression;
        boolean _apply = supportedTypesPredicate.apply((Object)type);
        boolean bl = _not = !_apply;
        if (_not) {
            this.addIssue(IssueCodes.getMessageForINVALID_FEATURE_FOR_PROJECT_TYPE(StringExtensions.toFirstUpper((String)featureDescription), this.getLabel(type)), (EObject)issueTarget, "INVALID_FEATURE_FOR_PROJECT_TYPE");
            return false;
        }
        return true;
    }

    private boolean isEmptyValue(JSONValue value) {
        return value instanceof JSONArray && ((JSONArray)value).getElements().isEmpty() || value instanceof JSONObject && ((JSONObject)value).getNameValuePairs().isEmpty();
    }

    private Predicate<IN4JSProject> createAPIDependenciesPredicate() {
        Predicate _function = it -> ProjectTypePredicate.anyOf(ProjectType.LIBRARY, ProjectType.VALIDATION, ProjectType.RUNTIME_LIBRARY, ProjectType.PLAINJS).apply(it.getProjectType());
        return Predicates.or(this.forN4jsProjects(API_TYPE), (Predicate)_function);
    }

    private Predicate<IN4JSProject> createDependenciesPredicate() {
        Predicate<IN4JSProject> _switchResult = null;
        ProjectType _projectType = this.getProjectDescription().getProjectType();
        if (_projectType != null) {
            switch (_projectType) {
                case API: {
                    _switchResult = this.createAPIDependenciesPredicate();
                    break;
                }
                case RUNTIME_LIBRARY: {
                    _switchResult = this.forN4jsProjects(RL_TYPE);
                    break;
                }
                case DEFINITION: {
                    _switchResult = this.forN4jsProjects(ProjectTypePredicate.not(PLAINJS_TYPE));
                    break;
                }
                default: {
                    _switchResult = Predicates.alwaysTrue();
                    break;
                }
            }
        } else {
            _switchResult = Predicates.alwaysTrue();
        }
        return _switchResult;
    }

    private List<ValidationProjectReference> getReferencesFromJSONStringArray(JSONValue value) {
        if (!(value instanceof JSONArray)) {
            return CollectionLiterals.emptyList();
        }
        Functions.Function1 _function = literal -> this.getReferencesFromJSONStringLiteral((JSONValue)literal);
        return IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)((JSONArray)value).getElements(), JSONStringLiteral.class), (Functions.Function1)_function));
    }

    private List<ValidationProjectReference> getReferencesFromDependenciesObject(JSONValue value) {
        if (!(value instanceof JSONObject)) {
            return CollectionLiterals.emptyList();
        }
        JSONObject jsonObj = (JSONObject)value;
        ArrayList<ValidationProjectReference> vprs = new ArrayList<ValidationProjectReference>();
        EList _nameValuePairs = jsonObj.getNameValuePairs();
        for (NameValuePair pair : _nameValuePairs) {
            JSONValue _value = pair.getValue();
            if (!(_value instanceof JSONStringLiteral)) continue;
            JSONValue _value_1 = pair.getValue();
            JSONStringLiteral stringLit = (JSONStringLiteral)_value_1;
            String prjID = pair.getName();
            NPMVersionRequirement npmVersion = this.semverHelper.parse(stringLit.getValue());
            ValidationProjectReference vpr = new ValidationProjectReference(prjID, npmVersion, (EObject)pair);
            vprs.add(vpr);
        }
        return vprs;
    }

    private List<ValidationProjectReference> getReferencesFromJSONStringLiteral(JSONValue value) {
        List _xifexpression = null;
        if (value instanceof JSONStringLiteral) {
            String _value = ((JSONStringLiteral)value).getValue();
            ValidationProjectReference _validationProjectReference = new ValidationProjectReference(_value, null, (EObject)value);
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ValidationProjectReference[]{_validationProjectReference}));
        }
        _xifexpression = CollectionLiterals.emptyList();
        return _xifexpression;
    }

    private void checkReferencedProjects(Iterable<ValidationProjectReference> references, Predicate<IN4JSProject> projectPredicate, String sectionLabel, boolean enforceDependency, boolean allowReflexive) {
        ProjectDescription description = this.getProjectDescription();
        Map<String, IN4JSProject> allProjects = this.getAllProjectsByName();
        HashMultimap existentIds = HashMultimap.create();
        URI projectDescriptionFileURI = this.getDocument().eResource().getURI();
        IN4JSProject currentProject = (IN4JSProject)this._iN4JSCore.findProject(projectDescriptionFileURI).orNull();
        Functions.Function1 _function = it -> ((ValidationProjectReference)it).referencedProjectName;
        Set allReferencedProjectNames = IterableExtensions.toSet((Iterable)IterableExtensions.map(references, (Functions.Function1)_function));
        for (ValidationProjectReference ref : references) {
            String id = ref.referencedProjectName;
            if (id == null) continue;
            this.checkReference(ref, allProjects, description, currentProject, allReferencedProjectNames, (HashMultimap<String, ValidationProjectReference>)existentIds, allowReflexive, projectPredicate, sectionLabel);
        }
        this.checkForDuplicateProjectReferences((Multimap<String, ValidationProjectReference>)existentIds);
        if (enforceDependency) {
            this.checkDeclaredDependencies(existentIds.values(), sectionLabel);
        }
    }

    private void checkReference(ValidationProjectReference ref, Map<String, IN4JSProject> allProjects, ProjectDescription description, IN4JSProject currentProject, Set<String> allReferencedProjectNames, HashMultimap<String, ValidationProjectReference> existentIds, boolean allowReflexive, Predicate<IN4JSProject> projectPredicate, String sectionLabel) {
        ProjectType _projectType;
        boolean _tripleNotEquals;
        boolean ignoreVersion;
        boolean _not_1;
        String id = ref.referencedProjectName;
        String currentProjectName = description.getProjectName();
        boolean _isEmpty = id.isEmpty();
        if (_isEmpty) {
            this.addIssue(IssueCodes.getMessageForPKGJ_EMPTY_PROJECT_REFERENCE(), ref.astRepresentation, "PKGJ_EMPTY_PROJECT_REFERENCE");
            return;
        }
        IN4JSProject project = allProjects.get(id);
        if (project == null || project.getProjectType() == null) {
            boolean _not;
            boolean _isExternal = currentProject.isExternal();
            boolean bl = _not = !_isExternal;
            if (_not) {
                String msg = IssueCodes.getMessageForNON_EXISTING_PROJECT(id);
                String _xifexpression = null;
                _xifexpression = ref.npmVersion == null ? "" : ref.npmVersion.toString();
                String packageVersion = _xifexpression;
                this.addIssue(msg, ref.astRepresentation, null, "NON_EXISTING_PROJECT", new String[]{id, packageVersion});
            }
            return;
        }
        existentIds.put((Object)id, (Object)ref);
        if (!currentProject.isExternal() && project.isExternal() && !this.indexSynchronizer.isInIndex((URI)project.getProjectDescriptionLocation().orNull())) {
            String msg_1 = IssueCodes.getMessageForNON_REGISTERED_PROJECT(id);
            this.addIssue(msg_1, ref.astRepresentation, null, "NON_REGISTERED_PROJECT", new String[]{id});
            return;
        }
        if (Objects.equal((Object)currentProjectName, (Object)id) && !allowReflexive) {
            this.addProjectReferencesItselfIssue(ref.astRepresentation);
            return;
        }
        boolean _apply = projectPredicate.apply((Object)project);
        boolean bl = _not_1 = !_apply;
        if (_not_1) {
            this.addInvalidProjectTypeIssue(ref.astRepresentation, id, project.getProjectType(), sectionLabel);
            return;
        }
        boolean bl2 = ignoreVersion = currentProject.isExternal() && description.isHasNestedNodeModulesFolder();
        if (!ignoreVersion) {
            this.checkVersions(currentProject, ref, id, allProjects);
        }
        boolean bl3 = _tripleNotEquals = (_projectType = description.getProjectType()) != ProjectType.DEFINITION;
        if (_tripleNotEquals) {
            this.checkImplProjectPresentForReferencedTypeDef(ref, project, allReferencedProjectNames);
        }
    }

    private void checkImplProjectPresentForReferencedTypeDef(ValidationProjectReference ref, IN4JSProject referencedProject, Set<String> allReferencedProjectNames) {
        boolean _tripleEquals;
        ProjectType _projectType = referencedProject.getProjectType();
        boolean bl = _tripleEquals = _projectType == ProjectType.DEFINITION;
        if (_tripleEquals) {
            boolean _not;
            String nameOfProjectDefinedByReferencedProject = referencedProject.getDefinesPackageName();
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)nameOfProjectDefinedByReferencedProject);
            boolean bl2 = _not = !_isNullOrEmpty;
            if (_not) {
                boolean _not_1;
                boolean _contains = allReferencedProjectNames.contains(nameOfProjectDefinedByReferencedProject);
                boolean bl3 = _not_1 = !_contains;
                if (_not_1) {
                    String msg = IssueCodes.getMessageForPKGJ_IMPL_PROJECT_IS_MISSING_FOR_TYPE_DEF(nameOfProjectDefinedByReferencedProject, ref.referencedProjectName);
                    this.addIssue(msg, ref.astRepresentation, "PKGJ_IMPL_PROJECT_IS_MISSING_FOR_TYPE_DEF");
                }
            }
        }
    }

    private void checkForDuplicateProjectReferences(Multimap<String, ValidationProjectReference> validProjectRefs) {
        String currentVendor = this.getProjectDescription().getVendorId();
        Consumer<String> _function = it -> {
            boolean _greaterThan;
            int _size = validProjectRefs.get(it).size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                HashMultimap referencesByNameAndVendor = HashMultimap.create();
                Consumer<ValidationProjectReference> _function_1 = it_1 -> referencesByNameAndVendor.put((Object)currentVendor, it_1);
                validProjectRefs.get(it).forEach(_function_1);
                Consumer<String> _function_2 = it_1 -> {
                    boolean _greaterThan_1;
                    Set mappedRefs = referencesByNameAndVendor.get(it_1);
                    int _size_1 = mappedRefs.size();
                    boolean bl = _greaterThan_1 = _size_1 > 1;
                    if (_greaterThan_1) {
                        Functions.Function1 _function_3 = it_2 -> NodeModelUtils.findActualNodeFor((EObject)((ValidationProjectReference)it_2).astRepresentation).getOffset();
                        Consumer<ValidationProjectReference> _function_4 = ref -> this.addDuplicateProjectReferenceIssue(((ValidationProjectReference)ref).astRepresentation, ((ValidationProjectReference)ref).referencedProjectName);
                        IterableExtensions.tail((Iterable)IterableExtensions.sortBy((Iterable)mappedRefs, (Functions.Function1)_function_3)).forEach(_function_4);
                    }
                };
                referencesByNameAndVendor.keySet().forEach(_function_2);
            }
        };
        validProjectRefs.asMap().keySet().forEach(_function);
    }

    private void checkDeclaredDependencies(Iterable<ValidationProjectReference> references, String sectionLabel) {
        Map<String, ProjectDependency> declaredDependencies = this.getDeclaredProjectDependencies();
        Consumer<ValidationProjectReference> _function = reference -> {
            boolean _not;
            boolean _containsKey = declaredDependencies.containsKey(((ValidationProjectReference)reference).referencedProjectName);
            boolean bl = _not = !_containsKey;
            if (_not) {
                this.addIssue(IssueCodes.getMessageForPKGJ_PROJECT_REFERENCE_MUST_BE_DEPENDENCY(((ValidationProjectReference)reference).referencedProjectName, sectionLabel), ((ValidationProjectReference)reference).astRepresentation, "PKGJ_PROJECT_REFERENCE_MUST_BE_DEPENDENCY");
            }
        };
        references.forEach(_function);
    }

    private void checkVersions(IN4JSProject curPrj, ValidationProjectReference ref, String id, Map<String, IN4JSProject> allProjects) {
        NPMVersionRequirement desiredVersion = ref.npmVersion;
        if (desiredVersion == null) {
            return;
        }
        IN4JSProject depProject = allProjects.get(id);
        VersionNumber availableVersion = depProject.getVersion();
        boolean availableVersionMatches = SemverMatcher.matches((VersionNumber)availableVersion, (NPMVersionRequirement)desiredVersion);
        if (availableVersionMatches) {
            return;
        }
        boolean curPrjShadows = this.shadowingInfoHelper.isShadowingProject(curPrj);
        boolean dependencyShadows = this.shadowingInfoHelper.isShadowingProject(depProject);
        String desiredStr = SemverSerializer.serialize((SemverToStringable)desiredVersion);
        String availableStr = SemverSerializer.serialize((VersionNumber)availableVersion);
        if (curPrjShadows || dependencyShadows) {
            String _xifexpression = null;
            _xifexpression = curPrjShadows ? "shadowing " : "";
            String curPrjShadowsStr = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = dependencyShadows ? "shadowed " : "";
            String dependencyShadowsStr = _xifexpression_1;
            String msg = IssueCodes.getMessageForNO_MATCHING_VERSION_SHADOWING(curPrjShadowsStr, dependencyShadowsStr, id, desiredStr, availableStr);
            this.addIssue(msg, ref.astRepresentation, "NO_MATCHING_VERSION_SHADOWING");
        } else {
            String msg_1 = IssueCodes.getMessageForNO_MATCHING_VERSION(id, desiredStr, availableStr);
            this.addIssue(msg_1, ref.astRepresentation, null, "NO_MATCHING_VERSION", new String[]{id, desiredVersion.toString()});
        }
    }

    protected ProjectDescription getProjectDescription() {
        Supplier _function = () -> {
            ProjectDescription _xblockexpression = null;
            JSONDocument doc = this.getDocument();
            _xblockexpression = this.projectDescriptionLoader.loadProjectDescriptionAtLocation(doc.eResource().getURI().trimSegments(1), doc);
            return _xblockexpression;
        };
        return (ProjectDescription)this.contextMemoize(PROJECT_DESCRIPTION_CACHE, _function);
    }

    protected Map<String, ProjectDependency> getDeclaredProjectDependencies() {
        Supplier _function = () -> {
            ProjectDescription description = this.getProjectDescription();
            Functions.Function1 _function_1 = d -> d.getProjectName();
            return IterableExtensions.toMap((Iterable)description.getProjectDependencies(), (Functions.Function1)_function_1);
        };
        return (Map)this.contextMemoize(DECLARED_DEPENDENCIES_CACHE, _function);
    }

    private CharSequence getLabel(ProjectType it) {
        String _xifexpression = null;
        if (it == null) {
            StringConcatenation _builder = new StringConcatenation();
            _xifexpression = _builder;
        } else {
            _xifexpression = this.upperUnderscoreToHumanReadable(it.toString());
        }
        return _xifexpression;
    }

    private String upperUnderscoreToHumanReadable(String s) {
        return Strings.nullToEmpty((String)s).replaceAll("_", " ").toLowerCase();
    }

    private void addProjectReferencesItselfIssue(EObject target) {
        this.addIssue(IssueCodes.getMessageForPROJECT_REFERENCES_ITSELF(), target, "PROJECT_REFERENCES_ITSELF");
    }

    private void addInvalidProjectTypeIssue(EObject target, String projectName, ProjectType type, String sectionLabel) {
        this.addIssue(IssueCodes.getMessageForINVALID_PROJECT_TYPE_REF(projectName, this.getLabel(type), sectionLabel), target, "INVALID_PROJECT_TYPE_REF");
    }

    private void addDuplicateProjectReferenceIssue(EObject target, String name) {
        this.addIssue(IssueCodes.getMessageForDUPLICATE_PROJECT_REF(name), target, "DUPLICATE_PROJECT_REF");
    }

    private void addIssuePreferred(Iterable<? extends EObject> preferredTargets, String message, String issueCode) {
        boolean _not;
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filterNull(preferredTargets));
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Consumer<EObject> _function = t -> this.addIssue(message, (EObject)t, issueCode);
            IterableExtensions.filterNull(preferredTargets).forEach(_function);
            return;
        }
        JSONValue nameValue = this.getSingleDocumentValue(PackageJsonProperties.NAME);
        if (nameValue != null) {
            this.addIssue(message, (EObject)nameValue, issueCode);
            return;
        }
        this.addIssue(message, (EObject)this.getDocument(), issueCode);
    }

    private Map<String, IN4JSProject> getAllProjectsByName() {
        Supplier _function = () -> {
            HashMap<String, IN4JSProject> res = new HashMap<String, IN4JSProject>();
            Consumer<IN4JSProject> _function_1 = p -> res.put(p.getProjectName(), (IN4JSProject)p);
            this._iN4JSCore.findAllProjects().forEach(_function_1);
            List<org.eclipse.xtext.util.Pair<URI, ProjectDescription>> _projectsIncludingUnnecessary = this.extWS.getProjectsIncludingUnnecessary();
            for (org.eclipse.xtext.util.Pair<URI, ProjectDescription> pair : _projectsIncludingUnnecessary) {
                URI location = (URI)pair.getFirst();
                IN4JSProject project = (IN4JSProject)this._iN4JSCore.findProject(location).orNull();
                if (this.shadowingInfoHelper.isShadowedProject(project) || res.containsKey(project.getProjectName())) continue;
                res.put(project.getProjectName(), project);
            }
            return res;
        };
        return (Map)this.contextMemoize(ALL_EXISTING_PROJECT_CACHE, _function);
    }

    private Predicate<IN4JSProject> forN4jsProjects(Predicate<ProjectType> predicate) {
        Predicate _function = it -> predicate.apply((Object)it.getProjectType());
        return _function;
    }

    private static /* synthetic */ Boolean lambda$7(Map map, ProjectType projectType, ProjectReference testedProject) {
        boolean _and = false;
        boolean _containsKey = map.containsKey(testedProject.getProjectName());
        if (!_containsKey) {
            _and = false;
        } else {
            boolean _notEquals;
            IN4JSProject _get_1 = (IN4JSProject)map.get(testedProject.getProjectName());
            ProjectType _projectType_2 = null;
            if (_get_1 != null) {
                _projectType_2 = _get_1.getProjectType();
            }
            _and = _notEquals = !Objects.equal((Object)projectType, (Object)_projectType_2);
        }
        return _and;
    }

    public static class HasTestDependencyVisitor
    implements DependencyTraverser.DependencyVisitor<IN4JSProject> {
        private boolean hasTestDependencies = false;

        public void accept(IN4JSProject project) {
            boolean _hasTestDependency = this.hasTestDependency(project);
            if (_hasTestDependency) {
                this.hasTestDependencies = true;
            }
        }

        private boolean hasTestDependency(IN4JSProject p) {
            ImmutableList<? extends IN4JSProject> _dependencies = p.getDependencies();
            for (IN4JSProject pDep : _dependencies) {
                if ((!"org.eclipse.n4js".equals(pDep.getVendorID()) || !"org.eclipse.n4js.mangelhaft".equals(pDep.getProjectName())) && !"org.eclipse.n4js.mangelhaft.assert".equals(pDep.getProjectName())) continue;
                return true;
            }
            return false;
        }
    }

    private static class ModuleSpecifierFileVisitor
    extends SimpleFileVisitor<Path> {
        private final N4JSProjectSetupJsonValidatorExtension setupValidator;
        private final IN4JSProject project;
        private final Map<ASTTraceable<ModuleFilterSpecifier>, Boolean> filterSpecifiers;

        public ModuleSpecifierFileVisitor(N4JSProjectSetupJsonValidatorExtension validatorExtension, IN4JSProject project, Map<ASTTraceable<ModuleFilterSpecifier>, Boolean> filterSpecifiers) {
            this.setupValidator = validatorExtension;
            this.project = project;
            this.filterSpecifiers = filterSpecifiers;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            Iterator<Map.Entry<ASTTraceable<ModuleFilterSpecifier>, Boolean>> iter = this.filterSpecifiers.entrySet().iterator();
            while (iter.hasNext()) {
                boolean matchesN4JSFile;
                String specifier;
                Map.Entry<ASTTraceable<ModuleFilterSpecifier>, Boolean> entry = iter.next();
                ASTTraceable<ModuleFilterSpecifier> filterSpecifierTraceable = entry.getKey();
                ModuleFilterSpecifier _element = (ModuleFilterSpecifier)filterSpecifierTraceable.element;
                String _moduleSpecifierWithWildcard = null;
                if (_element != null) {
                    _moduleSpecifierWithWildcard = _element.getModuleSpecifierWithWildcard();
                }
                boolean checkForMatches = (specifier = _moduleSpecifierWithWildcard) != null && this.isN4JSFile(specifier) && path.toFile().isFile() || !this.isN4JSFile(specifier);
                URI location = this.getFileInSources(this.project, (ModuleFilterSpecifier)filterSpecifierTraceable.element, path);
                if (!checkForMatches || location == null) continue;
                boolean matchesFile = this.setupValidator.wildcardHelper.isPathContainedByFilter(location, (ModuleFilterSpecifier)filterSpecifierTraceable.element);
                boolean bl = matchesN4JSFile = matchesFile && this.isN4JSFile(path.toString());
                if (matchesFile) {
                    entry.setValue(true);
                }
                if (matchesN4JSFile) {
                    this.setupValidator.addNoValidationForN4JSFilesIssue(filterSpecifierTraceable);
                }
                if (!matchesFile || !matchesN4JSFile) continue;
                iter.remove();
            }
            boolean _isEmpty = this.filterSpecifiers.isEmpty();
            if (_isEmpty) {
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }

        private URI getFileInSources(IN4JSProject project, ModuleFilterSpecifier filterSpecifier, Path filePath) {
            Path lPath = project.getLocationPath();
            Path filePathString = lPath.relativize(filePath);
            URI projectRelativeURI = URI.createURI((String)filePathString.toString());
            return project.getLocation().appendSegments(projectRelativeURI.segments());
        }

        private boolean isN4JSFile(String fileSpecifier) {
            return fileSpecifier.endsWith(".n4js") || fileSpecifier.endsWith(".n4jsx") || fileSpecifier.endsWith(".n4jsd");
        }
    }

    @Data
    private static class ValidationProjectReference {
        private final String referencedProjectName;
        private final NPMVersionRequirement npmVersion;
        private final EObject astRepresentation;

        public ValidationProjectReference(String referencedProjectName, NPMVersionRequirement npmVersion, EObject astRepresentation) {
            this.referencedProjectName = referencedProjectName;
            this.npmVersion = npmVersion;
            this.astRepresentation = astRepresentation;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.referencedProjectName == null ? 0 : this.referencedProjectName.hashCode());
            result = 31 * result + (this.npmVersion == null ? 0 : this.npmVersion.hashCode());
            result = 31 * result + (this.astRepresentation == null ? 0 : this.astRepresentation.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValidationProjectReference other = (ValidationProjectReference)obj;
            if (this.referencedProjectName == null ? other.referencedProjectName != null : !this.referencedProjectName.equals(other.referencedProjectName)) {
                return false;
            }
            if (this.npmVersion == null ? other.npmVersion != null : !this.npmVersion.equals(other.npmVersion)) {
                return false;
            }
            return !(this.astRepresentation == null ? other.astRepresentation != null : !this.astRepresentation.equals(other.astRepresentation));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("referencedProjectName", (Object)this.referencedProjectName);
            b.add("npmVersion", (Object)this.npmVersion);
            b.add("astRepresentation", (Object)this.astRepresentation);
            return b.toString();
        }

        @Pure
        public String getReferencedProjectName() {
            return this.referencedProjectName;
        }

        @Pure
        public NPMVersionRequirement getNpmVersion() {
            return this.npmVersion;
        }

        @Pure
        public EObject getAstRepresentation() {
            return this.astRepresentation;
        }
    }
}

