/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.builder;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.packagejson.PackageJsonBuilder;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.tests.builder.AbstractBuilderTest;
import org.eclipse.n4js.tests.builder.ExternalLibrariesSetupHelper;
import org.eclipse.n4js.tests.builder.TestEventListener;
import org.eclipse.n4js.tests.util.EclipseUIUtils;
import org.eclipse.n4js.tests.util.PackageJSONTestHelper;
import org.eclipse.n4js.tests.util.ProjectTestsHelper;
import org.eclipse.n4js.tests.util.ProjectTestsUtils;
import org.eclipse.n4js.utils.process.ProcessResult;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.junit.Assert;

public abstract class AbstractBuilderParticipantTest
extends AbstractBuilderTest {
    @Inject
    private Provider<IDirtyStateManager> dirtyStateManager;
    @Inject
    private ExternalLibrariesSetupHelper externalLibrariesSetupHelper;
    @Inject
    private ProjectTestsHelper projectTestsHelper;
    @Inject
    private IssueUtil issueUtil;
    @Inject
    protected PackageJSONTestHelper projectDescriptionTestHelper;
    Predicate<IMarker> ignoreSomeWarnings = marker -> {
        String code;
        switch (code = this.issueUtil.getCode(marker)) {
            case "DFG_NULL_DEREFERENCE": 
            case "CFG_LOCAL_VAR_UNUSED": {
                return false;
            }
        }
        return true;
    };

    protected IProject createJSProject(String projectName) throws CoreException {
        return ProjectTestsUtils.createJSProject(projectName);
    }

    protected IProject createJSProject(String projectName, String sourceFolder, String outputFolder, Consumer<PackageJsonBuilder> manifestAdjustments) throws CoreException {
        return ProjectTestsUtils.createJSProject(projectName, sourceFolder, outputFolder, manifestAdjustments);
    }

    protected IProject createN4JSProject(String projectName, ProjectType type) throws CoreException {
        IProject project = this.createJSProject(projectName, "src", "src-gen", b -> {
            PackageJsonBuilder packageJsonBuilder = b.withType(type);
        });
        this.configureProjectWithXtext(project);
        this.waitForAutoBuild();
        return project;
    }

    protected XtextEditor openAndGetXtextEditor(IFile file1, IWorkbenchPage page) {
        IEditorPart fileEditor = EclipseUIUtils.openFileEditor(file1, page, this.getEditorId());
        EclipseUIUtils.waitForEditorToBeActive(page, fileEditor);
        Assert.assertTrue((boolean)(fileEditor instanceof XtextEditor));
        XtextEditor fileXtextEditor = (XtextEditor)fileEditor;
        return fileXtextEditor;
    }

    protected IFolder configureProjectWithXtext(IProject project) throws CoreException {
        return ProjectTestsUtils.configureProjectWithXtext(project, "src");
    }

    protected IFolder configureProjectWithXtext(IProject project, String sourceFolder) throws CoreException {
        return ProjectTestsUtils.configureProjectWithXtext(project, sourceFolder);
    }

    protected IFile createTestFile(IFolder folder, String name, CharSequence content) throws CoreException {
        String fullName = String.valueOf(name) + "." + "n4js";
        return this.doCreateTestFile(folder, fullName, content);
    }

    protected IFile createTestN4JSDFile(IFolder folder, String name, CharSequence content) throws CoreException {
        String fullName = String.valueOf(name) + "." + "n4jsd";
        return this.doCreateTestFile(folder, fullName, content);
    }

    protected IFile createTestJSFile(IFolder folder, String name, CharSequence content) throws CoreException {
        String fullName = String.valueOf(name) + "." + "js";
        return this.doCreateTestFile(folder, fullName, content);
    }

    protected IFile doCreateTestFile(IFolder folder, String fullName, CharSequence content) throws CoreException {
        IFile file = folder.getFile(fullName);
        file.create((InputStream)new StringInputStream(content.toString()), true, IResourcesSetupUtil.monitor());
        this.waitForAutoBuild();
        return file;
    }

    protected IFile changeTestFile(IFile file, CharSequence newContent) throws CoreException {
        Assert.assertTrue((String)"test file should exist", (boolean)file.exists());
        file.setContents((InputStream)new StringInputStream(newContent.toString()), true, true, IResourcesSetupUtil.monitor());
        return file;
    }

    protected IFolder createFolder(IFolder superFolder, String path) throws CoreException {
        IFolder folder = superFolder.getFolder(path);
        if (!folder.exists()) {
            this.createParentFolder(folder);
            folder.create(true, true, null);
        }
        return folder;
    }

    protected IFolder createFolder(IProject project, String path) throws CoreException {
        IFolder folder = project.getFolder(path);
        if (!folder.exists()) {
            this.createParentFolder(folder);
            folder.create(true, true, null);
        }
        return folder;
    }

    protected void createParentFolder(IFolder folder) throws CoreException {
        IFolder parentFolder;
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder && !(parentFolder = (IFolder)parent).exists()) {
            this.createParentFolder(parentFolder);
            parentFolder.create(true, true, null);
        }
    }

    protected void setupExternalLibraries(boolean initShippedCode) throws Exception {
        this.externalLibrariesSetupHelper.setupExternalLibraries(initShippedCode);
    }

    protected void tearDownExternalLibraries(boolean tearDownShippedCode) throws Exception {
        this.externalLibrariesSetupHelper.tearDownExternalLibraries(tearDownShippedCode);
        super.tearDown();
    }

    protected void replaceFileContentAndWaitForRefresh(IFolder folder, IFile file, String newContent) throws IOException, CoreException {
        File fileInFilesystem = file.getLocation().toFile();
        FileWriter fileWriter = new FileWriter(fileInFilesystem);
        fileWriter.write(newContent);
        fileWriter.close();
        folder.refreshLocal(2, IResourcesSetupUtil.monitor());
        this.waitForAutoBuild();
    }

    protected IMarker[] assertMarkers(String assertMessage, IProject project, int count) throws CoreException {
        return ProjectTestsUtils.assertMarkers(assertMessage, (IResource)project, count, this.ignoreSomeWarnings);
    }

    protected IMarker[] assertMarkers(String assertMessage, IResource resource, int count) throws CoreException {
        return ProjectTestsUtils.assertMarkers(assertMessage, resource, count, this.ignoreSomeWarnings);
    }

    protected IMarker[] assertMarkers(String assertMessage, IResource resource, int count, Predicate<IMarker> markerPredicate) throws CoreException {
        return ProjectTestsUtils.assertMarkers(assertMessage, resource, count, markerPredicate, this.ignoreSomeWarnings);
    }

    protected IMarker[] assertMarkers(String assertMessage, IProject project, String markerType, int count) throws CoreException {
        return ProjectTestsUtils.assertMarkers(assertMessage, (IResource)project, markerType, count, this.ignoreSomeWarnings);
    }

    protected IMarker[] assertMarkers(String assertMessage, IResource resource, String markerType, int count) throws CoreException {
        return ProjectTestsUtils.assertMarkers(assertMessage, resource, markerType, count, this.ignoreSomeWarnings);
    }

    protected void assertNoIssues() throws CoreException {
        ProjectTestsUtils.assertNoIssues();
    }

    protected void assertIssues(String ... expectedMessages) throws CoreException {
        ProjectTestsUtils.assertIssues(expectedMessages);
    }

    protected void assertIssues(IResource resource, String ... expectedMessages) throws CoreException {
        ProjectTestsUtils.assertIssues(resource, expectedMessages);
    }

    protected ProcessResult runWithNodeRunnerUI(URI moduleToRun) {
        return this.projectTestsHelper.runWithNodeRunnerUI(moduleToRun);
    }

    protected ProcessResult runWithRunnerUI(String runnerId, String implementationId, URI moduleToRun) {
        return this.projectTestsHelper.runWithRunnerUI(runnerId, implementationId, moduleToRun);
    }

    protected List<Resource.Diagnostic> getEditorErrors(XtextEditor fileXtextEditor) {
        return (List)fileXtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<List<Resource.Diagnostic>, XtextResource>(){

            public List<Resource.Diagnostic> exec(XtextResource state) throws Exception {
                EcoreUtil.resolveAll((Resource)state);
                return state.getErrors();
            }
        });
    }

    protected List<Issue> getEditorValidationErrors(XtextEditor editor) {
        return (List)editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<List<Issue>, XtextResource>(){

            public List<Issue> exec(XtextResource state) throws Exception {
                IResourceValidator validator = state.getResourceServiceProvider().getResourceValidator();
                return validator.validate((Resource)state, CheckMode.ALL, CancelIndicator.NullImpl);
            }
        });
    }

    protected void setDocumentContent(String context, IFile file, XtextEditor fileEditor, String newContent) {
        IDirtyStateManager dirtyStateManager = (IDirtyStateManager)this.dirtyStateManager.get();
        TestEventListener eventListener = new TestEventListener(context, file);
        dirtyStateManager.addListener((IResourceDescription.Event.Listener)eventListener);
        this.setDocumentContent(fileEditor, newContent);
        eventListener.waitForFiredEvent();
        dirtyStateManager.removeListener((IResourceDescription.Event.Listener)eventListener);
        AbstractBuilderParticipantTest.waitForUpdateEditorJob();
    }

    protected void setDocumentContent(XtextEditor xtextEditor, String content) {
        Display.getCurrent().syncExec(() -> xtextEditor.getDocument().set(content));
    }

    protected static void waitForUpdateEditorJob() {
        ProjectTestsUtils.waitForUpdateEditorJob();
        ProjectTestsUtils.waitForAllJobs();
    }

    protected String getEditorId() {
        return "org.eclipse.n4js.N4JS";
    }

    protected java.net.URI getResourceUri(String segment, String ... restSegments) {
        String resourceName = this.getResourceName(segment, restSegments);
        URL url = this.getClass().getClassLoader().getResource(resourceName);
        try {
            return new File(FileLocator.resolve((URL)url).toURI()).getCanonicalFile().toURI();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Error while trying to locate resource at: " + resourceName + ".", e);
        }
    }

    protected String getResourceName(String segment, String ... restSegments) {
        return Joiner.on((String)"/").join((Iterable)Lists.asList((Object)segment, (Object[])restSegments));
    }
}

