/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.n4js.utils.io.FileMatchingMode;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FileMatcher
extends SimpleFileVisitor<Path> {
    private static final Logger LOGGER = Logger.getLogger(FileMatcher.class);
    private static final String GLOB_SYNTAX_PREFIX = "glob:";
    private final PathMatcher matcher;
    private final Collection<Path> matchedPaths;
    private final FileMatchingMode mode;

    public static Set<Path> scanFiles(Path root, String pattern) {
        return FileMatcher.scan(root, pattern, FileMatchingMode.FILES);
    }

    public static Set<Path> scanDirectories(Path root, String pattern) {
        return FileMatcher.scan(root, pattern, FileMatchingMode.DIRECTORIES);
    }

    private static Set<Path> scan(Path root, String pattern, FileMatchingMode mode) {
        try {
            boolean _exists = ((Path)Preconditions.checkNotNull((Object)root)).toFile().exists();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("File does not exist: ");
            _builder.append((Object)root);
            _builder.append(".");
            Preconditions.checkArgument((boolean)_exists, (Object)_builder);
            String _checkNotNull = (String)Preconditions.checkNotNull((Object)pattern);
            FileMatcher matcher = new FileMatcher(_checkNotNull, mode);
            Files.walkFileTree(root, matcher);
            Functions.Function1 _function = it -> root.relativize((Path)it);
            return IterableExtensions.toSet((Iterable)IterableExtensions.map(matcher.matchedPaths, (Functions.Function1)_function));
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Error while recursively scanning for files in ");
                _builder_1.append((Object)root);
                _builder_1.append(" with pattern: ");
                _builder_1.append(pattern);
                _builder_1.append(".");
                throw new RuntimeException(_builder_1.toString(), e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private FileMatcher(String pattern, FileMatchingMode mode) {
        String escapedPattern = ((String)Preconditions.checkNotNull((Object)pattern)).replaceAll("\\\\", "/");
        this.mode = mode;
        FileSystem _default = FileSystems.getDefault();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(GLOB_SYNTAX_PREFIX);
        _builder.append("**");
        _builder.append(escapedPattern);
        this.matcher = _default.getPathMatcher(_builder.toString());
        this.matchedPaths = CollectionLiterals.newArrayList();
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        FileVisitResult _xblockexpression = null;
        this.match(dir);
        _xblockexpression = FileVisitResult.CONTINUE;
        return _xblockexpression;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        FileVisitResult _xblockexpression = null;
        this.match(file);
        _xblockexpression = FileVisitResult.CONTINUE;
        return _xblockexpression;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
        FileVisitResult _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Error while visiting file at: ");
        _builder.append((Object)file);
        _builder.append(".");
        LOGGER.error((Object)_builder, (Throwable)e);
        _xblockexpression = FileVisitResult.CONTINUE;
        return _xblockexpression;
    }

    public boolean match(Path path) {
        boolean _xifexpression = false;
        if (path != null && this.mode.apply(path) && this.matcher.matches(path)) {
            _xifexpression = this.matchedPaths.add(path);
        }
        return _xifexpression;
    }
}

