/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.n4js.external.libraries.ExternalLibrariesActivator;
import org.eclipse.n4js.ui.external.EclipseExternalIndexSynchronizer;
import org.eclipse.n4js.ui.internal.ContributingResourceDescriptionPersister;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.BuildScheduler;
import org.eclipse.xtext.builder.impl.IBuildFlag;

public class N4JSExternalLibraryStartup
implements IStartup {
    @Inject
    private EclipseExternalIndexSynchronizer indexSynchronizer;
    @Inject
    private ContributingResourceDescriptionPersister descriptionPersister;
    @Inject
    private IWorkspace workspace;
    @Inject
    private BuildScheduler buildManager;
    @Inject
    private IBuilderState builderState;

    public void earlyStartup() {
        ICommandService commandService;
        if (ExternalLibrariesActivator.requiresInfrastructureForLibraryManager()) {
            new Thread(() -> {
                boolean indexIsEmpty = this.builderState.isEmpty();
                if (this.descriptionPersister.isRecoveryBuildRequired() || indexIsEmpty) {
                    this.descriptionPersister.scheduleRecoveryBuildOnContributions();
                    this.buildManager.scheduleBuildIfNecessary(Arrays.asList(this.workspace.getRoot().getProjects()), new IBuildFlag[]{IBuildFlag.RECOVERY_BUILD});
                }
            }).start();
        }
        if ((commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class)) != null) {
            commandService.addExecutionListener((IExecutionListener)new CheckNodeModulesSyncOnRefresh());
        }
    }

    class CheckNodeModulesSyncOnRefresh
    implements IExecutionListener {
        CheckNodeModulesSyncOnRefresh() {
        }

        public void notHandled(String commandId, NotHandledException exception) {
        }

        public void postExecuteFailure(String commandId, ExecutionException exception) {
        }

        public void preExecute(String commandId, ExecutionEvent event) {
        }

        public void postExecuteSuccess(String commandId, Object returnValue) {
            if ("org.eclipse.ui.file.refresh".equals(commandId)) {
                N4JSExternalLibraryStartup.this.indexSynchronizer.checkAndClearIndex((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

