/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.dtd.schema;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.dtd.ParseError;
import org.eclipse.ant.internal.ui.dtd.schema.AntDTDSchemaMessages;
import org.eclipse.ant.internal.ui.dtd.schema.Dfm;
import org.eclipse.ant.internal.ui.dtd.schema.Nfm;
import org.eclipse.ant.internal.ui.dtd.schema.NfmNode;
import org.eclipse.ant.internal.ui.dtd.util.SortedMap;
import org.eclipse.ant.internal.ui.dtd.util.SortedMapFactory;

public class NfmParser {
    public Dfm parse(Nfm nfm) throws ParseError {
        Dfm dfm = this.parseStart(nfm.getStart(), nfm.getStop());
        ArrayList<Dfm> dfms = new ArrayList<Dfm>();
        NfmParser.collect(dfm, dfms);
        HashMap<Dfm, Dfm> duplicates = new HashMap<Dfm, Dfm>();
        this.detect(dfms, duplicates);
        this.replace(dfms, duplicates);
        Nfm.free(nfm);
        NfmNode.freeAll();
        return dfm;
    }

    private void reportError(String name) throws ParseError {
        throw new ParseError(MessageFormat.format((String)AntDTDSchemaMessages.NfmParser_Ambiguous, (Object[])new Object[]{name}));
    }

    public static void collect(Dfm dfm, List<Dfm> dfms) {
        dfms.add(dfm);
        NfmParser.collect1(dfm, dfms);
    }

    private static void collect1(Dfm dfm, List<Dfm> dfms) {
        Object[] follows = dfm.getValues();
        if (follows != null) {
            int i = 0;
            while (i < follows.length) {
                Dfm follow = (Dfm)follows[i];
                if (!dfms.contains(follow)) {
                    dfms.add(follow);
                    NfmParser.collect1(follow, dfms);
                }
                ++i;
            }
        }
    }

    private void replace(ArrayList<Dfm> dfms, HashMap<Dfm, Dfm> removed) {
        for (Dfm dfm : dfms) {
            Object[] follows = dfm.getValues();
            if (follows == null) continue;
            int j = 0;
            while (j < follows.length) {
                Dfm replacement;
                Dfm follow = (Dfm)follows[j];
                while ((replacement = removed.get(follow)) != null) {
                    follow = replacement;
                }
                follows[j] = follow;
                ++j;
            }
        }
        for (Dfm dfm : removed.keySet()) {
            Dfm.free(dfm);
        }
    }

    private void detect(ArrayList<Dfm> dfms, HashMap<Dfm, Dfm> duplicates) throws ParseError {
        Object[] follows;
        Object[] accepts;
        for (Dfm dfm : dfms) {
            accepts = dfm.getKeys();
            follows = dfm.getValues();
            if (accepts == null) continue;
            String last = null;
            int i = 0;
            int lasti = -1;
            while (i < accepts.length) {
                String accept = accepts[i].toString();
                if (last != null && last == accept) {
                    if (follows[i] != follows[lasti]) {
                        this.checkConflict(new Conflict(accept, (Dfm)follows[lasti], (Dfm)follows[i]));
                    }
                } else {
                    last = accept;
                    lasti = i;
                }
                ++i;
            }
        }
        for (Dfm dfm : dfms) {
            accepts = dfm.getKeys();
            follows = dfm.getValues();
            boolean remove = false;
            if (accepts == null) continue;
            boolean[] removes = new boolean[accepts.length];
            String last = null;
            int i = 0;
            int lasti = -1;
            while (i < accepts.length) {
                String accept = accepts[i].toString();
                if (last != null && last == accept) {
                    remove = true;
                    removes[i] = true;
                    if (follows[i] != follows[lasti]) {
                        Dfm dup;
                        Dfm dfmhi = (Dfm)follows[i];
                        Dfm dfmlo = (Dfm)follows[lasti];
                        if (dfmhi.id < dfmlo.id) {
                            Dfm tmp = dfmhi;
                            dfmhi = dfmlo;
                            dfmlo = tmp;
                        }
                        if ((dup = duplicates.get(dfmhi)) == null || dfmlo.id < dup.id) {
                            duplicates.put(dfmhi, dfmlo);
                        } else {
                            duplicates.put(dfmlo, dup);
                        }
                    }
                } else {
                    last = accept;
                    lasti = i;
                }
                ++i;
            }
            if (!remove) continue;
            SortedMap map = dfm.getMap();
            int i2 = 0;
            Iterator<?> iterator = map.keyIterator();
            while (iterator.hasNext()) {
                iterator.next();
                if (removes[i2]) {
                    iterator.remove();
                }
                ++i2;
            }
            SortedMapFactory.freeMap(map);
        }
    }

    private void checkConflict(Conflict conflict) throws ParseError {
        Object[] accept2;
        Object[] accept1;
        if (conflict.dfm1.accepting != conflict.dfm2.accepting) {
            this.reportError(conflict.name);
        }
        if ((accept1 = conflict.dfm1.getKeys()) == null != ((accept2 = conflict.dfm2.getKeys()) == null)) {
            this.reportError(conflict.name);
        }
        if (accept1 != null) {
            if (accept1.length != accept2.length) {
                this.reportError(conflict.name);
            }
            int j = 0;
            while (j < accept2.length) {
                if (accept1[j] != accept2[j]) {
                    this.reportError(conflict.name);
                }
                ++j;
            }
        }
    }

    private Dfm parseStart(NfmNode start, NfmNode accept) {
        Dfm result;
        start.dfm = result = Dfm.dfm(false);
        while (start.next1 != null && start.next2 == null && start.symbol == null) {
            start = start.next1;
            start.dfm = result;
        }
        Dfm parsed = this.parse(1, start, accept);
        result.merge(parsed);
        Dfm.free(parsed);
        return result;
    }

    private void parseNext(int mark, Dfm result, NfmNode start, NfmNode accept) {
        Dfm parsed = this.parse(mark + 1, start, accept);
        result.merge(parsed);
        Dfm.free(parsed);
    }

    private Dfm parse(int mark, NfmNode start, NfmNode accept) {
        int saveMark;
        while (start.next1 != null && start.next2 == null && start.symbol == null) {
            start = start.next1;
        }
        if (start == accept) {
            return Dfm.dfm(true);
        }
        if (start.symbol != null) {
            NfmNode n;
            NfmNode next;
            Dfm nextdfm = null;
            NfmNode snext = next = start.next1;
            while (snext.dfm == null && snext.next1 != null && snext.next2 == null && snext.symbol == null) {
                snext = snext.next1;
            }
            if (snext.dfm != null) {
                n = next;
                while (n != snext) {
                    n.dfm = snext.dfm;
                    n = n.next1;
                }
                nextdfm = snext.dfm;
            } else {
                snext.dfm = nextdfm = Dfm.dfm(false);
                n = next;
                while (n != snext) {
                    n.dfm = nextdfm;
                    n = n.next1;
                }
                this.parseNext(mark, nextdfm, snext, accept);
            }
            Dfm dfm = Dfm.dfm(start.symbol, nextdfm);
            return dfm;
        }
        Dfm dfm1 = null;
        Dfm dfm2 = null;
        if (start.next1 != null && start.next1.mark != mark) {
            saveMark = start.next1.mark;
            start.next1.mark = mark;
            dfm1 = this.parse(mark, start.next1, accept);
            start.next1.mark = saveMark;
        }
        if (start.next2 != null && start.next2.mark != mark) {
            saveMark = start.next2.mark;
            start.next2.mark = mark;
            dfm2 = this.parse(mark, start.next2, accept);
            start.next2.mark = saveMark;
        }
        if (dfm2 != null) {
            if (dfm1 != null) {
                dfm1.merge(dfm2);
            } else {
                dfm1 = dfm2;
            }
        }
        return dfm1;
    }

    private static class Conflict {
        public String name;
        public Dfm dfm1;
        public Dfm dfm2;

        public Conflict(String name, Dfm dfm1, Dfm dfm2) {
            this.name = name;
            this.dfm1 = dfm1;
            this.dfm2 = dfm2;
        }

        public int hashCode() {
            return this.dfm1.hashCode() + this.dfm2.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conflict)) {
                return false;
            }
            Conflict other = (Conflict)o;
            return this.dfm1 == other.dfm1 && this.dfm2 == other.dfm2 || this.dfm1 == other.dfm2 && this.dfm2 == other.dfm1;
        }
    }
}

