/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.packagejson;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.projectDescription.ModuleLoader;
import org.eclipse.n4js.projectDescription.ProjectType;

public enum PackageJsonProperties {
    NAME("name", "Npm name", new PackageJsonProperties[0]),
    VERSION("version", "Npm semver version", "0.0.1", new PackageJsonProperties[0]),
    DEPENDENCIES("dependencies", "Dependencies of this npm", JSONObject.class, new PackageJsonProperties[0]),
    DEV_DEPENDENCIES("devDependencies", "Development dependencies of this npm", JSONObject.class, new PackageJsonProperties[0]),
    MAIN("main", "Main module. Path is relative to package root", new PackageJsonProperties[0]),
    N4JS("n4js", "N4JS section", JSONObject.class, new PackageJsonProperties[0]),
    PROJECT_TYPE("projectType", ProjectType.PLAINJS.getLiteral().toLowerCase(), N4JS),
    VENDOR_ID("vendorId", "", "vendor.default", N4JS),
    VENDOR_NAME("vendorName", "", N4JS),
    OUTPUT("output", "Output folder. Default is '.'", ".", N4JS),
    SOURCES("sources", "Source folders", JSONObject.class, N4JS),
    MODULE_FILTERS("moduleFilters", "", JSONObject.class, N4JS),
    MAIN_MODULE("mainModule", "Main module specifier. Starts from source folder(s)", "index", N4JS),
    TESTED_PROJECTS("testedProjects", "Projects that are tested by this project", JSONArray.class, N4JS),
    IMPLEMENTATION_ID("implementationId", "", N4JS),
    IMPLEMENTED_PROJECTS("implementedProjects", "", JSONArray.class, N4JS),
    EXTENDED_RUNTIME_ENVIRONMENT("extendedRuntimeEnvironment", "", N4JS),
    PROVIDED_RUNTIME_LIBRARIES("providedRuntimeLibraries", "", JSONArray.class, N4JS),
    REQUIRED_RUNTIME_LIBRARIES("requiredRuntimeLibraries", "", JSONArray.class, N4JS),
    MODULE_LOADER("moduleLoader", "", ModuleLoader.N4JS.name(), N4JS),
    INIT_MODULES("initModules", "", JSONArray.class, N4JS),
    EXEC_MODULE("execModule", "", N4JS),
    DEFINES_PACKAGE("definesPackage", "", N4JS),
    NO_VALIDATE("noValidate", "", JSONObject.class, N4JS),
    NO_MODULE_WRAP("noModuleWrap", "", JSONObject.class, N4JS),
    NV_SOURCE_CONTAINER("sourceContainer", "", JSONObject.class, N4JS, NO_VALIDATE),
    NV_MODULE("module", "", N4JS, NO_VALIDATE),
    NMW_SOURCE_CONTAINER("sourceContainer", "", JSONObject.class, N4JS, NO_MODULE_WRAP),
    NMW_MODULE("module", "", N4JS, NO_MODULE_WRAP),
    SOURCE("source", "List of source folders", JSONArray.class, N4JS, SOURCES);

    public static final ModuleLoader DEFAULT_MODULE_LOADER;
    public static final ModuleLoader DEFAULT_MODULE_LOADER_FOR_PLAINJS_AND_VALIDATION;
    public final PackageJsonProperties[] parents;
    public final String name;
    public final String description;
    public final String defaultValue;
    public final Class<? extends JSONValue> valueType;
    private static Map<String, PackageJsonProperties> nameToEnum;

    static {
        DEFAULT_MODULE_LOADER = ModuleLoader.N4JS;
        DEFAULT_MODULE_LOADER_FOR_PLAINJS_AND_VALIDATION = ModuleLoader.COMMONJS;
        nameToEnum = new HashMap<String, PackageJsonProperties>();
        PackageJsonProperties[] packageJsonPropertiesArray = PackageJsonProperties.values();
        int n = packageJsonPropertiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            PackageJsonProperties prop = packageJsonPropertiesArray[n2];
            if (nameToEnum.containsKey(prop.name)) {
                nameToEnum.put(prop.name, null);
            } else {
                nameToEnum.put(prop.name, prop);
            }
            ++n2;
        }
    }

    private PackageJsonProperties(String name, String description, PackageJsonProperties ... parents) {
        this(name, description, (Class<? extends JSONValue>)JSONStringLiteral.class, (String)null, parents);
    }

    private PackageJsonProperties(String name, String description, String defaultValue, PackageJsonProperties ... parents) {
        this(name, description, JSONStringLiteral.class, defaultValue, parents);
    }

    private PackageJsonProperties(String name, String description, Class<? extends JSONValue> valueType, PackageJsonProperties ... parents) {
        this(name, description, valueType, (String)null, parents);
    }

    private PackageJsonProperties(String name, String description, Class<? extends JSONValue> valueType, String defaultValue, PackageJsonProperties ... parents) {
        this.parents = parents;
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.valueType = valueType;
    }

    public static PackageJsonProperties valueOfNameOrNull(String name) {
        return nameToEnum.getOrDefault(name, null);
    }

    public static Set<String> getAllN4JSPropertyNames() {
        HashSet<String> n4jsPropNames = new HashSet<String>();
        List<PackageJsonProperties> n4jsProps = PackageJsonProperties.valuesOfPath(Lists.newArrayList((Object[])new String[]{PackageJsonProperties.N4JS.name}));
        for (PackageJsonProperties value : n4jsProps) {
            n4jsPropNames.add(value.name);
        }
        return n4jsPropNames;
    }

    public String[] getPathElements() {
        String[] pathElements = new String[this.parents.length + 1];
        int i = 0;
        while (i < this.parents.length) {
            pathElements[i] = this.parents[i].name;
            ++i;
        }
        pathElements[this.parents.length] = this.name;
        return pathElements;
    }

    public String getPath() {
        return String.join((CharSequence)".", this.getPathElements());
    }

    public static List<PackageJsonProperties> valuesOfPath(List<String> namePath) {
        LinkedList<PackageJsonProperties> resultList = new LinkedList<PackageJsonProperties>();
        CharSequence[] npArr = namePath.toArray(new String[namePath.size()]);
        String pathString = String.join((CharSequence)".", npArr);
        PackageJsonProperties[] packageJsonPropertiesArray = PackageJsonProperties.values();
        int n = packageJsonPropertiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            PackageJsonProperties pjp = packageJsonPropertiesArray[n2];
            String pjpPathString = PackageJsonProperties.joinPackageJsonProperties(".", pjp);
            if (pathString.equals(pjpPathString)) {
                resultList.add(pjp);
            }
            ++n2;
        }
        return resultList;
    }

    private static String joinPackageJsonProperties(String delimiter, PackageJsonProperties pjp) {
        String pjpPathString = "";
        PackageJsonProperties[] packageJsonPropertiesArray = pjp.parents;
        int n = pjp.parents.length;
        int n2 = 0;
        while (n2 < n) {
            PackageJsonProperties parent = packageJsonPropertiesArray[n2];
            if (pjpPathString.length() > 0) {
                pjpPathString = String.valueOf(pjpPathString) + delimiter;
            }
            pjpPathString = String.valueOf(pjpPathString) + parent.name;
            ++n2;
        }
        return pjpPathString;
    }
}

