/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.resource;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseCore;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.DefaultResourceUIServiceProvider;

@Singleton
public class OutputFolderAwareResourceServiceProvider
extends DefaultResourceUIServiceProvider {
    private final IN4JSEclipseCore eclipseCore;

    @Inject
    public OutputFolderAwareResourceServiceProvider(IResourceServiceProvider delegate, IN4JSEclipseCore eclipseCore) {
        super(delegate);
        this.eclipseCore = eclipseCore;
    }

    public boolean canBuild(URI uri, IStorage storage) {
        if (storage instanceof IFile && super.canBuild(uri, storage)) {
            Optional<? extends IN4JSSourceContainer> optional = this.eclipseCore.create((IFile)storage);
            return optional.isPresent() && ((IN4JSSourceContainer)optional.get()).exists();
        }
        return super.canBuild(uri, storage);
    }
}

