/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.shells;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.internal.services.RSEServicesMessages;
import org.eclipse.rse.internal.services.shells.TerminalServiceHostShell;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.AbstractShellService;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.terminals.ITerminalService;
import org.eclipse.rse.services.terminals.ITerminalShell;

public class TerminalShellService
extends AbstractShellService {
    ITerminalService fTerminalService;

    public TerminalShellService(ITerminalService terminalService) {
        this.fTerminalService = terminalService;
    }

    public IHostShell launchShell(String initialWorkingDirectory, String encoding, String[] environment, IProgressMonitor monitor) throws SystemMessageException {
        return this.runCommand(initialWorkingDirectory, ">", encoding, environment, monitor);
    }

    public IHostShell runCommand(String initialWorkingDirectory, String command, String encoding, String[] environment, IProgressMonitor monitor) throws SystemMessageException {
        ITerminalShell terminalShell = this.fTerminalService.launchTerminal("vt100", encoding, environment, initialWorkingDirectory, null, monitor);
        TerminalServiceHostShell hostShell = new TerminalServiceHostShell(terminalShell, initialWorkingDirectory, command, environment);
        return hostShell;
    }

    public Object getAdapter(Class adapter) {
        Object o = super.getAdapter(adapter);
        if (o == null && adapter.isAssignableFrom(ITerminalService.class)) {
            return this.fTerminalService;
        }
        return o;
    }

    public String getName() {
        return RSEServicesMessages.TerminalShellService_name;
    }

    public String getDescription() {
        return RSEServicesMessages.TerminalShellService_description;
    }
}

