/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contexts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.services.IEvaluationService;

public class DebugContextSourceProvider
extends AbstractSourceProvider
implements IDebugContextListener {
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"debugContext"};
    private final IDebugContextService fDebugContextService;
    private final IEvaluationService fEvaluationService;

    public DebugContextSourceProvider(IDebugContextService debugContextService, IEvaluationService evaluationService) {
        this.fDebugContextService = debugContextService;
        this.fDebugContextService.addDebugContextListener(this);
        this.fEvaluationService = evaluationService;
        this.fEvaluationService.addSourceProvider((ISourceProvider)this);
    }

    @Override
    public void debugContextChanged(DebugContextEvent event) {
        HashMap<String, ISelection> values = new HashMap<String, ISelection>(1);
        values.put("debugContext", event.getContext());
        if (Display.getCurrent() == null) {
            DebugUIPlugin.getStandardDisplay().asyncExec(() -> this.fireSourceChanged(0x40000000, values));
        } else {
            this.fireSourceChanged(0x40000000, values);
        }
    }

    public void dispose() {
        this.fDebugContextService.removeDebugContextListener(this);
        this.fEvaluationService.removeSourceProvider((ISourceProvider)this);
    }

    public String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    public Map getCurrentState() {
        HashMap<String, ISelection> currentState = new HashMap<String, ISelection>(1);
        currentState.put("debugContext", this.fDebugContextService.getActiveContext());
        return currentState;
    }
}

