/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.URIUtils;

public class ShadowingInfoHelper {
    @Inject
    private N4JSModel model;
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;

    public boolean isShadowingProject(IN4JSProject project) {
        return !this.findShadowedProjects(project).isEmpty();
    }

    public boolean isShadowedProject(IN4JSProject project) {
        return !this.findShadowingProjects(project).isEmpty();
    }

    public List<IN4JSProject> findShadowingProjects(IN4JSProject project) {
        String projectName = project.getProjectName();
        LinkedList<IN4JSProject> shadowingProjects = new LinkedList<IN4JSProject>();
        if (!project.isExternal()) {
            return shadowingProjects;
        }
        List<N4JSExternalProject> projectsForName = this.externalLibraryWorkspace.getProjectsForName(projectName);
        if (projectsForName != null && !projectsForName.isEmpty()) {
            N4JSExternalProject sameNamePrj;
            URI prjLoc = project.getLocation();
            LinkedList<N4JSExternalProject> projectsForNameReversed = new LinkedList<N4JSExternalProject>(projectsForName);
            Collections.reverse(projectsForNameReversed);
            Iterator sameNamedPrjsIter = projectsForNameReversed.iterator();
            while (sameNamedPrjsIter.hasNext()) {
                sameNamePrj = (N4JSExternalProject)((Object)sameNamedPrjsIter.next());
                URI otherPrjLoc = sameNamePrj.getIProject().getLocation();
                if (prjLoc == otherPrjLoc) break;
            }
            while (sameNamedPrjsIter.hasNext()) {
                sameNamePrj = (N4JSExternalProject)((Object)sameNamedPrjsIter.next());
                shadowingProjects.add(sameNamePrj.getIProject());
            }
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String prjName;
            IProject prj = iProjectArray[n2];
            if (prj.isAccessible() && projectName.equals(prjName = ProjectDescriptionUtils.convertEclipseProjectNameToN4JSProjectName(prj.getName()))) {
                URI loc = URIUtils.convert((IResource)prj);
                N4JSProject n4jsProject = this.model.getN4JSProject(loc);
                shadowingProjects.add(n4jsProject);
                break;
            }
            ++n2;
        }
        return shadowingProjects;
    }

    public List<N4JSExternalProject> findShadowedProjects(IN4JSProject project) {
        N4JSExternalProject sameNamePrj;
        String projectName = project.getProjectName();
        List<N4JSExternalProject> projectsForName = this.externalLibraryWorkspace.getProjectsForName(projectName);
        if (projectsForName == null || projectsForName.isEmpty()) {
            return Collections.emptyList();
        }
        if (!project.isExternal()) {
            return projectsForName;
        }
        LinkedList<N4JSExternalProject> shadowedProjects = new LinkedList<N4JSExternalProject>();
        URI prjLoc = project.getLocation();
        projectsForName = new LinkedList<N4JSExternalProject>(projectsForName);
        Iterator<N4JSExternalProject> sameNamedPrjsIter = projectsForName.iterator();
        while (sameNamedPrjsIter.hasNext()) {
            sameNamePrj = sameNamedPrjsIter.next();
            URI otherPrjLoc = sameNamePrj.getIProject().getLocation();
            if (prjLoc == otherPrjLoc) break;
        }
        while (sameNamedPrjsIter.hasNext()) {
            sameNamePrj = sameNamedPrjsIter.next();
            shadowedProjects.add(sameNamePrj);
        }
        return shadowedProjects;
    }
}

