/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class ValidatingScope
implements IScope {
    private final IScope delegate;
    private final Predicate<? super IEObjectDescription> allElementsFilter;

    public ValidatingScope(IScope delegate, Predicate<? super IEObjectDescription> allElementsFilter) {
        this.delegate = delegate;
        this.allElementsFilter = allElementsFilter;
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        return this.delegate.getSingleElement(name);
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        return this.delegate.getElements(name);
    }

    public IEObjectDescription getSingleElement(EObject object) {
        return this.delegate.getSingleElement(object);
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        return this.delegate.getElements(object);
    }

    public Iterable<IEObjectDescription> getAllElements() {
        return Iterables.filter((Iterable)this.delegate.getAllElements(), this.allElementsFilter);
    }

    public String toString() {
        String delegateString = null;
        try {
            delegateString = this.delegate.toString();
        }
        catch (Throwable t) {
            delegateString = String.valueOf(t.getClass().getSimpleName()) + " : " + t.getMessage();
        }
        return String.valueOf(this.getClass().getSimpleName()) + (this.allElementsFilter != null ? "[filter=" + this.allElementsFilter + "]" : "") + " -> " + delegateString;
    }
}

