/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import com.google.common.base.Predicate;
import java.util.Map;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.NameAndAccess;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TypingStrategy;

public class TypingStrategyFilter
implements Predicate<TMember> {
    private final TypingStrategy typingStrategy;
    private final boolean isWriteAccess;
    private final boolean inSpecCtor;

    public TypingStrategyFilter(TypingStrategy typingStrategy) {
        this(typingStrategy, false, false);
    }

    public TypingStrategyFilter(TypingStrategy typingStrategy, boolean isWriteAccess, boolean inSpecCtor) {
        this.typingStrategy = typingStrategy;
        this.isWriteAccess = isWriteAccess;
        this.inSpecCtor = inSpecCtor;
    }

    public TypingStrategy getTypingStrategy() {
        return this.typingStrategy;
    }

    public boolean apply(TMember member) {
        if (member.isStatic() || member.getMemberAccessModifier() != MemberAccessModifier.PUBLIC) {
            return false;
        }
        if (member instanceof TMethod) {
            switch (this.typingStrategy) {
                case DEFAULT: 
                case NOMINAL: {
                    return true;
                }
                case STRUCTURAL_FIELDS: 
                case STRUCTURAL_READ_ONLY_FIELDS: 
                case STRUCTURAL_WRITE_ONLY_FIELDS: 
                case STRUCTURAL_FIELD_INITIALIZER: {
                    return false;
                }
                case STRUCTURAL: {
                    return true;
                }
                case EMPTY: {
                    return false;
                }
            }
        }
        if (member instanceof TGetter) {
            switch (this.typingStrategy) {
                case DEFAULT: 
                case NOMINAL: 
                case STRUCTURAL: 
                case STRUCTURAL_FIELDS: 
                case STRUCTURAL_READ_ONLY_FIELDS: {
                    return true;
                }
                case STRUCTURAL_WRITE_ONLY_FIELDS: {
                    return false;
                }
                case STRUCTURAL_FIELD_INITIALIZER: {
                    ContainerType type = member.getContainingType();
                    NameAndAccess naa = new NameAndAccess(member.getName(), true, false);
                    Map members = type.getOwnedMembersByNameAndAccess();
                    boolean hasSetter = members.containsKey(naa);
                    return hasSetter;
                }
                case EMPTY: {
                    return false;
                }
            }
        }
        if (member instanceof TSetter) {
            switch (this.typingStrategy) {
                case DEFAULT: 
                case NOMINAL: 
                case STRUCTURAL: 
                case STRUCTURAL_FIELDS: 
                case STRUCTURAL_WRITE_ONLY_FIELDS: {
                    return true;
                }
                case STRUCTURAL_READ_ONLY_FIELDS: {
                    return false;
                }
                case STRUCTURAL_FIELD_INITIALIZER: {
                    return !this.isWriteAccess;
                }
                case EMPTY: {
                    return false;
                }
            }
        }
        if (member instanceof TField) {
            TField field = (TField)member;
            switch (this.typingStrategy) {
                case DEFAULT: 
                case NOMINAL: 
                case STRUCTURAL: 
                case STRUCTURAL_FIELDS: {
                    return true;
                }
                case STRUCTURAL_READ_ONLY_FIELDS: {
                    return !this.isWriteAccess;
                }
                case STRUCTURAL_WRITE_ONLY_FIELDS: {
                    return this.isWriteAccess;
                }
                case STRUCTURAL_FIELD_INITIALIZER: {
                    boolean isAccessable = !this.isWriteAccess && (!field.isFinal() || !field.isHasExpression() || this.inSpecCtor);
                    return isAccessable;
                }
                case EMPTY: {
                    return false;
                }
            }
        }
        return true;
    }
}

