/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FlowEdge;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalker;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorer;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitor;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.SetterDeclaration;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.ThrowStatement;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.EcoreUtil2;

public class MissingReturnOrThrowAnalyser
extends GraphVisitor {
    private final TypeSystemHelper typeSystemHelper;
    private final JavaScriptVariantHelper jsVariantHelper;
    Multimap<FunctionOrFieldAccessor, ControlFlowElement> missingTRAfter = HashMultimap.create();

    public MissingReturnOrThrowAnalyser(TypeSystemHelper typeSystemHelper, JavaScriptVariantHelper jsVariantHelper) {
        super(TraverseDirection.Backward);
        this.typeSystemHelper = typeSystemHelper;
        this.jsVariantHelper = jsVariantHelper;
    }

    protected void initializeContainer(ControlFlowElement curContainer) {
        FunctionOrFieldAccessor fofa;
        EObject parentContainer = curContainer.eContainer();
        if (parentContainer instanceof FunctionOrFieldAccessor && this.mrtCheckRequired(fofa = (FunctionOrFieldAccessor)parentContainer)) {
            if (this.hasStatementsInBody(fofa)) {
                this.requestActivation((GraphExplorerInternal)new MissingReturnGraphExplorer(fofa));
            } else {
                this.missingTRAfter.put((Object)fofa, null);
            }
        }
    }

    private boolean mrtCheckRequired(FunctionOrFieldAccessor fofa) {
        if (!this.jsVariantHelper.requireCheckFunctionReturn((EObject)fofa)) {
            return false;
        }
        if (fofa instanceof N4MethodDeclaration && ((N4MethodDeclaration)fofa).isConstructor()) {
            return false;
        }
        if (fofa instanceof FunctionDefinition && ((FunctionDefinition)fofa).isGenerator()) {
            return false;
        }
        if (fofa instanceof ArrowFunction && ((ArrowFunction)fofa).isSingleExprImplicitReturn()) {
            return false;
        }
        if (fofa instanceof SetterDeclaration) {
            return false;
        }
        if (fofa instanceof GetterDeclaration) {
            return true;
        }
        if (fofa.isReturnValueOptional()) {
            return false;
        }
        TypeRef returnType = this.typeSystemHelper.getExpectedTypeOfFunctionOrFieldAccessor(null, fofa);
        return returnType != null && !TypeUtils.isVoid((TypeArgument)returnType) && !TypeUtils.isUndefined((TypeArgument)returnType);
    }

    private boolean hasStatementsInBody(FunctionOrFieldAccessor fofa) {
        Block body = fofa.getBody();
        if (body == null) {
            return false;
        }
        return body.getAllStatements().hasNext();
    }

    public Collection<FunctionOrFieldAccessor> getMRTFunctions() {
        return this.missingTRAfter.keySet();
    }

    public Multimap<FunctionOrFieldAccessor, ControlFlowElement> getLastStatementsWithoutSuccReturnOrThrow() {
        return this.missingTRAfter;
    }

    class MissingReturnGraphExplorer
    extends GraphExplorer {
        final FunctionOrFieldAccessor fofa;

        MissingReturnGraphExplorer(FunctionOrFieldAccessor fofa) {
            this.fofa = fofa;
        }

        protected BranchWalker joinBranches(List<BranchWalker> branchWalkers) {
            return null;
        }

        protected BranchWalkerInternal firstBranchWalker() {
            return new MissingReturnBranchWalker();
        }

        class MissingReturnBranchWalker
        extends BranchWalker {
            MissingReturnBranchWalker() {
            }

            protected void visit(ControlFlowElement cfe) {
                this.deactivate();
                if (this.isDeadCodeBranch()) {
                    return;
                }
                Statement stmt = (Statement)EcoreUtil2.getContainerOfType((EObject)cfe, Statement.class);
                if (stmt instanceof ThrowStatement) {
                    return;
                }
                if (stmt instanceof ReturnStatement) {
                    return;
                }
                ((MissingReturnGraphExplorer)MissingReturnGraphExplorer.this).MissingReturnOrThrowAnalyser.this.missingTRAfter.put((Object)MissingReturnGraphExplorer.this.fofa, (Object)stmt);
            }

            protected void visit(FlowEdge edge) {
                for (ControlFlowType cfType : edge.cfTypes) {
                    boolean isReturnOrThrowEdge = false;
                    isReturnOrThrowEdge |= cfType == ControlFlowType.Return;
                    if (!(isReturnOrThrowEdge |= cfType == ControlFlowType.Throw)) continue;
                    this.deactivate();
                    return;
                }
            }

            protected void exitContainer(ControlFlowElement cfContainer) {
                ((MissingReturnGraphExplorer)MissingReturnGraphExplorer.this).MissingReturnOrThrowAnalyser.this.missingTRAfter.put((Object)MissingReturnGraphExplorer.this.fofa, (Object)cfContainer);
            }

            protected BranchWalker forkPath() {
                if (this.isDeadCodeBranch()) {
                    return null;
                }
                return new MissingReturnBranchWalker();
            }
        }
    }
}

