/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.proposals.imports;

import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class AliasLocation {
    private final int baseOffset;
    private final int relativeOffset;
    private final String alias;

    public AliasLocation(int baseOffset, int relativeOffset, String alias) {
        this.baseOffset = baseOffset;
        this.relativeOffset = relativeOffset;
        this.alias = alias;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.baseOffset;
        result = 31 * result + this.relativeOffset;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AliasLocation other = (AliasLocation)obj;
        if (other.baseOffset != this.baseOffset) {
            return false;
        }
        if (other.relativeOffset != this.relativeOffset) {
            return false;
        }
        return !(this.alias == null ? other.alias != null : !this.alias.equals(other.alias));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("baseOffset", (Object)this.baseOffset);
        b.add("relativeOffset", (Object)this.relativeOffset);
        b.add("alias", (Object)this.alias);
        return b.toString();
    }

    @Pure
    public int getBaseOffset() {
        return this.baseOffset;
    }

    @Pure
    public int getRelativeOffset() {
        return this.relativeOffset;
    }

    @Pure
    public String getAlias() {
        return this.alias;
    }
}

