/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalker;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorer;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitor;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public abstract class FastFlowVisitor
extends GraphVisitor {
    final InitialFastFlowBranch iffb = new InitialFastFlowBranch();
    private FFExplorer ffExplorer;

    protected abstract void visitNext(FastFlowBranch var1, ControlFlowElement var2);

    public Collection<ActivationLocation> getAllActivationLocations() {
        LinkedList<ActivationLocation> actLocs = new LinkedList<ActivationLocation>();
        for (GraphExplorerInternal expl : this.getActivatedExplorers()) {
            FFBranch lastFFB = (FFBranch)expl.allBranches.getLast();
            Collection<ActivationLocation> branchValues = lastFFB.actLocs.values();
            actLocs.addAll(branchValues);
        }
        return actLocs;
    }

    public FastFlowVisitor() {
        super(TraverseDirection.Backward);
    }

    @Override
    protected final void visit(ControlFlowElement cfe) {
        if (this.ffExplorer == null) {
            this.visitNext(this.iffb, cfe);
        }
    }

    @Override
    protected void terminateContainer(ControlFlowElement curContainer) {
        this.ffExplorer = null;
    }

    protected static abstract class ActivationLocation {
        private ControlFlowElement activationLocation;

        protected ActivationLocation() {
        }

        public abstract Object getKey();

        public ControlFlowElement getLocation() {
            return this.activationLocation;
        }
    }

    private class FFBranch
    extends BranchWalker
    implements FastFlowBranch {
        final Map<Object, ActivationLocation> actLocs = new HashMap<Object, ActivationLocation>();

        private FFBranch() {
        }

        @Override
        protected FFBranch forkPath() {
            FFBranch newBranch = new FFBranch();
            newBranch.actLocs.putAll(this.actLocs);
            return newBranch;
        }

        @Override
        protected void visit(ControlFlowElement cfe) {
            if (FastFlowVisitor.this.ffExplorer.skipFirstVisit) {
                FastFlowVisitor.this.ffExplorer.skipFirstVisit = false;
                this.actLocs.put(FastFlowVisitor.this.iffb.actLoc.getKey(), FastFlowVisitor.this.iffb.actLoc);
                return;
            }
            FastFlowVisitor.this.visitNext(this, cfe);
        }

        @Override
        public void activate(ActivationLocation activationLocation) {
            this.actLocs.put(activationLocation.getKey(), activationLocation);
        }

        @Override
        public ActivationLocation getActivationLocation(Object key) {
            return this.actLocs.get(key);
        }

        @Override
        public Collection<ActivationLocation> getAllActivationLocations() {
            return this.actLocs.values();
        }
    }

    private class FFExplorer
    extends GraphExplorer {
        private boolean skipFirstVisit = true;

        private FFExplorer() {
        }

        @Override
        protected BranchWalkerInternal firstBranchWalker() {
            return new FFBranch();
        }

        @Override
        protected BranchWalker joinBranches(List<BranchWalker> branchWalkers) {
            FFBranch joinedWalker = new FFBranch();
            for (BranchWalker bW : branchWalkers) {
                FFBranch cvbw = (FFBranch)bW;
                joinedWalker.actLocs.putAll(cvbw.actLocs);
            }
            return joinedWalker;
        }
    }

    protected static interface FastFlowBranch {
        public void activate(ActivationLocation var1);

        public ActivationLocation getActivationLocation(Object var1);

        public Collection<ActivationLocation> getAllActivationLocations();
    }

    class InitialFastFlowBranch
    implements FastFlowBranch {
        ActivationLocation actLoc;

        InitialFastFlowBranch() {
        }

        @Override
        public void activate(ActivationLocation activationLocation) {
            this.actLoc = activationLocation;
            FastFlowVisitor.this.ffExplorer = new FFExplorer();
            FastFlowVisitor.this.requestActivation(FastFlowVisitor.this.ffExplorer);
        }

        @Override
        public ActivationLocation getActivationLocation(Object key) {
            return null;
        }

        @Override
        public Collection<ActivationLocation> getAllActivationLocations() {
            return Collections.emptyList();
        }
    }
}

