/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.ui.search;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.n4js.ts.ui.search.ReferenceFinderLabelProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceQueryExecutor;

public class LabellingReferenceQueryExecutor
extends ReferenceQueryExecutor {
    @Inject
    private ReferenceFinderLabelProvider labelProvider;

    protected String getLabelPrefix() {
        return "References to ";
    }

    protected String getElementName(EObject primaryTarget) {
        if (primaryTarget.eResource() != null) {
            return this.labelProvider.getText(primaryTarget);
        }
        return null;
    }

    protected String getResourceName(EObject primaryTarget) {
        Resource resource = primaryTarget.eResource();
        if (resource == null) {
            return null;
        }
        if (N4Scheme.isResourceWithN4Scheme((Resource)resource)) {
            return resource.getURI().lastSegment();
        }
        return super.getResourceName(primaryTarget);
    }

    protected Predicate<IReferenceDescription> getFilter(EObject primaryTarget) {
        return new Predicate<IReferenceDescription>(){

            public boolean apply(IReferenceDescription input) {
                return LabellingReferenceQueryExecutor.this.isRelevantToUser(input);
            }
        };
    }

    protected boolean isRelevantToUser(IReferenceDescription input) {
        EReference reference = input.getEReference();
        boolean result = this.isRelevantToUser(reference);
        return result;
    }

    protected boolean isRelevantToUser(EReference reference) {
        return true;
    }
}

