/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.dialog;

import com.google.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.ListDialog;

public class SourceFolderSelectionDialog
extends ListDialog {
    @Inject
    private IN4JSCore n4jsCore;

    public SourceFolderSelectionDialog() {
        super(UIUtils.getShell());
        this.setLabelProvider((ILabelProvider)new SourceFolderLabelProvider());
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.setHelpAvailable(false);
    }

    public void setInput(Object input) {
        if (!(input instanceof IProject)) {
            throw new IllegalArgumentException("Only inputs of type IProject are allowed");
        }
        this.setTitle("Select a source folder in the project " + ((IProject)input).getName());
        List<String> sourceFolders = this.collectSourceFolders((IProject)input);
        super.setInput((Object)sourceFolders.toArray());
    }

    private List<String> collectSourceFolders(IProject project) {
        if (project == null) {
            return null;
        }
        URI uri = URI.createPlatformResourceURI((String)project.getName(), (boolean)true);
        IN4JSProject n4Project = (IN4JSProject)this.n4jsCore.findProject(uri).orNull();
        if (n4Project == null) {
            return null;
        }
        return n4Project.getSourceContainers().stream().filter(src -> src.isTest() || src.isSource()).map(src -> src.getRelativeLocation()).collect(Collectors.toList());
    }

    public String getFirstResult() {
        Object[] results = this.getResult();
        if (results != null && results.length > 0) {
            return (String)results[0];
        }
        return null;
    }

    private static class SourceFolderLabelProvider
    extends LabelProvider {
        private final Image sourceFolderImage = (Image)ImageDescriptorCache.ImageRef.SRC_FOLDER.asImage().orNull();

        private SourceFolderLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.sourceFolderImage;
        }
    }
}

