/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.documentation.N4JSDocumentationProvider;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.ts.services.TypeExpressionsGrammarAccess;
import org.eclipse.n4js.ui.organize.imports.InsertionPoint;
import org.eclipse.n4js.ui.organize.imports.XtextResourceUtils;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;
import org.eclipse.xtext.nodemodel.impl.LeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ImportsRegionHelper {
    @Inject
    private N4JSDocumentationProvider documentationProvider;
    @Inject
    private TypeExpressionsGrammarAccess typeExpressionGrammmarAccess;

    public int getImportOffset(XtextResource resource) {
        return this.getImportRegion((XtextResource)resource).offset;
    }

    public int getImportOffset(Script script) {
        return this.getImportRegion((Script)script).offset;
    }

    InsertionPoint getImportRegion(XtextResource xtextResource) {
        return this.getImportRegion(XtextResourceUtils.getScript(xtextResource));
    }

    InsertionPoint getImportRegion(Script script) {
        InsertionPoint insertionPoint = new InsertionPoint();
        int begin = -1;
        if (script != null) {
            boolean _not;
            begin = 0;
            List scriptAnnos = NodeModelUtils.findNodesForFeature((EObject)script, (EStructuralFeature)N4JSPackage.Literals.SCRIPT__ANNOTATIONS);
            boolean _isEmpty = scriptAnnos.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                int _size = scriptAnnos.size();
                int _minus = _size - 1;
                INode lastAnno = (INode)scriptAnnos.get(_minus);
                insertionPoint.notBeforeTotalOffset = begin = lastAnno.getTotalEndOffset();
            }
            EList elements = script.getScriptElements();
            int lastSeenDirective = -1;
            int idxNondirectiveStatemnt = -1;
            int i = 0;
            while (i < elements.size() && idxNondirectiveStatemnt == -1) {
                ScriptElement curr = (ScriptElement)elements.get(i);
                boolean _isStringLiteralExpression = N4JSASTUtils.isStringLiteralExpression((ScriptElement)curr);
                if (_isStringLiteralExpression) {
                    lastSeenDirective = i;
                } else if (!(curr instanceof ImportDeclaration)) {
                    idxNondirectiveStatemnt = i;
                }
                ++i;
            }
            if (idxNondirectiveStatemnt != -1) {
                boolean _not_1;
                ScriptElement realScriptElement = (ScriptElement)elements.get(idxNondirectiveStatemnt);
                ICompositeNode realScriptElementNode = NodeModelUtils.findActualNodeFor((EObject)realScriptElement);
                List docuNodes = this.documentationProvider.getDocumentationNodes((EObject)realScriptElement);
                boolean _isEmpty_1 = docuNodes.isEmpty();
                boolean bl2 = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    INode docuNode;
                    INode previousNode = docuNode = (INode)docuNodes.get(0);
                    INode lastEOL = null;
                    boolean continue_ = true;
                    while (continue_ && previousNode.hasPreviousSibling() && previousNode.getPreviousSibling() instanceof HiddenLeafNode) {
                        TerminalRule _wSRule;
                        EObject grammar = previousNode.getPreviousSibling().getGrammarElement();
                        boolean _equals = Objects.equal((Object)grammar, (Object)(_wSRule = this.typeExpressionGrammmarAccess.getWSRule()));
                        if (_equals) {
                            previousNode = previousNode.getPreviousSibling();
                            continue;
                        }
                        TerminalRule _eOLRule = this.typeExpressionGrammmarAccess.getEOLRule();
                        boolean _equals_1 = Objects.equal((Object)grammar, (Object)_eOLRule);
                        if (_equals_1) {
                            lastEOL = previousNode = previousNode.getPreviousSibling();
                            continue;
                        }
                        continue_ = false;
                    }
                    int _xifexpression = 0;
                    _xifexpression = lastEOL != null ? lastEOL.getEndOffset() : docuNode.getTotalOffset();
                    begin = _xifexpression;
                    insertionPoint.isBeforeJsdocDocumentation = true;
                } else {
                    List listLeafNodes = IterableExtensions.toList((Iterable)realScriptElementNode.getLeafNodes());
                    Iterator iterLeaves = listLeafNodes.iterator();
                    ILeafNode curr = null;
                    ILeafNode firstEOL = null;
                    ILeafNode afterFirstEOL = null;
                    boolean sawComment = false;
                    ILeafNode lastComment = null;
                    while (iterLeaves.hasNext() && (curr = (ILeafNode)iterLeaves.next()).isHidden()) {
                        TerminalRule _wSRule;
                        TerminalRule _eOLRule;
                        TerminalRule _sL_COMMENTRule;
                        TerminalRule _mL_COMMENTRule;
                        EObject _grammarElement = curr.getGrammarElement();
                        if (!(_grammarElement instanceof TerminalRule)) continue;
                        EObject _grammarElement_1 = curr.getGrammarElement();
                        boolean _equals = Objects.equal((Object)_grammarElement_1, (Object)(_mL_COMMENTRule = this.typeExpressionGrammmarAccess.getML_COMMENTRule()));
                        if (_equals) {
                            firstEOL = null;
                            afterFirstEOL = null;
                            sawComment = true;
                            lastComment = curr;
                            continue;
                        }
                        EObject _grammarElement_2 = curr.getGrammarElement();
                        boolean _equals_1 = Objects.equal((Object)_grammarElement_2, (Object)(_sL_COMMENTRule = this.typeExpressionGrammmarAccess.getSL_COMMENTRule()));
                        if (_equals_1) {
                            firstEOL = null;
                            afterFirstEOL = null;
                            sawComment = true;
                            lastComment = curr;
                            continue;
                        }
                        EObject _grammarElement_3 = curr.getGrammarElement();
                        boolean _equals_2 = Objects.equal((Object)_grammarElement_3, (Object)(_eOLRule = this.typeExpressionGrammmarAccess.getEOLRule()));
                        if (_equals_2) {
                            if (firstEOL == null) {
                                firstEOL = curr;
                                continue;
                            }
                            if (afterFirstEOL != null) continue;
                            afterFirstEOL = curr;
                            continue;
                        }
                        EObject _grammarElement_4 = curr.getGrammarElement();
                        boolean _equals_3 = Objects.equal((Object)_grammarElement_4, (Object)(_wSRule = this.typeExpressionGrammmarAccess.getWSRule()));
                        if (_equals_3) {
                            if (firstEOL == null || afterFirstEOL != null) continue;
                            afterFirstEOL = curr;
                            continue;
                        }
                        firstEOL = null;
                        afterFirstEOL = null;
                    }
                    if (curr == null || curr.isHidden()) {
                        throw new RuntimeException("Expected at least one non-hidden element.");
                    }
                    insertionPoint.notAfterTotalOffset = curr.getTotalOffset();
                    int _xifexpression_1 = 0;
                    if (afterFirstEOL != null && sawComment) {
                        _xifexpression_1 = afterFirstEOL.getTotalOffset();
                    } else {
                        int _xifexpression_2 = 0;
                        boolean _hasNoCommentUpTo = this.hasNoCommentUpTo(curr);
                        if (_hasNoCommentUpTo) {
                            _xifexpression_2 = 0;
                        } else {
                            int _xifexpression_3 = 0;
                            _xifexpression_3 = sawComment ? lastComment.getEndOffset() : ((ILeafNode)IterableExtensions.head((Iterable)listLeafNodes)).getTotalOffset();
                            _xifexpression_2 = _xifexpression_3;
                        }
                        _xifexpression_1 = _xifexpression_2;
                    }
                    int begin2 = _xifexpression_1;
                    begin = Math.max(begin, begin2);
                    if (lastSeenDirective > -1) {
                        ICompositeNode lastDirectiveNode = NodeModelUtils.findActualNodeFor((EObject)((EObject)elements.get(lastSeenDirective)));
                        int lastDirectiveEndOffset = lastDirectiveNode.getTotalEndOffset();
                        insertionPoint.notBeforeTotalOffset = Math.max(lastDirectiveEndOffset, insertionPoint.notBeforeTotalOffset);
                        begin = Math.max(begin, lastDirectiveEndOffset);
                    }
                }
            } else if (lastSeenDirective > -1) {
                ICompositeNode lastDirectiveNode_1 = NodeModelUtils.findActualNodeFor((EObject)((EObject)elements.get(lastSeenDirective)));
                begin = lastDirectiveNode_1.getTotalEndOffset();
                insertionPoint.notBeforeTotalOffset = Math.max(begin, insertionPoint.notBeforeTotalOffset);
            }
            insertionPoint.offset = begin;
        }
        return insertionPoint;
    }

    private boolean hasNoCommentUpTo(ILeafNode node) {
        if (node == null) {
            return true;
        }
        for (INode curr : node.getRootNode().getAsTreeIterable()) {
            boolean _not;
            boolean _equals = Objects.equal((Object)curr, (Object)node);
            if (_equals) {
                return true;
            }
            if (!(curr instanceof LeafNode) || !((LeafNode)curr).isHidden() && !UtilN4.isIgnoredSyntaxErrorNode((INode)curr, (String[])new String[]{"InternalSemicolonInjectingParser.ASI"})) continue;
            boolean _isEmpty = ((LeafNode)curr).getText().trim().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            return false;
        }
        throw new IllegalStateException("Iteration over-stepped the passed in node.");
    }
}

