/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences;

import com.google.common.collect.MapDifference;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.n4js.generator.CompilerDescriptor;
import org.eclipse.n4js.generator.CompilerProperties;
import org.eclipse.n4js.generator.ICompositeGenerator;
import org.eclipse.n4js.ui.preferences.AbstractN4JSPreferencePage;
import org.eclipse.n4js.ui.preferences.N4JSPreferenceStoreAccessor;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.xtext.builder.DerivedResourceCleanerJob;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.preferences.Messages;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

public class N4JSBuilderPreferencePage
extends AbstractN4JSPreferencePage<CompilerDescriptor> {
    EclipseOutputConfigurationProvider configurationProvider;
    private Provider<DerivedResourceCleanerJob> cleanerProvider;
    @Inject
    private N4JSPreferenceStoreAccessor preferenceStoreAccessor;
    int rebuildCount = -1;

    @Inject
    public N4JSBuilderPreferencePage(ICompositeGenerator compositeGenerator) {
        super(new ArrayList());
        for (CompilerDescriptor compilerDescriptor : compositeGenerator.getCompilerDescriptors()) {
            this.components.add(Tuples.create((Object)compilerDescriptor.getIdentifier(), (Object)compilerDescriptor.getName(), (Object)compilerDescriptor));
        }
    }

    protected CompilerProperties[] getComponentPropertiesValues() {
        CompilerProperties[] values = CompilerProperties.values();
        return values;
    }

    @Inject
    public void setConfigurationProvider(EclipseOutputConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        this.rebuildCount = this.getRebuildCount();
    }

    @Inject
    public void setCleanerProvider(Provider<DerivedResourceCleanerJob> cleanerProvider) {
        this.cleanerProvider = cleanerProvider;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = Messages.BuilderConfigurationBlock_SettingsChanged_Title;
        String message = workspaceSettings ? Messages.BuilderConfigurationBlock_SettingsChanged_WorkspaceBuild : Messages.BuilderConfigurationBlock_SettingsChanged_ProjectBuild;
        return new String[]{title, message};
    }

    int getRebuildCount() {
        return this.getPreferenceStore().getDefaultInt("preferences_build_requested");
    }

    void incrementRebuildCount() {
        this.getPreferenceStore().setDefault("preferences_build_requested", this.getRebuildCount() + 1);
    }

    protected Job getBuildJob(IProject projectToBuild) {
        OptionsConfigurationBlock.BuildJob buildJob = new OptionsConfigurationBlock.BuildJob(Messages.BuilderConfigurationBlock_BuildJob_Title0, projectToBuild);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    private void scheduleCleanerJobIfNecessary(IPreferencePageContainer preferencePageContainer) {
        Map<String, MapDifference.ValueDifference<String>> changes = this.getPreferenceChanges();
        for (String key : changes.keySet()) {
            if (!key.matches("^outlet\\.\\w+\\.outlet$")) continue;
            MapDifference.ValueDifference<String> difference = changes.get(key);
            this.scheduleCleanerJob(preferencePageContainer, (String)difference.rightValue());
        }
    }

    private void scheduleCleanerJob(IPreferencePageContainer preferencePageContainer, String folderNameToClean) {
        DerivedResourceCleanerJob derivedResourceCleanerJob = (DerivedResourceCleanerJob)this.cleanerProvider.get();
        derivedResourceCleanerJob.setUser(true);
        derivedResourceCleanerJob.initialize(this.getProject(), folderNameToClean);
        if (preferencePageContainer != null) {
            IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
            container.registerUpdateJob((Job)derivedResourceCleanerJob);
        } else {
            derivedResourceCleanerJob.schedule();
        }
    }

    @Override
    protected void refreshAttributes() {
        Collections.sort(this.components, this);
        Set outputConfigs = this.configurationProvider.getOutputConfigurations(this.getProject());
        for (Triple compiler : this.components) {
            for (OutputConfiguration outputConfiguration : outputConfigs) {
                if (!outputConfiguration.getName().equals(compiler.getFirst()) || ((CompilerDescriptor)compiler.getThird()).getOutputConfiguration() != null) continue;
                ((CompilerDescriptor)compiler.getThird()).setOutputConfiguration(outputConfiguration);
            }
        }
        for (Triple compiler : this.components) {
            this.preferenceStoreAccessor.populateCompilerConfiguration((String)compiler.getFirst(), (CompilerDescriptor)compiler.getThird());
        }
    }

    @Override
    public boolean performOk() {
        this.scheduleCleanerJobIfNecessary(this.getContainer());
        return super.performOk();
    }

    @Override
    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        String[] strings;
        int count;
        boolean needsBuild = !this.getPreferenceChanges().isEmpty() | this.projectSpecificChanged;
        boolean doBuild = false;
        if (needsBuild && (count = this.getRebuildCount()) > this.rebuildCount) {
            needsBuild = false;
            this.rebuildCount = count;
        }
        if (needsBuild && (strings = this.getFullBuildDialogStrings(this.project == null)) != null) {
            MessageDialog dialog = new MessageDialog(this.getShell(), strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int res = dialog.open();
            if (res == 0) {
                doBuild = true;
            } else if (res != 1) {
                return false;
            }
        }
        if (container != null) {
            if (doBuild) {
                this.incrementRebuildCount();
                container.registerUpdateJob(this.getBuildJob(this.getProject()));
            }
        } else if (doBuild) {
            this.getBuildJob(this.getProject()).schedule();
        }
        return true;
    }
}

