/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.resource.N4JSExternalReferenceChecker;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtext.util.IAcceptor;

public class N4JSCrossReferenceComputer {
    @Inject
    private N4JSExternalReferenceChecker externalReferenceChecker;

    public void computeCrossRefs(Resource resource, IAcceptor<EObject> acceptor) {
        TreeIterator allASTContentsIter;
        if (resource instanceof N4JSResource) {
            Script script = ((N4JSResource)resource).getScript();
            allASTContentsIter = script.eAllContents();
        } else {
            allASTContentsIter = resource.getAllContents();
        }
        while (allASTContentsIter.hasNext()) {
            EObject eObject = (EObject)allASTContentsIter.next();
            this.computeCrossRefs(resource, eObject, acceptor);
        }
    }

    private void computeCrossRefs(Resource resource, EObject from, IAcceptor<EObject> acceptor) {
        EList references = from.eClass().getEAllReferences();
        for (EReference eReference : references) {
            if (eReference.isContainment() || eReference.isContainer() || eReference == N4JSPackage.Literals.TYPE_DEFINING_ELEMENT__DEFINED_TYPE || eReference == TypesPackage.Literals.SYNTAX_RELATED_TELEMENT__AST_ELEMENT || !from.eIsSet((EStructuralFeature)eReference)) continue;
            Object val = from.eGet((EStructuralFeature)eReference);
            if (!eReference.isMany()) {
                EObject to = (EObject)val;
                this.handleReferenceObject(resource, acceptor, to);
                continue;
            }
            BasicEList list = (BasicEList)val;
            if (TypesPackage.Literals.TYPE.isSuperTypeOf(eReference.getEReferenceType())) {
                for (EObject to : list) {
                    this.handleType(resource, acceptor, (Type)to);
                }
                continue;
            }
            if (TypesPackage.Literals.IDENTIFIABLE_ELEMENT.isSuperTypeOf(eReference.getEReferenceType())) {
                for (EObject to : list) {
                    this.handleIdentifiableElement(resource, acceptor, (IdentifiableElement)to);
                }
                continue;
            }
            for (EObject to : list) {
                this.handleReferenceObject(resource, acceptor, to);
            }
        }
    }

    private void handleReferenceObject(Resource resource, IAcceptor<EObject> acceptor, EObject to) {
        if (to instanceof Type) {
            this.handleType(resource, acceptor, (Type)to);
        } else if (to instanceof TMember) {
            this.handleTMember(resource, acceptor, (TMember)to);
        } else if (to instanceof IdentifiableElement) {
            this.handleIdentifiableElement(resource, acceptor, (IdentifiableElement)to);
        }
    }

    private void handleTMember(Resource resource, IAcceptor<EObject> acceptor, TMember to) {
        if (to.isComposed()) {
            for (TMember constituentMember : to.getConstituentMembers()) {
                this.handleIdentifiableElement(resource, acceptor, (IdentifiableElement)constituentMember);
            }
        } else {
            this.handleIdentifiableElement(resource, acceptor, (IdentifiableElement)to);
        }
    }

    private void handleType(Resource resource, IAcceptor<EObject> acceptor, Type to) {
        if (to != null && this.isLocatedInOtherResource(resource, (EObject)to)) {
            acceptor.accept((Object)to);
        }
    }

    private void handleIdentifiableElement(Resource resource, IAcceptor<EObject> acceptor, IdentifiableElement to) {
        if (to != null && this.isLocatedInOtherResource(resource, (EObject)to)) {
            acceptor.accept((Object)to);
        }
    }

    private boolean isLocatedInOtherResource(Resource resource, EObject eobj) {
        if (eobj == null || eobj.eResource() == null) {
            return false;
        }
        boolean ret = !N4Scheme.isFromResourceWithN4Scheme((EObject)eobj) && this.externalReferenceChecker.isResolvedAndExternal(resource, eobj);
        return ret;
    }
}

