/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.inject.Inject;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.OutdatedStateManager;
import org.eclipse.xtext.util.CancelIndicator;

public class PostProcessingAwareResource
extends DerivedStateAwareResource {
    @Inject(optional=true)
    private PostProcessor postProcessor;
    @Inject
    private OutdatedStateManager outdatedStateManager;
    protected volatile boolean fullyPostProcessed = false;
    protected volatile boolean isPostProcessing = false;
    private Throwable postProcessingThrowable;

    public boolean isFullyProcessed() {
        return this.fullyPostProcessed;
    }

    public boolean isPostProcessing() {
        return this.isPostProcessing;
    }

    public Throwable getPostProcessingThrowable() {
        return this.isFullyProcessed() ? this.postProcessingThrowable : null;
    }

    public void discardDerivedState() {
        this.discardPostProcessingResult();
        super.discardDerivedState();
    }

    protected void doUnload() {
        this.discardPostProcessingResult();
        super.doUnload();
    }

    public void resolveLazyCrossReferences(CancelIndicator cancelIndicator) {
        this.performPostProcessing(cancelIndicator);
    }

    public void performPostProcessing() {
        this.performPostProcessing(null);
    }

    public void performPostProcessing(CancelIndicator cancelIndicator) {
        if (this.fullyPostProcessed) {
            return;
        }
        if (!this.isLoaded) {
            throw new IllegalStateException("The resource must be loaded, before PostProcessedResource#performPostProcessing() can be called.");
        }
        if (!this.fullyInitialized) {
            this.installDerivedState(false);
        }
        if (this.isLoaded && this.fullyInitialized && !this.fullyPostProcessed && !this.isPostProcessing) {
            try {
                try {
                    this.postProcessingThrowable = null;
                    this.isPostProcessing = true;
                    if (this.postProcessor == null) {
                        throw new IllegalStateException("post processor is null");
                    }
                    if (cancelIndicator == null) {
                        cancelIndicator = this.outdatedStateManager.newCancelIndicator(this.getResourceSet());
                    }
                    if (this.postProcessor.expectsLazyLinkResolution()) {
                        super.resolveLazyCrossReferences(cancelIndicator);
                    }
                    this.postProcessor.performPostProcessing(this, cancelIndicator);
                }
                catch (Throwable th) {
                    this.postProcessingThrowable = th;
                    throw th;
                }
            }
            finally {
                this.isPostProcessing = false;
                this.fullyPostProcessed = true;
            }
        }
    }

    public void discardPostProcessingResult() {
        if (this.fullyPostProcessed) {
            try {
                this.postProcessor.discardPostProcessingResult(this);
            }
            finally {
                this.fullyPostProcessed = false;
            }
        }
    }

    public static interface PostProcessor {
        default public boolean expectsLazyLinkResolution() {
            return true;
        }

        public void performPostProcessing(PostProcessingAwareResource var1, CancelIndicator var2);

        public void discardPostProcessingResult(PostProcessingAwareResource var1);
    }
}

