/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.scoping.members.AbstractMemberScope;
import org.eclipse.n4js.scoping.utils.RestrictedUsageDescription;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.NameAndAccess;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.VirtualBaseType;
import org.eclipse.n4js.ts.types.internal.MemberByNameAndAccessMap;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class MemberScope
extends AbstractMemberScope {
    final ContainerType<?> type;
    final List<TMember> members;
    MemberByNameAndAccessMap membersByNameAndAccess;
    final ContainerTypesHelper containerTypesHelper;

    MemberScope(ContainerTypesHelper containerTypesHelper, IScope parent, List<? extends TMember> members, EObject context, boolean staticAccess, boolean structFieldInitMode, JavaScriptVariantHelper jsVariantHelper) {
        super(parent, context, staticAccess, structFieldInitMode, jsVariantHelper);
        this.containerTypesHelper = containerTypesHelper;
        this.type = null;
        this.members = new ArrayList<TMember>(members);
    }

    MemberScope(ContainerTypesHelper containerTypesHelper, IScope parent, ContainerType<?> type, EObject context, boolean staticAccess, boolean structFieldInitMode, JavaScriptVariantHelper jsVariantHelper) {
        super(parent, context, staticAccess, structFieldInitMode, jsVariantHelper);
        this.containerTypesHelper = containerTypesHelper;
        this.type = type;
        this.members = null;
    }

    MemberScope(ContainerTypesHelper containerTypesHelper, ContainerType<?> type, EObject context, boolean staticAccess, boolean structFieldInitMode, JavaScriptVariantHelper jsVariantHelper) {
        super(IScope.NULLSCOPE, context, staticAccess, structFieldInitMode, jsVariantHelper);
        this.containerTypesHelper = containerTypesHelper;
        this.type = type;
        this.members = null;
    }

    @Override
    protected TMember findMember(String name, boolean writeAccess, boolean staticAccess) {
        if (this.type != null) {
            return this.containerTypesHelper.fromContext(this.contextResource).findMember(this.type, name, writeAccess, staticAccess);
        }
        if (this.membersByNameAndAccess == null) {
            this.membersByNameAndAccess = new MemberByNameAndAccessMap(this.members);
        }
        NameAndAccess nameAndAccess = new NameAndAccess(name, writeAccess, staticAccess);
        return this.membersByNameAndAccess.get((Object)nameAndAccess);
    }

    @Override
    protected Collection<? extends TMember> getMembers() {
        if (this.type != null) {
            return this.containerTypesHelper.fromContext(this.contextResource).members(this.type);
        }
        return this.members;
    }

    @Override
    protected IEObjectDescription createSingleElementDescription(TMember existingMember) {
        IEObjectDescription description = super.createSingleElementDescription(existingMember);
        if (this.type instanceof VirtualBaseType && this.type.getName().equals("ArgumentsType") && existingMember.getName().equals("callee") && !this.jsVariantHelper.isUnrestrictedMode(this.context)) {
            return new RestrictedUsageDescription(description, this.jsVariantHelper.variantMode(this.context));
        }
        return description;
    }

    public static class MemberScopeFactory {
        @Inject
        ContainerTypesHelper containerTypesHelper;
        @Inject
        JavaScriptVariantHelper jsVariantHelper;

        public IScope create(IScope parent, ContainerType<?> type, EObject context, boolean staticAccess, boolean structFieldInitMode) {
            return new MemberScope(this.containerTypesHelper, parent, type, context, staticAccess, structFieldInitMode, this.jsVariantHelper);
        }

        public IScope create(ContainerType<?> type, EObject context, boolean staticAccess, boolean structFieldInitMode) {
            return new MemberScope(this.containerTypesHelper, type, context, staticAccess, structFieldInitMode, this.jsVariantHelper);
        }

        public IScope create(IScope parent, List<? extends TMember> members, EObject context, boolean staticAccess, boolean structFieldInitMode) {
            return new MemberScope(this.containerTypesHelper, parent, members, context, staticAccess, structFieldInitMode, this.jsVariantHelper);
        }
    }
}

