/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.internal.FileBasedExternalPackageManager;
import org.eclipse.n4js.ui.external.ExternalLibraryBuildScheduler;
import org.eclipse.n4js.ui.external.ExternalProjectProvider;
import org.eclipse.n4js.utils.URIUtils;

public class ProjectStateChangeListener
implements IResourceChangeListener {
    private static final Logger logger = Logger.getLogger(ProjectStateChangeListener.class);
    @Inject
    private ExternalProjectProvider projectProvider;
    @Inject
    private ExternalLibraryBuildScheduler buildJobProvider;
    @Inject
    private FileBasedExternalPackageManager packageManager;
    private final Collection<N4JSExternalProject> toClean = Sets.newLinkedHashSet();
    private final Collection<N4JSExternalProject> toBuild = Sets.newLinkedHashSet();

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null || event.getDelta() == null) {
            return;
        }
        try {
            this.toClean.clear();
            this.toBuild.clear();
            event.getDelta().accept(this::visit);
            if (!this.toClean.isEmpty() || !this.toBuild.isEmpty()) {
                logger.info((Object)"Received project open/close change.");
                logger.info((Object)("Opened projects: " + Iterables.toString((Iterable)FluentIterable.from(this.toClean).transform(p -> p.getName()))));
                logger.info((Object)("Closed projects: " + Iterables.toString((Iterable)FluentIterable.from(this.toBuild).transform(p -> p.getName()))));
                this.buildJobProvider.scheduleBuildJob(this.toBuild, this.toClean);
            }
        }
        catch (CoreException e) {
            logger.error((Object)"Error while visiting resource change event.", (Throwable)e);
        }
    }

    boolean visit(IResourceDelta delta) {
        URI uri;
        boolean isN4Project;
        IProject project;
        String name;
        N4JSExternalProject externalProject;
        IResource resource = delta.getResource();
        if (resource instanceof IProject && (externalProject = this.projectProvider.getProject(name = (project = (IProject)resource).getName())) != null && externalProject.exists() && (isN4Project = this.packageManager.isN4ProjectRoot(uri = URIUtils.convert((IResource)externalProject)))) {
            if (4 == delta.getKind() && (delta.getFlags() & 0x4000) != 0) {
                if (project.isOpen()) {
                    this.toClean.add(externalProject);
                } else {
                    this.toBuild.add(externalProject);
                }
            } else if (2 == delta.getKind()) {
                this.toBuild.add(externalProject);
            } else if (1 == delta.getKind()) {
                this.toClean.add(externalProject);
            }
        }
        return true;
    }
}

