/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import com.google.inject.Inject;
import java.util.function.BiFunction;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.n4js.n4JS.DefaultImportSpecifier;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4JSFactory;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.scoping.utils.ImportSpecifierUtil;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ui.organize.imports.ImportableObject;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

public class ImportsFactory {
    private static final N4JSFactory N4JS_FACTORY = N4JSFactory.eINSTANCE;
    private static final TypesFactory TYPES_FACTORY = TypesFactory.eINSTANCE;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IN4JSCore core;

    public ImportDeclaration createImport(ImportableObject imp, IN4JSProject contextProject, Adapter nodelessMarker) {
        if (imp.isAsNamespace()) {
            return this.createNamespaceImport(imp.getName(), contextProject, imp.getTe(), nodelessMarker);
        }
        if (imp.isExportedAsDefault()) {
            return this.createDefaultImport(imp.getName(), contextProject, imp.getTe(), nodelessMarker);
        }
        return this.createNamedImport(imp.getName(), contextProject, imp.getTe(), nodelessMarker);
    }

    private ImportDeclaration createNamedImport(String name, IN4JSProject contextProject, TExportableElement te, Adapter nodelessMarker) {
        TModule tmodule = te.getContainingModule();
        IN4JSProject targetProject = (IN4JSProject)this.core.findProject(te.eResource().getURI()).orNull();
        String moduleQN = targetProject != null && tmodule.getQualifiedName().toString().equals(targetProject.getMainModule()) ? targetProject.getProjectName() : te.getContainingModule().getQualifiedName();
        QualifiedName qn = this.qualifiedNameConverter.toQualifiedName(moduleQN);
        String firstSegment = qn.getFirstSegment();
        IN4JSProject project = ImportSpecifierUtil.getDependencyWithID((String)firstSegment, (IN4JSProject)contextProject);
        return this.createImportDeclaration(qn, name, project, nodelessMarker, this::addNamedImport);
    }

    private ImportDeclaration createDefaultImport(String name, IN4JSProject contextProject, TExportableElement te, Adapter nodelessMarker) {
        String moduleQN = te.getContainingModule().getQualifiedName();
        QualifiedName qn = this.qualifiedNameConverter.toQualifiedName(moduleQN);
        String firstSegment = qn.getFirstSegment();
        IN4JSProject project = ImportSpecifierUtil.getDependencyWithID((String)firstSegment, (IN4JSProject)contextProject);
        return this.createImportDeclaration(qn, name, project, nodelessMarker, this::addDefaultImport);
    }

    private ImportDeclaration createNamespaceImport(String name, IN4JSProject contextProject, TExportableElement te, Adapter nodelessMarker) {
        String moduleQN = te.getContainingModule().getQualifiedName();
        QualifiedName qn = this.qualifiedNameConverter.toQualifiedName(moduleQN);
        String firstSegment = qn.getFirstSegment();
        IN4JSProject project = ImportSpecifierUtil.getDependencyWithID((String)firstSegment, (IN4JSProject)contextProject);
        if (project == null) {
            IN4JSProject projectByNamespace = ImportSpecifierUtil.getDependencyWithID((String)name, (IN4JSProject)contextProject);
            IN4JSProject projectByEObject = (IN4JSProject)this.core.findProject(te.eResource().getURI()).orNull();
            if (projectByNamespace != null && projectByEObject != null && projectByNamespace.getLocation() == projectByEObject.getLocation()) {
                project = projectByNamespace;
            }
        }
        return this.createImportDeclaration(qn, name, project, nodelessMarker, this::addNamespaceImport);
    }

    private ImportDeclaration createImportDeclaration(QualifiedName qn, String usedName, IN4JSProject fromProject, Adapter nodelessMarker, BiFunction<String, ImportDeclaration, ImportDeclaration> specifierFactory) {
        boolean considerProjectName = fromProject != null;
        switch (ImportSpecifierUtil.computeImportType((QualifiedName)qn, (boolean)considerProjectName, (IN4JSProject)fromProject)) {
            case PROJECT_IMPORT: {
                return specifierFactory.apply(usedName, this.createImportDeclaration(nodelessMarker, fromProject.getProjectName()));
            }
            case SIMPLE_IMPORT: {
                return specifierFactory.apply(usedName, this.createImportDeclaration(nodelessMarker, this.qualifiedNameConverter.toString(qn)));
            }
            case COMPLETE_IMPORT: {
                return specifierFactory.apply(usedName, this.createImportDeclaration(nodelessMarker, String.valueOf(fromProject.getProjectName()) + "/" + this.qualifiedNameConverter.toString(qn)));
            }
        }
        throw new RuntimeException("Cannot resolve default import for " + usedName);
    }

    private ImportDeclaration createImportDeclaration(Adapter nodelessMarker, String moduleName) {
        ImportDeclaration ret = N4JS_FACTORY.createImportDeclaration();
        TModule tmodule = TYPES_FACTORY.createTModule();
        tmodule.setQualifiedName(moduleName);
        ret.setModule(tmodule);
        ret.eAdapters().add((Object)nodelessMarker);
        return ret;
    }

    private ImportDeclaration addNamedImport(String name, ImportDeclaration importDeclaration) {
        NamedImportSpecifier namedImportSpec = N4JS_FACTORY.createNamedImportSpecifier();
        TExportableElement importetElement = TYPES_FACTORY.createTExportableElement();
        importetElement.setName(name);
        namedImportSpec.setImportedElement(importetElement);
        importDeclaration.getImportSpecifiers().add((Object)namedImportSpec);
        return importDeclaration;
    }

    private ImportDeclaration addDefaultImport(String name, ImportDeclaration importDeclaration) {
        DefaultImportSpecifier defaultImportSpec = N4JS_FACTORY.createDefaultImportSpecifier();
        TExportableElement importetElement = TYPES_FACTORY.createTExportableElement();
        importetElement.setName(name);
        defaultImportSpec.setImportedElement(importetElement);
        importDeclaration.getImportSpecifiers().add((Object)defaultImportSpec);
        return importDeclaration;
    }

    private ImportDeclaration addNamespaceImport(String name, ImportDeclaration importDeclaration) {
        NamespaceImportSpecifier namespaceImportSpec = N4JS_FACTORY.createNamespaceImportSpecifier();
        ModuleNamespaceVirtualType namespace = TYPES_FACTORY.createModuleNamespaceVirtualType();
        namespaceImportSpec.setAlias(name);
        namespaceImportSpec.setDefinedType((Type)namespace);
        importDeclaration.getImportSpecifiers().add((Object)namespaceImportSpec);
        return importDeclaration;
    }
}

