/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.product;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.n4js.product.N4JSApplicationActionBarAdvisor;
import org.eclipse.n4js.product.N4JSApplicationWorkbenchAdvisor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchAdvisor;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchWindowAdvisor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.internal.util.PrefUtil;

public class N4JSApplicationWorkbenchWindowAdvisor
extends IDEWorkbenchWindowAdvisor {
    private static final Logger LOGGER = Logger.getLogger(N4JSApplicationWorkbenchWindowAdvisor.class);
    private static final Collection<String> VIEW_CATEGORY_BLACKLIST = Collections.unmodifiableList(Arrays.asList("Java", "Ant", "Remote Systems", "Plug-in Development", "XML", "Java Browsing", "Test Views", "Debug"));
    private static final Collection<String> VIEW_BLACKLIST = Collections.unmodifiableList(Arrays.asList("org.eclipse.gef.ui.palette_view", "org.eclipse.wst.common.snippets.internal.ui.SnippetsView"));
    private static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final String N4_CONTEXT_ID = "org.eclipse.n4js.ui.context";

    public N4JSApplicationWorkbenchWindowAdvisor(N4JSApplicationWorkbenchAdvisor advisor, IWorkbenchWindowConfigurer configurer) {
        super((IDEWorkbenchAdvisor)advisor, configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new N4JSApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        super.preWindowOpen();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(1024, 768));
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShowPerspectiveBar(true);
        this.initN4Context();
        this.updateDefaultEditorMappingIfAbsent();
        this.reviewDisabledCategoriesFromAppModel();
    }

    private void reviewDisabledCategoriesFromAppModel() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        MApplication service = (MApplication)workbenchWindow.getService(MApplication.class);
        Iterator itr = service.getDescriptors().iterator();
        while (itr.hasNext()) {
            MPartDescriptor descriptor = (MPartDescriptor)itr.next();
            if (!this.isView(descriptor) || !this.isDisabledView(descriptor)) continue;
            itr.remove();
        }
    }

    private boolean isDisabledView(MPartDescriptor descriptor) {
        return VIEW_BLACKLIST.contains(descriptor.getElementId()) || VIEW_CATEGORY_BLACKLIST.contains(descriptor.getCategory());
    }

    private boolean isView(MPartDescriptor descriptor) {
        return descriptor.getTags().contains("View");
    }

    private void initN4Context() {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getDisplay().asyncExec(() -> {
                IContextService service = (IContextService)workbench.getService(IContextService.class);
                service.activateContext(N4_CONTEXT_ID);
            });
        }
    }

    private void updateDefaultEditorMappingIfAbsent() {
        EditorRegistry registry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
        IFileEditorMapping[] iFileEditorMappingArray = registry.getFileEditorMappings();
        int n = iFileEditorMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFileEditorMapping editorMapping = iFileEditorMappingArray[n2];
            IEditorDescriptor defaultEditor = editorMapping.getDefaultEditor();
            if (defaultEditor == null) {
                String extension = editorMapping.getExtension();
                LOGGER.info((Object)("No default editor is associated with files with extension: '." + extension + "'."));
                IEditorDescriptor defaultTextEditor = registry.findEditor(DEFAULT_TEXT_EDITOR_ID);
                if (defaultTextEditor != null) {
                    ((FileEditorMapping)editorMapping).setDefaultEditor(defaultTextEditor);
                    String editorName = defaultTextEditor.getLabel();
                    if (editorName == null) {
                        editorName = defaultTextEditor.getId();
                    }
                    if (editorName != null) {
                        LOGGER.info((Object)("Associated files with extension " + extension + " with '" + editorName + "'."));
                    }
                }
            }
            ++n2;
        }
        registry.saveAssociations();
        PrefUtil.savePrefs();
    }
}

