/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Pure;

@Data
public class Diff<T> {
    private final T[] oldItems;
    private final T[] oldAllItems;
    private final T[] addedItems;
    private final T[] deletedItems;
    private final Map<T, T> editedItems;
    private final T[] newItems;
    private final T[] newAllItems;

    public boolean isEmpty() {
        return ((List)Conversions.doWrapArray(this.addedItems)).isEmpty() && ((List)Conversions.doWrapArray(this.deletedItems)).isEmpty() && this.editedItems.isEmpty() && Arrays.equals(this.newItems, this.oldItems) && Arrays.equals(this.newAllItems, this.oldAllItems);
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Diff:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("-----------------------------");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Old items:     ");
        String _string = Iterables.toString((Iterable)((Iterable)Conversions.doWrapArray(this.oldItems)));
        _builder.append(_string, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("Old all items: ");
        String _string_1 = Iterables.toString((Iterable)((Iterable)Conversions.doWrapArray(this.oldAllItems)));
        _builder.append(_string_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("Added items:   ");
        String _string_2 = Iterables.toString((Iterable)((Iterable)Conversions.doWrapArray(this.addedItems)));
        _builder.append(_string_2, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("Deleted items: ");
        String _string_3 = Iterables.toString((Iterable)((Iterable)Conversions.doWrapArray(this.deletedItems)));
        _builder.append(_string_3, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("Edited items:  ");
        _builder.append(this.editedItems, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("New items:     ");
        String _string_4 = Iterables.toString((Iterable)((Iterable)Conversions.doWrapArray(this.newItems)));
        _builder.append(_string_4, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("New all items: ");
        String _string_5 = Iterables.toString((Iterable)((Iterable)Conversions.doWrapArray(this.newAllItems)));
        _builder.append(_string_5, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("-----------------------------");
        _builder.newLine();
        return _builder.toString();
    }

    public Diff(T[] oldItems, T[] oldAllItems, T[] addedItems, T[] deletedItems, Map<T, T> editedItems, T[] newItems, T[] newAllItems) {
        this.oldItems = oldItems;
        this.oldAllItems = oldAllItems;
        this.addedItems = addedItems;
        this.deletedItems = deletedItems;
        this.editedItems = editedItems;
        this.newItems = newItems;
        this.newAllItems = newAllItems;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oldItems == null ? 0 : Arrays.deepHashCode(this.oldItems));
        result = 31 * result + (this.oldAllItems == null ? 0 : Arrays.deepHashCode(this.oldAllItems));
        result = 31 * result + (this.addedItems == null ? 0 : Arrays.deepHashCode(this.addedItems));
        result = 31 * result + (this.deletedItems == null ? 0 : Arrays.deepHashCode(this.deletedItems));
        result = 31 * result + (this.editedItems == null ? 0 : this.editedItems.hashCode());
        result = 31 * result + (this.newItems == null ? 0 : Arrays.deepHashCode(this.newItems));
        result = 31 * result + (this.newAllItems == null ? 0 : Arrays.deepHashCode(this.newAllItems));
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Diff other = (Diff)obj;
        if (this.oldItems == null ? other.oldItems != null : !Arrays.deepEquals(this.oldItems, other.oldItems)) {
            return false;
        }
        if (this.oldAllItems == null ? other.oldAllItems != null : !Arrays.deepEquals(this.oldAllItems, other.oldAllItems)) {
            return false;
        }
        if (this.addedItems == null ? other.addedItems != null : !Arrays.deepEquals(this.addedItems, other.addedItems)) {
            return false;
        }
        if (this.deletedItems == null ? other.deletedItems != null : !Arrays.deepEquals(this.deletedItems, other.deletedItems)) {
            return false;
        }
        if (this.editedItems == null ? other.editedItems != null : !this.editedItems.equals(other.editedItems)) {
            return false;
        }
        if (this.newItems == null ? other.newItems != null : !Arrays.deepEquals(this.newItems, other.newItems)) {
            return false;
        }
        return !(this.newAllItems == null ? other.newAllItems != null : !Arrays.deepEquals(this.newAllItems, other.newAllItems));
    }

    @Pure
    public T[] getOldItems() {
        return this.oldItems;
    }

    @Pure
    public T[] getOldAllItems() {
        return this.oldAllItems;
    }

    @Pure
    public T[] getAddedItems() {
        return this.addedItems;
    }

    @Pure
    public T[] getDeletedItems() {
        return this.deletedItems;
    }

    @Pure
    public Map<T, T> getEditedItems() {
        return this.editedItems;
    }

    @Pure
    public T[] getNewItems() {
        return this.newItems;
    }

    @Pure
    public T[] getNewAllItems() {
        return this.newAllItems;
    }
}

