/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddExtensionAttributeCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddExtensionCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddExtensionElementCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.ExtensibleAddExtensionCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.ExtensibleRemoveExtensionNodeCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.RemoveExtensionNodeCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractExtensionsSection;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.AddExtensionsComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.CategoryProvider;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.DOMExtensionTreeLabelProvider;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.ExtensionItemFilter;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.ExtensionsSchemasRegistry;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.SpecificationForExtensionsSchema;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.XSDExtensionTreeContentProvider;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom.NodeFilter;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter;
import org.eclipse.wst.xsd.ui.internal.util.ModelReconcileAdapter;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensionsSection
extends AbstractExtensionsSection {
    XSDModelAdapter adapter = null;

    public ExtensionsSection() {
        this.setExtensionTreeLabelProvider((ILabelProvider)new DOMExtensionTreeLabelProvider());
        this.setExtensionTreeContentProvider(new XSDExtensionTreeContentProvider());
    }

    protected AddExtensionsComponentDialog createAddExtensionsComponentDialog() {
        AddExtensionsComponentDialog dialog = new AddExtensionsComponentDialog(this.composite.getShell(), this.getExtensionsSchemasRegistry()){

            protected IStructuredContentProvider getCategoryContentProvider() {
                return new XSDCategoryContentProvider();
            }
        };
        dialog.addElementsTableFilter(new AddExtensionsComponentDialogFilter(this.input, dialog));
        return dialog;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Element element;
        Object obj;
        super.setInput(part, selection);
        if (this.adapter == null && selection instanceof StructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) instanceof XSDConcreteComponent && (element = ((XSDConcreteComponent)obj).getElement()) != null) {
            ModelReconcileAdapter modelReconcileAdapter;
            this.adapter = XSDModelAdapter.lookupOrCreateModelAdapter(element.getOwnerDocument());
            if (this.adapter != null && (modelReconcileAdapter = this.adapter.getModelReconcileAdapter()) != null) {
                modelReconcileAdapter.addListener(this.internalNodeAdapter);
            }
        }
        this.extensionTreeViewer.expandToLevel(2);
    }

    public void dispose() {
        ModelReconcileAdapter modelReconcileAdapter;
        super.dispose();
        if (this.adapter != null && (modelReconcileAdapter = this.adapter.getModelReconcileAdapter()) != null) {
            modelReconcileAdapter.removeListener(this.internalNodeAdapter);
        }
    }

    protected AddExtensionCommand getAddExtensionCommand(Object o) {
        AddExtensionCommand addExtensionCommand = null;
        if (o instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)o;
            ExtensibleAddExtensionCommand extensibleAddExtensionCommand = this.getExtensionsSchemasRegistry().getAddExtensionCommand(element.getTargetNamespace());
            if (extensibleAddExtensionCommand != null) {
                extensibleAddExtensionCommand.setInputs((XSDConcreteComponent)this.input, element);
                addExtensionCommand = extensibleAddExtensionCommand;
            } else {
                addExtensionCommand = new AddExtensionElementCommand(Messages._UI_ACTION_ADD_APPINFO_ELEMENT, (XSDConcreteComponent)this.input, element);
            }
        } else if (o instanceof XSDAttributeDeclaration) {
            XSDAttributeDeclaration attribute = (XSDAttributeDeclaration)o;
            addExtensionCommand = new AddExtensionAttributeCommand(Messages._UI_ACTION_ADD_APPINFO_ATTRIBUTE, (XSDConcreteComponent)this.input, attribute);
        }
        return addExtensionCommand;
    }

    protected Command getRemoveExtensionCommand(Object o) {
        RemoveExtensionNodeCommand command = null;
        try {
            if (o instanceof Node) {
                Node node = (Node)o;
                ExtensibleRemoveExtensionNodeCommand removeCommand = this.getExtensionsSchemasRegistry().getRemoveExtensionNodeCommand(node.getNamespaceURI());
                if (removeCommand != null) {
                    removeCommand.setInput((XSDConcreteComponent)this.input);
                    removeCommand.setNode(node);
                    return removeCommand;
                }
                command = new RemoveExtensionNodeCommand(Messages._UI_ACTION_DELETE_APPINFO_ELEMENT, node);
            }
        }
        catch (Exception exception) {}
        return command;
    }

    protected ExtensionsSchemasRegistry getExtensionsSchemasRegistry() {
        return XSDEditorPlugin.getDefault().getExtensionsSchemasRegistry();
    }

    protected boolean isTreeViewerInputElement(Element element) {
        if (this.input instanceof XSDConcreteComponent) {
            Node grandParent;
            XSDConcreteComponent component = (XSDConcreteComponent)this.input;
            Element componentElement = component.getElement();
            Node parent = element.getParentNode();
            Node node = grandParent = parent != null ? parent.getParentNode() : null;
            return componentElement == element || componentElement == parent || componentElement == grandParent;
        }
        return false;
    }

    protected IPreferenceStore getPrefStore() {
        return XSDEditorPlugin.getPlugin().getPreferenceStore();
    }

    protected class AddExtensionsComponentDialogFilter
    extends ViewerFilter {
        private Object input;
        private AddExtensionsComponentDialog dialog;

        public AddExtensionsComponentDialogFilter(Object input, AddExtensionsComponentDialog dialog) {
            this.input = input;
            this.dialog = dialog;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.input instanceof XSDConcreteComponent && element instanceof XSDConcreteComponent) {
                SpecificationForExtensionsSchema spec = this.dialog.getSelectedCategory();
                NodeFilter filter = XSDEditorPlugin.getPlugin().getNodeCustomizationRegistry().getNodeFilter(spec.getNamespaceURI());
                if (filter == null) {
                    filter = spec.getNodeFilter();
                }
                if (filter instanceof ExtensionItemFilter) {
                    ExtensionItemFilter extensionItemFilter = (ExtensionItemFilter)((Object)filter);
                    return extensionItemFilter.isApplicableContext((XSDConcreteComponent)this.input, (XSDConcreteComponent)element);
                }
            }
            return true;
        }
    }

    static class XSDCategoryContentProvider
    implements IStructuredContentProvider {
        XSDCategoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            SpecificationForExtensionsSchema[] extensionsSchemaSpecs = null;
            try {
                List inputList = (List)inputElement;
                ArrayList<SpecificationForExtensionsSchema> total = new ArrayList<SpecificationForExtensionsSchema>();
                total.addAll(inputList);
                List dynamicCategories = XSDEditorPlugin.getPlugin().getExtensionsSchemasRegistry().getCategoryProviders();
                Iterator iter = dynamicCategories.iterator();
                while (iter.hasNext()) {
                    CategoryProvider categoryProvider = (CategoryProvider)iter.next();
                    Iterator it = categoryProvider.getCategories().iterator();
                    while (it.hasNext()) {
                        SpecificationForExtensionsSchema sp = (SpecificationForExtensionsSchema)it.next();
                        total.add(sp);
                    }
                }
                extensionsSchemaSpecs = total.toArray(new SpecificationForExtensionsSchema[0]);
            }
            catch (Exception exception) {}
            return extensionsSchemaSpecs;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

