/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui.resultsview;

import org.eclipse.n4js.tester.domain.TestStatus;
import org.eclipse.n4js.tester.ui.resultsview.TestStatusCounter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TestProgressBar
extends Canvas {
    private TestStatusCounter counter;
    private int expectedTotal = 0;
    private int preferredHeight = 18;
    private final Color colorSkipped = new Color((Device)Display.getCurrent(), 230, 232, 235);
    private final Color colorPassed = new Color((Device)Display.getCurrent(), 198, 242, 177);
    private final Color colorFailed = new Color((Device)Display.getCurrent(), 242, 188, 177);
    private final Color colorError = new Color((Device)Display.getCurrent(), 242, 188, 177);
    private final Color colorFixme = new Color((Device)Display.getCurrent(), 177, 231, 242);

    public TestProgressBar(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(ev -> this.onPaint(ev.gc));
        this.addDisposeListener(ev -> this.onDispose());
    }

    protected void setPreferredHeight(int preferredHeight) {
        this.preferredHeight = preferredHeight;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (hHint == -1) {
            return super.computeSize(wHint, this.preferredHeight, changed);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    public void setExpectedTotal(int expectedTotal) {
        this.expectedTotal = expectedTotal;
        this.redraw();
    }

    public void setCounter(TestStatusCounter counter) {
        this.counter = counter;
        this.redraw();
    }

    final Color getColorForStatus(TestStatus status) {
        if (status != null) {
            switch (status) {
                case SKIPPED: 
                case SKIPPED_NOT_IMPLEMENTED: 
                case SKIPPED_PRECONDITION: 
                case SKIPPED_IGNORE: {
                    return this.colorSkipped;
                }
                case PASSED: {
                    return this.colorPassed;
                }
                case SKIPPED_FIXME: {
                    return this.colorFixme;
                }
                case FAILED: {
                    return this.colorFailed;
                }
                case ERROR: {
                    return this.colorError;
                }
            }
        }
        return Display.getCurrent().getSystemColor(1);
    }

    protected void onPaint(GC gc) {
        TestStatus status;
        Rectangle b = this.getBounds();
        TestStatus testStatus = status = this.counter != null ? this.counter.getAggregatedStatus() : null;
        if (status != null) {
            int total = Math.max(this.expectedTotal, this.counter.getTotal());
            int value = this.counter.getTotal();
            int totalPx = b.width;
            int valuePx = Math.round((float)totalPx * ((float)value / (float)total));
            gc.setBackground(this.getColorForStatus(status));
            gc.fillRectangle(0, 0, valuePx, b.height);
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0 + valuePx, 0, b.width - valuePx, b.height);
        } else {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(b);
        }
        if (this.counter != null) {
            FontMetrics fm = gc.getFontMetrics();
            gc.setForeground(this.getForeground());
            int pending = this.expectedTotal > 0 ? this.expectedTotal - this.counter.getTotal() : -1;
            gc.drawString(this.counter.toString(true, pending, 131072), 4, b.height / 2 - fm.getHeight() / 2 - fm.getDescent(), true);
        }
    }

    protected void onDispose() {
        this.dispose(new Resource[]{this.colorSkipped, this.colorPassed, this.colorFailed, this.colorError, this.colorFixme});
        super.dispose();
    }

    private void dispose(Resource ... rs) {
        Resource[] resourceArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (r != null && !r.isDisposed()) {
                r.dispose();
            }
            ++n2;
        }
    }
}

