/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.Writer;
import java.nio.file.Path;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.DataCollectors;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.transpiler.PreparationStep;
import org.eclipse.n4js.transpiler.PrettyPrintingStep;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.TranspilerState;
import org.eclipse.n4js.transpiler.utils.TranspilerDebugUtils;
import org.eclipse.n4js.utils.N4JSDataCollectors;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.n4js.utils.di.scopes.ScopeManager;
import org.eclipse.n4js.utils.di.scopes.TransformationScoped;

public abstract class AbstractTranspiler {
    private static final boolean DEBUG_DUMP_STATE = false;
    private static final boolean DEBUG_DRAW_STATE = false;
    private static final boolean DEBUG_PERFORM_ASSERTIONS = true;
    private static final boolean DEBUG_PERFORM_VALIDATIONS = true;
    @Inject
    private PreparationStep preparationStep;
    @Inject
    private PrettyPrintingStep prettyPrintingStep;
    @Inject
    private ScopeManager scopeManager;
    @Inject
    private ResourceNameComputer resourceNameComputer;
    @Inject
    private TranspilerDebugUtils transpilerDebugUtils;

    protected abstract Optional<String> getPreamble();

    protected abstract Transformation[] computeTransformationsToBeExecuted(TranspilerState var1);

    public void transpile(N4JSResource resource, GeneratorOption[] options, Writer outCode, Optional<SourceMapInfo> optSourceMapInfo) {
        TranspilerState state = this.prepare(resource, options);
        try {
            this.transform(state);
            Optional<String> optPreamble = this.getPreamble();
            this.prettyPrint(state, outCode, optPreamble, optSourceMapInfo);
        }
        finally {
            this.cleanUpTemporaryTypes(state);
        }
    }

    protected TranspilerState prepare(N4JSResource resource, GeneratorOption[] options) {
        Script script = resource.getScript();
        if (script == null || script.eIsProxy()) {
            throw new IllegalArgumentException("given N4JSResource does not contain a script or script is a proxy");
        }
        return this.preparationStep.prepare(script, options);
    }

    protected void transform(TranspilerState state) {
        this.scopeManager.enter(TransformationScoped.class);
        try {
            Measurement m2;
            Object var14_22;
            Throwable throwable;
            String name;
            Transformation currT;
            int n;
            int n2;
            Transformation[] transformationArray;
            Measurement m;
            this.scopeManager.bind(TransformationScoped.class, TranspilerState.class, (Object)state);
            Transformation[] transformationsPreFiler = null;
            Transformation[] transformations = null;
            Throwable throwable2 = null;
            Object var5_8 = null;
            try {
                m = N4JSDataCollectors.dcTranspilationStep1.getMeasurement("T1");
                try {
                    transformationsPreFiler = this.computeTransformationsToBeExecuted(state);
                    transformations = TransformationDependency.filterByTranspilerOptions(transformationsPreFiler, state.options);
                    TransformationDependency.assertDependencies(transformations);
                }
                finally {
                    if (m != null) {
                        m.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            throwable2 = null;
            var5_8 = null;
            try {
                m = N4JSDataCollectors.dcTranspilationStep2.getMeasurement("T2");
                try {
                    transformationArray = transformations;
                    n2 = transformations.length;
                    n = 0;
                    while (n < n2) {
                        currT = transformationArray[n];
                        name = "T2_" + currT.getClass().getSimpleName();
                        DataCollector dcT2_ct = DataCollectors.INSTANCE.getOrCreateDataCollector(name, N4JSDataCollectors.dcTranspilationStep2);
                        throwable = null;
                        var14_22 = null;
                        try {
                            m2 = dcT2_ct.getMeasurement(name);
                            try {
                                currT.analyze();
                            }
                            finally {
                                if (m2 != null) {
                                    m2.close();
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                        ++n;
                    }
                }
                finally {
                    if (m != null) {
                        m.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
            throwable2 = null;
            var5_8 = null;
            try {
                m = N4JSDataCollectors.dcTranspilationStep3.getMeasurement("T3");
                try {
                    transformationArray = transformations;
                    n2 = transformations.length;
                    n = 0;
                    while (n < n2) {
                        currT = transformationArray[n];
                        name = "T3_" + currT.getClass().getSimpleName();
                        DataCollector dcT3_ct = DataCollectors.INSTANCE.getOrCreateDataCollector(name, N4JSDataCollectors.dcTranspilationStep3);
                        throwable = null;
                        var14_22 = null;
                        try {
                            m2 = dcT3_ct.getMeasurement(name);
                            try {
                                currT.assertPreConditions();
                                currT.transform();
                                currT.assertPostConditions();
                                this.transpilerDebugUtils.validateState(state, true);
                            }
                            finally {
                                if (m2 != null) {
                                    m2.close();
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable == null) {
                                throwable = throwable6;
                            } else if (throwable != throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            throw throwable;
                        }
                        ++n;
                    }
                }
                finally {
                    if (m != null) {
                        m.close();
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable2 == null) {
                    throwable2 = throwable7;
                } else if (throwable2 != throwable7) {
                    throwable2.addSuppressed(throwable7);
                }
                throw throwable2;
            }
        }
        finally {
            this.scopeManager.exit(TransformationScoped.class);
        }
    }

    protected void prettyPrint(TranspilerState state, Writer outCode, Optional<String> optPreamble, Optional<SourceMapInfo> optSourceMapInfo) {
        this.prettyPrintingStep.print(state, outCode, optPreamble, optSourceMapInfo);
    }

    protected void cleanUpTemporaryTypes(TranspilerState state) {
        state.resource.clearTemporaryTypes();
    }

    public TranspilerState testPrepare(N4JSResource resource, GeneratorOption[] options) {
        return this.prepare(resource, options);
    }

    public void testTransform(TranspilerState state) {
        this.transform(state);
    }

    public class SourceMapInfo {
        public String sourceMapFileExtension;
        public String simpleCompiledFileName;
        public String simpleSourceMapFileName;
        public String n4jsFilePath;
        public Writer sourceMapBuff;
        public boolean isExplicitSourceRef;
        public Path explicitNavigationToSrc;

        public String resolve(N4JSResource eResource) {
            if (this.isExplicitSourceRef) {
                String completeSpecifier = AbstractTranspiler.this.resourceNameComputer.getCompleteModuleSpecifier(eResource.getModule());
                String fileExtension = eResource.getURI().fileExtension();
                String specifierAsFile = fileExtension == null ? completeSpecifier : String.valueOf(completeSpecifier) + "." + fileExtension;
                return this.explicitNavigationToSrc.resolve(specifierAsFile).toString();
            }
            return this.n4jsFilePath;
        }
    }
}

