/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.sourcemap;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;

public class SourceMapFileLocator {
    @Inject
    IN4JSCore n4jsCore;

    public File resolveSourceMapFromSrc(Path srcLocation) throws Exception {
        URI uri = URI.createFileURI((String)srcLocation.normalize().toAbsolutePath().toString());
        Optional optSrcContainer = this.n4jsCore.findN4JSSourceContainer(uri);
        if (optSrcContainer.isPresent()) {
            IN4JSSourceContainer srcContainer = (IN4JSSourceContainer)optSrcContainer.get();
            Path projectPath = srcContainer.getProject().getLocationPath();
            Path srcPath = projectPath.resolve(srcContainer.getRelativeLocation());
            Path modulePath = srcPath.relativize(srcLocation).getParent();
            String nameWithoutExt = this.extractSimpleFilenameWithoutExtension(srcLocation);
            String outPath = srcContainer.getProject().getOutputPath();
            Path genParentPath = projectPath.resolve(outPath);
            if (modulePath != null) {
                genParentPath = genParentPath.resolve(modulePath);
            }
            return this.resolveMapFileInGenPath(nameWithoutExt, genParentPath);
        }
        return null;
    }

    public File resolveSourceMapFromGen(Path genLocation) throws Exception {
        Path genParentPath = genLocation.getParent();
        String nameWithoutExtension = this.extractSimpleFilenameWithoutExtension(genLocation);
        return this.resolveMapFileInGenPath(nameWithoutExtension, genParentPath);
    }

    private String extractSimpleFilenameWithoutExtension(Path location) {
        String filename = location.getFileName().toString();
        int i = filename.lastIndexOf(46);
        if (i < 0) {
            return filename;
        }
        return filename.substring(0, i);
    }

    private File resolveMapFileInGenPath(String nameWithoutExt, Path genParentPath) {
        Path mapFilePath = genParentPath.resolve(String.valueOf(nameWithoutExt) + ".map");
        File file = mapFilePath.toFile();
        if (!file.exists()) {
            mapFilePath = genParentPath.resolve(String.valueOf(nameWithoutExt) + ".js.map");
            file = mapFilePath.toFile();
        }
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

