/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.wst.common.snippets.core.ISnippetVariable;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetVariable;
import org.eclipse.wst.common.snippets.internal.util.SnippetProviderManager;

public abstract class AbstractModelFactory {
    protected void connectItemsAndCategories(SnippetDefinitions definitions) {
        Iterator iterator = definitions.getCategories().iterator();
        while (iterator.hasNext()) {
            SnippetPaletteDrawer category = (SnippetPaletteDrawer)iterator.next();
            category.getChildren().clear();
        }
        iterator = definitions.getItems().iterator();
        while (iterator.hasNext()) {
            SnippetPaletteItem item = (SnippetPaletteItem)iterator.next();
            SnippetPaletteDrawer parentCategory = (SnippetPaletteDrawer)definitions.getCategory(item.getCategoryName());
            if (parentCategory != null) {
                parentCategory.add(item);
                continue;
            }
            Logger.log(2, "Rejecting item " + item.getId() + " in missing category " + item.getCategoryName());
            iterator.remove();
        }
    }

    public SnippetPaletteDrawer createCategory(Object source) {
        String id = this.getID(source);
        if (id == null || id.length() == 0) {
            return null;
        }
        SnippetPaletteDrawer drawer = new SnippetPaletteDrawer(id);
        drawer.setType(PaletteDrawer.PALETTE_TYPE_DRAWER);
        this.setProperties(drawer, source);
        this.migrate50to51(drawer);
        return drawer;
    }

    public SnippetPaletteItem createItem(Object source) {
        String id = this.getID(source);
        if (id == null || id.length() == 0) {
            return null;
        }
        SnippetPaletteItem item = new SnippetPaletteItem(id);
        item.setDescription("");
        this.setProperties(item, source);
        this.migrate50to51(item);
        return item;
    }

    public ISnippetVariable createVariable(Object source) {
        if (source == null) {
            return null;
        }
        SnippetVariable var = new SnippetVariable();
        this.setProperties(var, source);
        return var;
    }

    protected List createVariables(Object[] sources) {
        if (sources == null || sources.length < 1) {
            return null;
        }
        ArrayList<ISnippetVariable> variables = new ArrayList<ISnippetVariable>(sources.length);
        int i = 0;
        while (i < sources.length) {
            ISnippetVariable variable = this.createVariable(sources[i]);
            if (variable != null) {
                variables.add(variable);
            }
            ++i;
        }
        return variables;
    }

    protected abstract String getID(Object var1);

    public abstract SnippetDefinitions loadCurrent();

    protected void migrate50to51(ISnippetsEntry entry) {
        if (entry.getDescription() != null && entry.getDescription().length() > 0 && (entry.getLabel() == null || entry.getLabel().length() == 0)) {
            if (entry instanceof SnippetPaletteItem) {
                ((SnippetPaletteItem)entry).setLabel(entry.getDescription());
                ((SnippetPaletteItem)entry).setDescription("");
            }
            if (entry instanceof SnippetPaletteDrawer) {
                ((SnippetPaletteDrawer)entry).setLabel(entry.getDescription());
                ((SnippetPaletteDrawer)entry).setDescription("");
            }
        }
    }

    protected void setEntryProperty(ISnippetsEntry entry, String property, Object value) {
        if (property == null || value == null) {
            return;
        }
        if (entry instanceof SnippetPaletteItem) {
            if (property.equals("description")) {
                ((SnippetPaletteItem)entry).setDescription(value.toString());
            } else if (property.equals("smallicon")) {
                ((SnippetPaletteItem)entry).setIconName(value.toString());
            } else if (property.equals("id")) {
                ((SnippetPaletteItem)entry).setId(value.toString());
            } else if (property.equals("label")) {
                ((SnippetPaletteItem)entry).setLabel(value.toString());
            } else if (property.equals("largeicon")) {
                ((SnippetPaletteItem)entry).setLargeIconName(value.toString());
            } else if (property.equals("filters")) {
                ((SnippetPaletteItem)entry).setFilters((String[])value);
            }
        }
        if (entry instanceof SnippetPaletteDrawer) {
            if (property.equals("description")) {
                ((SnippetPaletteDrawer)entry).setDescription(value.toString());
            } else if (property.equals("smallicon")) {
                ((SnippetPaletteDrawer)entry).setIconName(value.toString());
            } else if (property.equals("id")) {
                ((SnippetPaletteDrawer)entry).setId(value.toString());
            } else if (property.equals("label")) {
                ((SnippetPaletteDrawer)entry).setLabel(value.toString());
            } else if (property.equals("largeicon")) {
                ((SnippetPaletteDrawer)entry).setLargeIconName(value.toString());
            } else if (property.equals("filters")) {
                ((SnippetPaletteDrawer)entry).setFilters((String[])value);
            }
        }
    }

    protected abstract void setProperties(SnippetPaletteDrawer var1, Object var2);

    protected abstract void setProperties(SnippetPaletteItem var1, Object var2);

    protected abstract void setProperties(SnippetVariable var1, Object var2);

    protected void setProperty(SnippetPaletteDrawer category, String property, Object value) {
        if (property == null || value == null) {
            return;
        }
        if (property.equals("show")) {
            category.setVisible(Boolean.valueOf(value.toString()));
        } else {
            this.setEntryProperty(category, property, value);
        }
    }

    protected void setProperty(SnippetPaletteItem item, String property, Object value) {
        if (property == null) {
            return;
        }
        Object propertyValue = value;
        if (propertyValue == null) {
            propertyValue = "";
        }
        if (property.equals("category")) {
            item.setCategoryName(propertyValue.toString());
        } else if (property.equals("class")) {
            item.setClassName(propertyValue.toString());
        } else if (property.equals("content")) {
            item.setContentString(propertyValue.toString());
        } else if (property.equals("editorclass")) {
            item.setEditorClassName(propertyValue.toString());
        } else if (property.equals("snippetProvider")) {
            item.setProvider(SnippetProviderManager.findProvider(propertyValue.toString()));
        } else {
            this.setEntryProperty(item, property, propertyValue);
        }
    }

    protected void setProperty(SnippetVariable variable, String property, Object value) {
        if (property == null) {
            return;
        }
        Object propertyValue = value;
        if (propertyValue == null) {
            propertyValue = "";
        }
        if (property.equals("default")) {
            variable.setDefaultValue(propertyValue.toString());
        } else if (property.equals("description")) {
            variable.setDescription(propertyValue.toString());
        } else if (property.equals("name")) {
            variable.setName(propertyValue.toString());
        } else if (property.equals("id")) {
            variable.setId(propertyValue.toString());
        }
    }
}

