/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.inject.Singleton;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.n4js.generator.IWorkspaceMarkerSupport;

@Singleton
public class WorkspaceMarkerSupport
implements IWorkspaceMarkerSupport {
    private static final Logger LOGGER = Logger.getLogger(WorkspaceMarkerSupport.class);

    public void createWarning(IResource res, String codeKey, String location, String message, String uriKey, boolean fixable) {
        this.createMarker(res, codeKey, location, message, uriKey, fixable, 1);
    }

    public void createError(IResource res, String codeKey, String location, String message, String uriKey, boolean fixable) {
        this.createMarker(res, codeKey, location, message, uriKey, fixable, 2);
    }

    private void createMarker(IResource res, String codeKey, String location, String message, String uriKey, boolean fixable, int severity) {
        try {
            IMarker marker = res.createMarker("org.eclipse.n4js.ui.workspace.error");
            marker.setAttribute("lineNumber", 0);
            marker.setAttribute("charStart", 0);
            marker.setAttribute("charEnd", 0);
            marker.setAttribute("severity", severity);
            marker.setAttribute("CODE_KEY", (Object)codeKey);
            marker.setAttribute("location", (Object)location);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("URI_KEY", (Object)uriKey);
            marker.setAttribute("FIXABLE_KEY", fixable);
        }
        catch (CoreException e) {
            LOGGER.error((Object)e.getStatus());
            String resInfo = "";
            resInfo = res.getLocationURI() != null ? "on resource with uri=" + res.getLocationURI() : "on resource=" + res;
            throw new RuntimeException("Cannot create error marker with message='" + message + "' " + resInfo + ".", e);
        }
    }

    public boolean hasMarkers(IResource res, String codeKey) {
        return !this.getAllMarker(res, null, codeKey).isEmpty();
    }

    public void deleteMarkers(IResource res, String ... codeKeys) {
        this.deleteMarkersWithUriKey(res, null, codeKeys);
    }

    public void deleteMarkersWithUriKey(IResource res, String uriKey, String ... codeKeys) {
        for (IMarker marker : this.getAllMarker(res, uriKey, codeKeys)) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                LOGGER.error((Object)e.getStatus());
            }
        }
    }

    private List<IMarker> getAllMarker(IResource res, String uriKey, String ... codeKeys) {
        LinkedList<IMarker> allMarkers = new LinkedList<IMarker>();
        try {
            IMarker[] allResourceMarkers;
            IMarker[] iMarkerArray = allResourceMarkers = res.findMarkers(null, true, 0);
            int n = allResourceMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String mCodeKey = marker.getAttribute("CODE_KEY", "");
                String mUriKey = marker.getAttribute("URI_KEY", "");
                boolean select = false;
                String[] stringArray = codeKeys;
                int n3 = codeKeys.length;
                int n4 = 0;
                while (n4 < n3) {
                    String codeKey = stringArray[n4];
                    select |= mCodeKey.equals(codeKey);
                    ++n4;
                }
                if (select &= uriKey == null || uriKey.equals(mUriKey)) {
                    allMarkers.add(marker);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LOGGER.error((Object)e.getStatus());
        }
        return allMarkers;
    }
}

