/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.dependencies;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.n4js.binaries.BinariesPreferenceStore;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NpmrcBinary;
import org.eclipse.n4js.external.NpmLogger;
import org.eclipse.n4js.ui.external.ExternalLibrariesActionsHelper;
import org.eclipse.n4js.ui.utils.AutobuildUtils;
import org.eclipse.n4js.ui.wizard.dependencies.InstallOptions;
import org.eclipse.n4js.utils.StatusHelper;

public class RunnableInstallDependencies
implements IRunnableWithProgress {
    private MultiStatus multistatus;
    private InstallOptions options;
    @Inject
    private StatusHelper statusHelper;
    @Inject
    private ExternalLibrariesActionsHelper librariesActionsHelper;
    @Inject
    private BinariesPreferenceStore preferenceStore;
    @Inject
    private Provider<NpmrcBinary> npmrcBinaryProvider;
    @Inject
    private NpmLogger userLogger;

    public void setInstallOptions(InstallOptions options) {
        this.options = options;
    }

    public synchronized IStatus getResultStatus() {
        if (this.multistatus == null) {
            return this.statusHelper.createError(String.valueOf(this.getClass().getName()) + " was not called yet!");
        }
        MultiStatus result = this.statusHelper.createMultiStatus("result");
        result.merge((IStatus)this.multistatus);
        return result;
    }

    public synchronized void run(IProgressMonitor pmonitor) {
        boolean userNpmrc;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1);
        boolean wasAutoBuilding = AutobuildUtils.get();
        AutobuildUtils.turnOff();
        this.multistatus = this.statusHelper.createMultiStatus("Status of setting up dependencies.");
        boolean bl = userNpmrc = this.options.npmrc != null && !this.options.npmrc.isEmpty();
        if (userNpmrc) {
            File selectedNPMRC = this.getFileOrNull(this.options.npmrc);
            this.saveSettingsForNPM(this.multistatus, selectedNPMRC);
            if (!this.multistatus.isOK()) {
                return;
            }
        }
        this.librariesActionsHelper.cleanAndInstallAllDependencies(monitor, this.multistatus, this.options.clearNpmCache);
        if (!this.multistatus.isOK()) {
            return;
        }
        if (wasAutoBuilding) {
            AutobuildUtils.turnOn();
        }
    }

    private void saveSettingsForNPM(MultiStatus status, File selectedNPMRC) {
        if (selectedNPMRC != null) {
            URI newLocation;
            NpmrcBinary npmrcBinary = (NpmrcBinary)this.npmrcBinaryProvider.get();
            URI oldLocation = npmrcBinary.getUserConfiguredLocation();
            File npmrcFolder = selectedNPMRC.getParentFile();
            if (npmrcFolder != null && !(newLocation = npmrcFolder.toURI()).equals(oldLocation)) {
                this.userLogger.logInfo("dropping old npmrc : " + oldLocation);
                this.userLogger.logInfo("setting new npmrc : " + newLocation);
                this.preferenceStore.setPath((Binary)this.npmrcBinaryProvider.get(), newLocation);
                IStatus save = this.preferenceStore.save();
                status.add(save);
            }
        }
    }

    private File getFileOrNull(String filePath) {
        File fNPMRC;
        if (!Strings.isNullOrEmpty((String)filePath) && (fNPMRC = new File(filePath)).isFile()) {
            return fNPMRC;
        }
        return null;
    }
}

