/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.highlighting;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.parameter.IStatementRelatedRegion;
import org.eclipse.xpect.registry.DefaultBinding;
import org.eclipse.xpect.ui.util.XpectFileAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;

public class XtHighlightingCalculator
implements ISemanticHighlightingCalculator {
    protected static Pattern ALPHANUMERIC = Pattern.compile("[a-zA-Z0-9_]+");
    protected static final Map<String, String> RULE_TO_FOMRAT = Maps.newHashMap();
    @DefaultBinding
    @Inject(optional=true)
    private ISemanticHighlightingCalculator original;

    static {
        RULE_TO_FOMRAT.put("ID", "xpect.default");
        RULE_TO_FOMRAT.put("INVOCATION", "xpect.default");
        RULE_TO_FOMRAT.put("ML_COMMENT", "xpect.comment");
        RULE_TO_FOMRAT.put("SL_COMMENT", "xpect.comment");
        RULE_TO_FOMRAT.put("INT", "xpect.number");
        RULE_TO_FOMRAT.put("STRING", "xpect.string");
    }

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (this.original != null) {
            this.original.provideHighlightingFor(resource, acceptor);
        }
        this.provideHighlightingForXpect(resource, acceptor);
    }

    protected void provideHighlightingForKeyword(ILeafNode node, Keyword kw, IHighlightedPositionAcceptor acceptor) {
        if (ALPHANUMERIC.matcher(kw.getValue()).matches()) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"xpect.keyword"});
        } else {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"xpect.punctuation"});
        }
    }

    protected void provideHighlightingForRule(ILeafNode node, TerminalRule rule, IHighlightedPositionAcceptor acceptor) {
        String conf = RULE_TO_FOMRAT.get(rule.getName());
        if (conf != null) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{conf});
        }
    }

    protected void provideHighlightingForHidden(ILeafNode node, EObject grammarEle, IHighlightedPositionAcceptor acceptor) {
        if (node.getText().trim().length() == 0) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"xpect.whitespace"});
        } else {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"xpect.comment"});
        }
    }

    protected void provideHighlightingForXpect(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        XtextResource xpectResource = XpectFileAccess.getXpectResource((Resource)resource);
        ICompositeNode rootNode = xpectResource.getParseResult().getRootNode();
        for (ILeafNode node : rootNode.getLeafNodes()) {
            AbstractRule rule;
            AbstractElement rc;
            EObject ele = node.getGrammarElement();
            if (node.isHidden()) {
                this.provideHighlightingForHidden(node, ele, acceptor);
                continue;
            }
            if (ele instanceof Keyword) {
                this.provideHighlightingForKeyword(node, (Keyword)ele, acceptor);
                continue;
            }
            if (ele instanceof TerminalRule) {
                this.provideHighlightingForRule(node, (TerminalRule)ele, acceptor);
                continue;
            }
            if (ele instanceof RuleCall) {
                AbstractRule rule2 = ((RuleCall)ele).getRule();
                if (!(rule2 instanceof TerminalRule) || rule2.getName().equals("ANY_OTHER")) continue;
                this.provideHighlightingForRule(node, (TerminalRule)rule2, acceptor);
                continue;
            }
            if (!(ele instanceof CrossReference) || !((rc = ((CrossReference)ele).getTerminal()) instanceof RuleCall) || !((rule = ((RuleCall)rc).getRule()) instanceof TerminalRule)) continue;
            this.provideHighlightingForRule(node, (TerminalRule)rule, acceptor);
        }
        for (EObject obj : xpectResource.getContents()) {
            if (!(obj instanceof XpectFile)) continue;
            for (XpectInvocation inv : ((XpectFile)obj).getInvocations()) {
                for (IStatementRelatedRegion region : inv.getRelatedRegions()) {
                    acceptor.addPosition(region.getOffset(), region.getLength(), new String[]{"xpect.default"});
                }
            }
        }
    }
}

