/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import java.util.List;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.internal.CommentReplacer;
import org.eclipse.xtext.formatting2.internal.WhitespaceReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;

public class MultilineCommentReplacer
extends CommentReplacer {
    private final boolean multiline;
    private final char prefix;

    public MultilineCommentReplacer(IComment comment, char prefix) {
        super(comment);
        this.prefix = prefix;
        this.multiline = comment.isMultiline();
    }

    @Override
    public void configureWhitespace(WhitespaceReplacer leading, WhitespaceReplacer trailing) {
        if (this.multiline) {
            this.enforceNewLine(leading);
            this.enforceNewLine(trailing);
        } else {
            this.enforceSingleSpace(leading);
            this.enforceSingleSpace(trailing);
        }
    }

    @Override
    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        if (!this.multiline) {
            return context;
        }
        IComment comment = this.getComment();
        ITextRegionAccess access = comment.getTextRegionAccess();
        List<ILineRegion> lines = comment.getLineRegions();
        String oldIndentation = lines.get(0).getIndentation().getText();
        String indentationString = context.getIndentationString();
        String newIndentation = indentationString + " " + this.prefix + " ";
        for (int i = 1; i < lines.size() - 1; ++i) {
            ITextSegment line = lines.get(i);
            String text = line.getText();
            int prefixOffset = this.prefixOffset(text);
            ITextSegment target = prefixOffset >= 0 ? access.regionForOffset(line.getOffset(), prefixOffset + 1) : (text.startsWith(oldIndentation) ? access.regionForOffset(line.getOffset(), oldIndentation.length()) : access.regionForOffset(line.getOffset(), 0));
            context.addReplacement(target.replaceWith(newIndentation));
        }
        if (lines.size() > 1) {
            ILineRegion line = lines.get(lines.size() - 1);
            context.addReplacement(line.getIndentation().replaceWith(indentationString + " "));
        }
        return context;
    }

    protected void enforceNewLine(WhitespaceReplacer replacer) {
        if (replacer.getRegion().getOffset() <= 0) {
            return;
        }
        Integer min = replacer.getFormatting().getNewLineMin();
        if (min == null || min < 1) {
            replacer.getFormatting().setNewLinesMin(1);
        }
    }

    protected void enforceSingleSpace(WhitespaceReplacer replacer) {
        if (replacer.getRegion().getOffset() <= 0) {
            return;
        }
        String space = replacer.getFormatting().getSpace();
        if (space == null || space.length() < 1) {
            replacer.getFormatting().setSpace(" ");
        }
    }

    protected int prefixOffset(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char charAt = string.charAt(i);
            if (this.prefix == charAt) {
                int j = i + 1;
                if (j < string.length() && Character.isWhitespace(string.charAt(j))) {
                    return j;
                }
                return i;
            }
            if (Character.isWhitespace(charAt)) continue;
            return -1;
        }
        return -1;
    }
}

