/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.FlowAnalyser;
import org.eclipse.n4js.flowgraphs.FlowEdge;
import org.eclipse.n4js.flowgraphs.N4JSFlowAnalyser;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalker;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorer;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitor;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.smith.ui.graph.CFEdge;
import org.eclipse.n4js.smith.ui.graph.CFNode;
import org.eclipse.n4js.smith.ui.graph.Edge;
import org.eclipse.n4js.smith.ui.graph.GraphProvider;
import org.eclipse.n4js.smith.ui.graph.Node;
import org.eclipse.xtext.EcoreUtil2;

public class CFGraphProvider
implements GraphProvider<Object, ControlFlowElement> {
    final N4JSFlowAnalyser flowAnalyzer = new N4JSFlowAnalyser();
    final Multimap<ControlFlowElement, CFNode> nodeMap = HashMultimap.create();
    final Map<ControlFlowElement, List<Edge>> edgesMap = new HashMap<ControlFlowElement, List<Edge>>();
    final NodesEdgesCollector nodesEdgesCollector = new NodesEdgesCollector();

    @Override
    public Collection<ControlFlowElement> getElements(Object input) {
        this.init(input);
        return this.nodeMap.keySet();
    }

    public CFNode getNode(ControlFlowElement element) {
        Collection nodes = this.nodeMap.get((Object)element);
        return nodes.isEmpty() ? null : (CFNode)nodes.iterator().next();
    }

    @Override
    public List<Edge> getConnectedEdges(Node node, List<Node> allNodes) {
        ControlFlowElement cfe = (ControlFlowElement)node.getElement();
        List<Edge> succs = this.edgesMap.get(cfe);
        if (succs == null) {
            return Collections.emptyList();
        }
        return succs;
    }

    public CFNode getEntryNode(ControlFlowElement container) {
        Collection nodes = this.nodeMap.get((Object)container);
        for (CFNode node : nodes) {
            if (!node.isEntry) continue;
            return node;
        }
        return null;
    }

    public CFNode getExitNode(ControlFlowElement container) {
        Collection nodes = this.nodeMap.get((Object)container);
        for (CFNode node : nodes) {
            if (!node.isExit) continue;
            return node;
        }
        return null;
    }

    public N4JSFlowAnalyser getFlowAnalyses() {
        return this.flowAnalyzer;
    }

    private void init(Object input) {
        this.performFlowAnalyses(input);
        this.flowAnalyzer.accept(new FlowAnalyser[]{this.nodesEdgesCollector});
    }

    private void performFlowAnalyses(Object input) {
        Script script = this.findScript(input);
        if (script != null) {
            this.flowAnalyzer.createGraphs(script);
        }
    }

    private Script findScript(Object input) {
        Resource res;
        EList contents;
        ResourceSet rs;
        if (input instanceof ResourceSet && !(rs = (ResourceSet)input).getResources().isEmpty() && !(contents = (res = (Resource)rs.getResources().get(0)).getContents()).isEmpty()) {
            Script script = (Script)EcoreUtil2.getContainerOfType((EObject)((EObject)contents.get(0)), Script.class);
            return script;
        }
        return null;
    }

    private class NodesEdgesCollector
    extends GraphVisitor {
        private int nodeIdx;

        NodesEdgesCollector() {
            super(TraverseDirection.Forward);
            this.nodeIdx = 0;
        }

        protected void initialize() {
            CFGraphProvider.this.nodeMap.clear();
            CFGraphProvider.this.edgesMap.clear();
        }

        protected void initializeContainer(ControlFlowElement curContainer) {
            this.requestActivation((GraphExplorerInternal)new EdgesExplorer());
        }

        protected void visit(ControlFlowElement cfe) {
            this.addNode(cfe, this.isDeadCodeNode());
        }

        private void addNode(ControlFlowElement cfe, boolean isDeadCode) {
            if (!CFGraphProvider.this.nodeMap.containsKey((Object)cfe)) {
                String label = FGUtils.getSourceText((EObject)cfe);
                String description = cfe.getClass().getSimpleName();
                CFNode node = new CFNode(cfe, label, description, this.nodeIdx++, isDeadCode, false, false);
                CFGraphProvider.this.nodeMap.put((Object)cfe, (Object)node);
            }
        }

        private void createEntryNode(ControlFlowElement cfe, boolean isDeadCode) {
            if (!(cfe instanceof Script) && CFGraphProvider.this.getEntryNode(cfe) == null) {
                String label = "ENTRY";
                String description = cfe.getClass().getSimpleName();
                CFNode node = new CFNode(cfe, label, description, this.nodeIdx++, isDeadCode, true, false);
                CFGraphProvider.this.nodeMap.put((Object)cfe, (Object)node);
            }
        }

        private void createExitNode(ControlFlowElement cfe, boolean isDeadCode) {
            if (!(cfe instanceof Script) && CFGraphProvider.this.getExitNode(cfe) == null) {
                String label = "EXIT";
                String description = cfe.getClass().getSimpleName();
                CFNode node = new CFNode(cfe, label, description, this.nodeIdx++, isDeadCode, false, true);
                CFGraphProvider.this.nodeMap.put((Object)cfe, (Object)node);
            }
        }

        class EdgesBranchWalker
        extends BranchWalker {
            EdgesBranchWalker() {
            }

            protected BranchWalker forkPath() {
                return new EdgesBranchWalker();
            }

            protected void visit(FlowEdge edge) {
                CFNode sNode = null;
                CFNode eNode = null;
                if (edge.start == this.getContainer()) {
                    NodesEdgesCollector.this.createEntryNode(edge.start, this.isDeadCodeNode());
                    sNode = CFGraphProvider.this.getEntryNode(edge.start);
                } else {
                    NodesEdgesCollector.this.addNode(edge.start, this.isDeadCodeNode());
                    sNode = CFGraphProvider.this.getNode(edge.start);
                }
                if (edge.end == this.getContainer()) {
                    NodesEdgesCollector.this.createExitNode(edge.end, this.isDeadCodeNode());
                    eNode = CFGraphProvider.this.getExitNode(edge.end);
                } else {
                    NodesEdgesCollector.this.addNode(edge.end, this.isDeadCodeNode());
                    eNode = CFGraphProvider.this.getNode(edge.end);
                }
                if (sNode != null && eNode != null) {
                    CFEdge cfEdge = new CFEdge("CF", sNode, (Node)eNode, edge.cfTypes, this.isDeadCodeNode());
                    if (!((NodesEdgesCollector)NodesEdgesCollector.this).CFGraphProvider.this.edgesMap.containsKey(edge.start)) {
                        ((NodesEdgesCollector)NodesEdgesCollector.this).CFGraphProvider.this.edgesMap.put(edge.start, new LinkedList());
                    }
                    List<Edge> cfEdges = ((NodesEdgesCollector)NodesEdgesCollector.this).CFGraphProvider.this.edgesMap.get(edge.start);
                    cfEdges.add(cfEdge);
                    this.removeDuplicatedDeadEdge(eNode, cfEdge, cfEdges);
                }
            }

            private void removeDuplicatedDeadEdge(Node eNode, CFEdge cfEdge, List<Edge> cfEdges) {
                CFEdge removeEdge = null;
                for (Edge e : cfEdges) {
                    if (cfEdge == e || e.getEndNodes().get(0) != eNode) continue;
                    removeEdge = (CFEdge)e;
                    break;
                }
                if (removeEdge != null) {
                    if (removeEdge.isDead) {
                        cfEdges.remove(removeEdge);
                    } else {
                        cfEdges.remove(cfEdge);
                    }
                }
            }
        }

        class EdgesExplorer
        extends GraphExplorer {
            EdgesExplorer() {
            }

            protected BranchWalker joinBranches(List<BranchWalker> branchWalkers) {
                return new EdgesBranchWalker();
            }

            protected BranchWalkerInternal firstBranchWalker() {
                return new EdgesBranchWalker();
            }
        }
    }
}

