/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.xtext.resource.containers.ResourceSetBasedAllContainersState;

public class N4FilebasedWorkspaceResourceSetContainerState
extends ResourceSetBasedAllContainersState {
    @Inject
    private IN4JSCore core;
    @Inject
    private N4JSModel model;

    public List<String> getVisibleContainerHandles(String handle) {
        URI containerURI = FileBasedWorkspace.uriFrom(handle);
        ArrayList<String> visibleContainers = new ArrayList<String>();
        visibleContainers.add(handle);
        Optional<? extends IN4JSProject> project = this.core.findProject(containerURI);
        if (!project.isPresent()) {
            throw new IllegalStateException("No project with handle '" + handle + "' known in current In4jscore.");
        }
        Iterable<IN4JSProject> dps = this.model.getSortedDependencies((IN4JSProject)project.get());
        dps.forEach(d -> {
            boolean bl = visibleContainers.add(FileBasedWorkspace.handleFrom(d.getLocation()));
        });
        return visibleContainers;
    }
}

